/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.cache.spring;

import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.ConcurrentMap;
import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.Ignition;
import org.apache.ignite.cache.spring.SpringCache;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.configuration.NearCacheConfiguration;
import org.jsr166.ConcurrentHashMap8;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.cache.Cache;
import org.springframework.cache.CacheManager;

public class SpringCacheManager
implements CacheManager,
InitializingBean {
    private final ConcurrentMap<String, SpringCache> caches = new ConcurrentHashMap8();
    private String cfgPath;
    private IgniteConfiguration cfg;
    private String gridName;
    private CacheConfiguration<Object, Object> dynamicCacheCfg;
    private NearCacheConfiguration<Object, Object> dynamicNearCacheCfg;
    private Ignite ignite;

    public String getConfigurationPath() {
        return this.cfgPath;
    }

    public void setConfigurationPath(String cfgPath) {
        this.cfgPath = cfgPath;
    }

    public IgniteConfiguration getConfiguration() {
        return this.cfg;
    }

    public void setConfiguration(IgniteConfiguration cfg) {
        this.cfg = cfg;
    }

    public String getGridName() {
        return this.gridName;
    }

    public void setGridName(String gridName) {
        this.gridName = gridName;
    }

    public CacheConfiguration<Object, Object> getDynamicCacheConfiguration() {
        return this.dynamicCacheCfg;
    }

    public void setDynamicCacheConfiguration(CacheConfiguration<Object, Object> dynamicCacheCfg) {
        this.dynamicCacheCfg = dynamicCacheCfg;
    }

    public NearCacheConfiguration<Object, Object> getDynamicNearCacheConfiguration() {
        return this.dynamicNearCacheCfg;
    }

    public void setDynamicNearCacheConfiguration(NearCacheConfiguration<Object, Object> dynamicNearCacheCfg) {
        this.dynamicNearCacheCfg = dynamicNearCacheCfg;
    }

    public void afterPropertiesSet() throws Exception {
        assert (this.ignite == null);
        if (this.cfgPath != null && this.cfg != null) {
            throw new IllegalArgumentException("Both 'configurationPath' and 'configuration' are provided. Set only one of these properties if you need to start a Ignite node inside of GridSpringCacheManager. If you already have a node running, omit both of them and set'gridName' property.");
        }
        this.ignite = this.cfgPath != null ? Ignition.start((String)this.cfgPath) : (this.cfg != null ? Ignition.start((IgniteConfiguration)this.cfg) : Ignition.ignite((String)this.gridName));
    }

    public Cache getCache(String name) {
        assert (this.ignite != null);
        SpringCache cache = (SpringCache)this.caches.get(name);
        if (cache == null) {
            CacheConfiguration cacheCfg = this.dynamicCacheCfg != null ? new CacheConfiguration(this.dynamicCacheCfg) : new CacheConfiguration();
            NearCacheConfiguration nearCacheCfg = this.dynamicNearCacheCfg != null ? new NearCacheConfiguration(this.dynamicNearCacheCfg) : null;
            cacheCfg.setName(name);
            cache = new SpringCache((IgniteCache<Object, Object>)(nearCacheCfg != null ? this.ignite.getOrCreateCache(cacheCfg, nearCacheCfg) : this.ignite.getOrCreateCache(cacheCfg)));
            SpringCache old = this.caches.putIfAbsent(name, cache);
            if (old != null) {
                cache = old;
            }
        }
        return cache;
    }

    public Collection<String> getCacheNames() {
        assert (this.ignite != null);
        return new ArrayList<String>(this.caches.keySet());
    }
}

