/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.h2.sql;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.cache.CacheException;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.processors.cache.query.CacheQueryPartitionInfo;
import org.apache.ignite.internal.processors.cache.query.GridCacheSqlQuery;
import org.apache.ignite.internal.processors.cache.query.GridCacheTwoStepQuery;
import org.apache.ignite.internal.processors.cache.query.QueryTable;
import org.apache.ignite.internal.processors.query.IgniteSQLException;
import org.apache.ignite.internal.processors.query.h2.H2Utils;
import org.apache.ignite.internal.processors.query.h2.IgniteH2Indexing;
import org.apache.ignite.internal.processors.query.h2.opt.GridH2CollocationModel;
import org.apache.ignite.internal.processors.query.h2.opt.GridH2RowDescriptor;
import org.apache.ignite.internal.processors.query.h2.opt.GridH2Table;
import org.apache.ignite.internal.processors.query.h2.sql.GridSqlAggregateFunction;
import org.apache.ignite.internal.processors.query.h2.sql.GridSqlAlias;
import org.apache.ignite.internal.processors.query.h2.sql.GridSqlArray;
import org.apache.ignite.internal.processors.query.h2.sql.GridSqlAst;
import org.apache.ignite.internal.processors.query.h2.sql.GridSqlColumn;
import org.apache.ignite.internal.processors.query.h2.sql.GridSqlConst;
import org.apache.ignite.internal.processors.query.h2.sql.GridSqlElement;
import org.apache.ignite.internal.processors.query.h2.sql.GridSqlFunction;
import org.apache.ignite.internal.processors.query.h2.sql.GridSqlFunctionType;
import org.apache.ignite.internal.processors.query.h2.sql.GridSqlJoin;
import org.apache.ignite.internal.processors.query.h2.sql.GridSqlOperation;
import org.apache.ignite.internal.processors.query.h2.sql.GridSqlOperationType;
import org.apache.ignite.internal.processors.query.h2.sql.GridSqlParameter;
import org.apache.ignite.internal.processors.query.h2.sql.GridSqlPlaceholder;
import org.apache.ignite.internal.processors.query.h2.sql.GridSqlQuery;
import org.apache.ignite.internal.processors.query.h2.sql.GridSqlQueryParser;
import org.apache.ignite.internal.processors.query.h2.sql.GridSqlSelect;
import org.apache.ignite.internal.processors.query.h2.sql.GridSqlSortColumn;
import org.apache.ignite.internal.processors.query.h2.sql.GridSqlSubquery;
import org.apache.ignite.internal.processors.query.h2.sql.GridSqlTable;
import org.apache.ignite.internal.processors.query.h2.sql.GridSqlType;
import org.apache.ignite.internal.processors.query.h2.sql.GridSqlUnion;
import org.apache.ignite.internal.util.lang.GridTreePrinter;
import org.apache.ignite.internal.util.tostring.GridToStringInclude;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.X;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.h2.command.Prepared;
import org.h2.command.dml.Query;
import org.h2.command.dml.SelectUnion;
import org.h2.table.IndexColumn;
import org.jetbrains.annotations.Nullable;

public class GridSqlQuerySplitter {
    private static final String MERGE_TABLE_SCHEMA = "PUBLIC";
    private static final String MERGE_TABLE_PREFIX = "__T";
    private static final String COLUMN_PREFIX = "__C";
    private static final String HAVING_COLUMN = "__H";
    private static final String UNIQUE_TABLE_ALIAS_SUFFIX = "__Z";
    private static final String EXPR_ALIAS_PREFIX = "__X";
    private int nextExprAliasId;
    private int nextTblAliasId;
    private int splitId = -1;
    private Set<QueryTable> tbls = new HashSet<QueryTable>();
    private Set<String> pushedDownCols = new HashSet<String>();
    private boolean rdcQrySimple;
    private GridCacheSqlQuery rdcSqlQry;
    private List<GridCacheSqlQuery> mapSqlQrys = new ArrayList<GridCacheSqlQuery>();
    private Object[] params;
    private boolean collocatedGrpBy;
    private IdentityHashMap<GridSqlAst, GridSqlAlias> uniqueFromAliases = new IdentityHashMap();
    private GridKernalContext ctx;

    public GridSqlQuerySplitter(Object[] params, boolean collocatedGrpBy, GridKernalContext ctx) {
        this.params = params;
        this.collocatedGrpBy = collocatedGrpBy;
        this.ctx = ctx;
    }

    private static GridSqlTable mergeTable(int idx) {
        return new GridSqlTable(MERGE_TABLE_SCHEMA, MERGE_TABLE_PREFIX + idx);
    }

    public static String mergeTableIdentifier(int idx) {
        return GridSqlQuerySplitter.mergeTable(idx).getSQL();
    }

    private String columnName(int idx) {
        return COLUMN_PREFIX + this.splitId + '_' + idx;
    }

    public static GridCacheTwoStepQuery split(Connection conn, Prepared prepared, Object[] params, boolean collocatedGrpBy, boolean distributedJoins, boolean enforceJoinOrder, IgniteH2Indexing h2) throws SQLException, IgniteCheckedException {
        if (params == null) {
            params = GridCacheSqlQuery.EMPTY_PARAMS;
        }
        GridSqlQuery qry = GridSqlQuerySplitter.parse(prepared, false);
        String originalSql = prepared.getSQL();
        boolean explain = qry.explain();
        qry.explain(false);
        GridSqlQuerySplitter splitter = new GridSqlQuerySplitter(params, collocatedGrpBy, h2.kernalContext());
        splitter.normalizeQuery(qry);
        qry = GridSqlQuerySplitter.parse(GridSqlQuerySplitter.optimize(h2, conn, qry.getSQL(), params, false, enforceJoinOrder), true);
        boolean forUpdate = GridSqlQueryParser.isForUpdateQuery(prepared);
        splitter.splitQuery(qry, forUpdate);
        assert (!F.isEmpty(splitter.mapSqlQrys)) : "map";
        assert (splitter.rdcSqlQry != null) : "rdc";
        if (distributedJoins) {
            boolean allCollocated = true;
            for (GridCacheSqlQuery mapSqlQry : splitter.mapSqlQrys) {
                Prepared prepared0 = GridSqlQuerySplitter.optimize(h2, conn, mapSqlQry.query(), mapSqlQry.parameters(params), true, enforceJoinOrder);
                allCollocated &= GridH2CollocationModel.isCollocated((Query)prepared0);
                mapSqlQry.query(GridSqlQuerySplitter.parse(prepared0, true).getSQL());
            }
            if (allCollocated) {
                distributedJoins = false;
            }
        }
        GridCacheTwoStepQuery twoStepQry = new GridCacheTwoStepQuery(originalSql, splitter.tbls);
        twoStepQry.reduceQuery(splitter.rdcSqlQry);
        for (GridCacheSqlQuery mapSqlQry : splitter.mapSqlQrys) {
            twoStepQry.addMapQuery(mapSqlQry);
        }
        twoStepQry.skipMergeTable(splitter.rdcQrySimple);
        twoStepQry.explain(explain);
        twoStepQry.distributedJoins(distributedJoins);
        twoStepQry.derivedPartitions(GridSqlQuerySplitter.mergePartitionsFromMultipleQueries(twoStepQry.mapQueries()));
        twoStepQry.forUpdate(forUpdate);
        return twoStepQry;
    }

    private void splitQuery(GridSqlQuery qry, boolean forUpdate) throws IgniteCheckedException {
        GridSqlSubquery fakeQryPrnt = new GridSqlSubquery(qry);
        QueryModel fakeQrymPrnt = new QueryModel(null, null, -1, null);
        this.buildQueryModel(fakeQrymPrnt, fakeQryPrnt, 0, null);
        assert (fakeQrymPrnt.size() == 1);
        QueryModel qrym = (QueryModel)fakeQrymPrnt.get(0);
        this.analyzeQueryModel(qrym);
        if (qrym.needSplitChild) {
            this.pushDownQueryModel(qrym);
            this.setupMergeJoinSorting(qrym);
        } else if (!qrym.needSplit) {
            GridSqlQuerySplitter.setNeedSplit(qrym);
        }
        this.splitQueryModel(qrym);
        qry = fakeQryPrnt.subquery();
        if (forUpdate) {
            assert (qry instanceof GridSqlSelect);
            GridSqlSelect sel = (GridSqlSelect)qry;
            sel.forUpdate(false);
        }
        String rdcQry = qry.getSQL();
        GridSqlQuerySplitter.checkNoDataTablesInReduceQuery(qry, rdcQry);
        this.rdcSqlQry = new GridCacheSqlQuery(rdcQry);
        this.rdcQrySimple = qry.simpleQuery();
        GridSqlQuerySplitter.setupParameters(this.rdcSqlQry, qry, this.params);
    }

    private void pushDownQueryModel(QueryModel qrym) {
        if (qrym.type == Type.UNION) {
            assert (qrym.needSplitChild);
            for (int i = 0; i < qrym.size(); ++i) {
                this.pushDownQueryModel((QueryModel)qrym.get(i));
            }
        } else if (qrym.type == Type.SELECT) {
            if (!qrym.needSplit) {
                assert (qrym.needSplitChild);
                this.pushDownQueryModelSelect(qrym);
            }
        } else {
            throw new IllegalStateException("Type: " + (Object)((Object)qrym.type));
        }
    }

    @Deprecated
    private static void debug(String label, String info) {
        X.println();
        X.println((String)("  == " + label + " == "), (Object[])new Object[0]);
        X.println((String)info, (Object[])new Object[0]);
        X.println((String)"  ======================= ", (Object[])new Object[0]);
    }

    private static void checkNoDataTablesInReduceQuery(GridSqlAst ast, String rdcQry) {
        if (ast instanceof GridSqlTable) {
            if (((GridSqlTable)ast).dataTable() != null) {
                throw new IgniteException("Failed to generate REDUCE query. Data table found: " + ast.getSQL() + " \n" + rdcQry);
            }
        } else {
            for (int i = 0; i < ast.size(); ++i) {
                GridSqlQuerySplitter.checkNoDataTablesInReduceQuery(ast.child(i), rdcQry);
            }
        }
    }

    private boolean hasPushedDownColumn(GridSqlAst expr) {
        if (expr instanceof GridSqlColumn) {
            return this.pushedDownCols.contains(((GridSqlColumn)expr).columnName());
        }
        for (int i = 0; i < expr.size(); ++i) {
            if (!this.hasPushedDownColumn((GridSqlAst)expr.child(i))) continue;
            return true;
        }
        return false;
    }

    private static boolean hasLeftJoin(GridSqlAst from) {
        while (from instanceof GridSqlJoin) {
            GridSqlJoin join = (GridSqlJoin)from;
            assert (!(join.rightTable() instanceof GridSqlJoin));
            if (join.isLeftOuter()) {
                return true;
            }
            from = join.leftTable();
        }
        return false;
    }

    private void pushDownQueryModelSelect(QueryModel qrym) {
        assert (qrym.type == Type.SELECT) : qrym.type;
        boolean hasLeftJoin = GridSqlQuerySplitter.hasLeftJoin(((GridSqlSelect)qrym.ast()).from());
        int begin = -1;
        for (int i = 0; i < qrym.size(); ++i) {
            QueryModel child = (QueryModel)qrym.get(i);
            boolean hasPushedDownCol = false;
            if (child.isQuery() && (child.needSplitChild || child.needSplit) || (hasPushedDownCol = hasLeftJoin && i != 0 && this.hasPushedDownColumn(GridSqlQuerySplitter.findJoin(qrym, i).on()))) {
                if (hasPushedDownCol && begin == -1) {
                    begin = i - 1;
                }
                if (begin != -1) {
                    this.pushDownQueryModelRange(qrym, begin, i - 1);
                    i = begin + 1;
                    assert (qrym.get(i) == child);
                    int n = begin = hasPushedDownCol ? i : -1;
                }
                if (!child.needSplitChild) continue;
                this.pushDownQueryModel(child);
                continue;
            }
            if (begin != -1) continue;
            begin = i;
        }
        if (begin != -1) {
            this.pushDownQueryModelRange(qrym, begin, qrym.size() - 1);
        }
    }

    private void setupMergeJoinSorting(QueryModel qrym) {
        if (qrym.type == Type.UNION) {
            for (int i = 0; i < qrym.size(); ++i) {
                this.setupMergeJoinSorting((QueryModel)qrym.get(i));
            }
        } else if (qrym.type == Type.SELECT) {
            if (!qrym.needSplit) {
                boolean needSplitChild = false;
                for (int i = 0; i < qrym.size(); ++i) {
                    QueryModel child = (QueryModel)qrym.get(i);
                    assert (child.isQuery()) : child.type;
                    if (child.needSplit) {
                        needSplitChild = true;
                        continue;
                    }
                    this.setupMergeJoinSorting(child);
                }
                if (needSplitChild && qrym.size() > 1) {
                    this.setupMergeJoinSortingSelect(qrym);
                }
            }
        } else {
            throw new IllegalStateException("Type: " + (Object)((Object)qrym.type));
        }
    }

    private void setupMergeJoinSortingSelect(QueryModel qrym) {
        for (int i = 1; i < qrym.size(); ++i) {
            QueryModel child = (QueryModel)qrym.get(i);
            if (!child.needSplit) continue;
            if (i > 1) {
                this.doPushDownQueryModelRange(qrym, 0, i - 1, false);
                i = 1;
                assert (qrym.get(i) == child);
            }
            this.injectSortingFirstJoin(qrym);
        }
    }

    private void injectSortingFirstJoin(QueryModel qrym) {
        GridSqlJoin join = GridSqlQuerySplitter.findJoin(qrym, 0);
        GridSqlAlias leftTbl = (GridSqlAlias)join.leftTable();
        GridSqlAlias rightTbl = (GridSqlAlias)join.rightTable();
        ArrayList<AndCondition> andConditions = new ArrayList<AndCondition>();
        this.collectAndConditions(andConditions, join, 2);
        this.collectAndConditions(andConditions, qrym.ast(), 3);
        ArrayList<GridSqlColumn> leftOrder = new ArrayList<GridSqlColumn>();
        ArrayList<GridSqlColumn> rightOrder = new ArrayList<GridSqlColumn>();
        for (int i = 0; i < andConditions.size(); ++i) {
            AndCondition and = (AndCondition)andConditions.get(i);
            GridSqlOperation op = (GridSqlOperation)and.ast();
            if (op.operationType() != GridSqlOperationType.EQUAL) continue;
            Object leftExpr = op.child(0);
            Object rightExpr = op.child(1);
            if (!(leftExpr instanceof GridSqlColumn) || !(rightExpr instanceof GridSqlColumn)) continue;
            GridSqlAst leftFrom = ((GridSqlColumn)leftExpr).expressionInFrom();
            GridSqlAst rightFrom = ((GridSqlColumn)rightExpr).expressionInFrom();
            if (leftFrom == leftTbl && rightFrom == rightTbl) {
                leftOrder.add((GridSqlColumn)leftExpr);
                rightOrder.add((GridSqlColumn)rightExpr);
                continue;
            }
            if (leftFrom != rightTbl || rightFrom != leftTbl) continue;
            leftOrder.add((GridSqlColumn)rightExpr);
            rightOrder.add((GridSqlColumn)leftExpr);
        }
        this.injectOrderBy(leftTbl, leftOrder);
        this.injectOrderBy(rightTbl, rightOrder);
    }

    private void injectOrderBy(GridSqlAlias subQryAlias, List<GridSqlColumn> orderByCols) {
        if (orderByCols.isEmpty()) {
            return;
        }
        Object qry = ((GridSqlSubquery)GridSqlAlias.unwrap(subQryAlias)).subquery();
        GridSqlSelect select = this.leftmostSelect((GridSqlQuery)qry);
        BitSet set = new BitSet();
        for (int i = 0; i < orderByCols.size(); ++i) {
            GridSqlColumn col = orderByCols.get(i);
            int colIdx = 0;
            while (true) {
                String colName;
                GridSqlAst expr;
                if ((expr = select.column(colIdx)) instanceof GridSqlAlias) {
                    colName = ((GridSqlAlias)expr).alias();
                } else if (expr instanceof GridSqlColumn) {
                    colName = ((GridSqlColumn)expr).columnName();
                } else {
                    throw new IllegalStateException();
                }
                if (colName.equals(col.columnName())) break;
                ++colIdx;
            }
            if (set.get(colIdx)) continue;
            set.set(colIdx, true);
            ((GridSqlQuery)qry).addSort(new GridSqlSortColumn(colIdx, true, false, false));
        }
    }

    private GridSqlSelect leftmostSelect(GridSqlQuery qry) {
        while (qry instanceof GridSqlUnion) {
            qry = ((GridSqlUnion)qry).left();
        }
        return (GridSqlSelect)qry;
    }

    private void pushDownQueryModelRange(QueryModel qrym, int begin, int end) {
        assert (end >= begin);
        if (begin == end && ((QueryModel)qrym.get(end)).isQuery()) {
            GridSqlQuerySplitter.setNeedSplit((QueryModel)qrym.get(end));
        } else {
            this.doPushDownQueryModelRange(qrym, begin, end, true);
        }
    }

    private static void setNeedSplit(QueryModel qrym) {
        if (qrym.type == Type.SELECT) {
            assert (!qrym.needSplitChild);
            qrym.needSplit = true;
        } else if (qrym.type == Type.UNION) {
            qrym.needSplitChild = true;
            for (QueryModel s : qrym) {
                assert (s.type == Type.SELECT) : s.type;
                s.needSplit = true;
            }
        } else {
            throw new IllegalStateException("Type: " + (Object)((Object)qrym.type));
        }
    }

    private static void collectFromAliases(GridSqlSelect select, Set<GridSqlAlias> aliases) {
        GridSqlAst from = select.from();
        if (from == null) {
            return;
        }
        while (from instanceof GridSqlJoin) {
            GridSqlElement right = ((GridSqlJoin)from).rightTable();
            aliases.add((GridSqlAlias)right);
            from = ((GridSqlJoin)from).leftTable();
        }
        aliases.add((GridSqlAlias)from);
    }

    private void doPushDownQueryModelRange(QueryModel qrym, int begin, int end, boolean needSplit) {
        int x;
        GridSqlSelect wrapSelect = new GridSqlSelect();
        GridSqlSubquery wrapSubqry = new GridSqlSubquery(wrapSelect);
        GridSqlAlias wrapAlias = GridSqlQuerySplitter.alias(this.nextUniqueTableAlias(null), wrapSubqry);
        QueryModel wrapQrym = new QueryModel(Type.SELECT, wrapSubqry, 0, wrapAlias);
        wrapQrym.needSplit = needSplit;
        GridSqlSelect select = (GridSqlSelect)qrym.ast();
        Set<GridSqlAlias> tblAliases = GridSqlQuerySplitter.newIdentityHashSet();
        HashMap<String, GridSqlAlias> cols = new HashMap<String, GridSqlAlias>();
        for (int i = begin; i <= end; ++i) {
            GridSqlAlias uniqueTblAlias = ((QueryModel)qrym.get((int)i)).uniqueAlias;
            assert (uniqueTblAlias != null) : select.getSQL();
            tblAliases.add(uniqueTblAlias);
        }
        this.pushDownSelectColumns(tblAliases, cols, wrapAlias, select);
        this.pushDownWhereConditions(tblAliases, cols, wrapAlias, select);
        this.pushDownJoins(tblAliases, cols, qrym, begin, end, wrapAlias);
        for (GridSqlAlias col : cols.values()) {
            wrapSelect.addColumn(col, true);
        }
        for (int i = begin; i <= end; ++i) {
            QueryModel child = (QueryModel)qrym.get(i);
            wrapQrym.add(child);
        }
        qrym.set(begin, wrapQrym);
        for (int i = x = begin + 1; i <= end; ++i) {
            qrym.remove(x);
        }
    }

    private void pushDownJoins(Set<GridSqlAlias> tblAliases, Map<String, GridSqlAlias> cols, QueryModel qrym, int begin, int end, GridSqlAlias wrapAlias) {
        GridSqlJoin endJoin;
        GridSqlJoin afterBeginJoin;
        GridSqlJoin beginJoin;
        GridSqlJoin endJoin2;
        GridSqlSelect select = (GridSqlSelect)qrym.ast();
        GridSqlSelect wrapSelect = (GridSqlSelect)((GridSqlSubquery)GridSqlAlias.unwrap(wrapAlias)).subquery();
        int last = qrym.size() - 1;
        if (begin == end) {
            endJoin2 = GridSqlQuerySplitter.findJoin(qrym, end);
            wrapSelect.from(((QueryModel)qrym.get((int)end)).uniqueAlias);
            endJoin2.child(end == 0 ? 0 : 1, wrapAlias);
        } else if (end == last) {
            assert (begin > 0);
            beginJoin = GridSqlQuerySplitter.findJoin(qrym, begin);
            afterBeginJoin = GridSqlQuerySplitter.findJoin(qrym, begin + 1);
            endJoin = GridSqlQuerySplitter.findJoin(qrym, end);
            wrapSelect.from(endJoin);
            afterBeginJoin.leftTable(beginJoin.rightTable());
            beginJoin.rightTable(wrapAlias);
            select.from(beginJoin);
        } else if (begin == 0) {
            endJoin2 = GridSqlQuerySplitter.findJoin(qrym, end);
            GridSqlJoin afterEndJoin = GridSqlQuerySplitter.findJoin(qrym, end + 1);
            wrapSelect.from(endJoin2);
            afterEndJoin.leftTable(wrapAlias);
        } else {
            beginJoin = GridSqlQuerySplitter.findJoin(qrym, begin);
            afterBeginJoin = GridSqlQuerySplitter.findJoin(qrym, begin + 1);
            endJoin = GridSqlQuerySplitter.findJoin(qrym, end);
            GridSqlJoin afterEndJoin = GridSqlQuerySplitter.findJoin(qrym, end + 1);
            wrapSelect.from(endJoin);
            afterEndJoin.leftTable(beginJoin);
            afterBeginJoin.leftTable(beginJoin.rightTable());
            beginJoin.rightTable(wrapAlias);
        }
        GridSqlAst from = select.from();
        while (from instanceof GridSqlJoin) {
            assert (!(((GridSqlJoin)from).rightTable() instanceof GridSqlJoin));
            this.pushDownColumnsInExpression(tblAliases, cols, wrapAlias, from, 2);
            from = from.child(0);
        }
    }

    private void pushDownSelectColumns(Set<GridSqlAlias> tblAliases, Map<String, GridSqlAlias> cols, GridSqlAlias wrapAlias, GridSqlSelect select) {
        for (int i = 0; i < select.allColumns(); ++i) {
            GridSqlAst expr = select.column(i);
            if (!(expr instanceof GridSqlAlias)) {
                String alias = expr instanceof GridSqlColumn ? ((GridSqlColumn)expr).columnName() : EXPR_ALIAS_PREFIX + i;
                expr = GridSqlQuerySplitter.alias(alias, expr);
                select.setColumn(i, expr);
            }
            if (this.isAllRelatedToTables(tblAliases, GridSqlQuerySplitter.newIdentityHashSet(), expr) && !GridSqlQuerySplitter.hasAggregates(expr)) {
                this.pushDownColumn(tblAliases, cols, wrapAlias, expr, 0);
                continue;
            }
            this.pushDownColumnsInExpression(tblAliases, cols, wrapAlias, expr, 0);
        }
    }

    private void pushDownColumnsInExpression(Set<GridSqlAlias> tblAliases, Map<String, GridSqlAlias> cols, GridSqlAlias wrapAlias, GridSqlAst prnt, int childIdx) {
        Object child = prnt.child(childIdx);
        if (child instanceof GridSqlColumn) {
            this.pushDownColumn(tblAliases, cols, wrapAlias, prnt, childIdx);
        } else {
            for (int i = 0; i < child.size(); ++i) {
                this.pushDownColumnsInExpression(tblAliases, cols, wrapAlias, (GridSqlAst)child, i);
            }
        }
    }

    private void pushDownColumn(Set<GridSqlAlias> tblAliases, Map<String, GridSqlAlias> cols, GridSqlAlias wrapAlias, GridSqlAst prnt, int childIdx) {
        String uniqueColAlias;
        Object expr = prnt.child(childIdx);
        if (expr instanceof GridSqlColumn) {
            GridSqlColumn col = (GridSqlColumn)prnt.child(childIdx);
            GridSqlAlias tblAlias = (GridSqlAlias)col.expressionInFrom();
            assert (tblAlias != null);
            if (!tblAliases.contains(tblAlias)) {
                return;
            }
            uniqueColAlias = this.uniquePushDownColumnAlias(col);
        } else {
            uniqueColAlias = EXPR_ALIAS_PREFIX + this.nextExprAliasId++ + "__" + ((GridSqlAlias)prnt).alias();
        }
        GridSqlType resType = expr.resultType();
        GridSqlAlias colAlias = cols.get(uniqueColAlias);
        if (colAlias == null) {
            colAlias = GridSqlQuerySplitter.alias(uniqueColAlias, expr);
            cols.put(uniqueColAlias, colAlias);
            this.pushedDownCols.add(uniqueColAlias);
        }
        GridSqlColumn col = GridSqlQuerySplitter.column(uniqueColAlias);
        col.expressionInFrom(wrapAlias);
        col.resultType(resType);
        prnt.child(childIdx, col);
    }

    private String uniquePushDownColumnAlias(GridSqlColumn col) {
        String colName = col.columnName();
        if (this.pushedDownCols.contains(colName)) {
            return colName;
        }
        GridSqlAlias uniqueTblAlias = (GridSqlAlias)col.expressionInFrom();
        return GridSqlQuerySplitter.uniquePushDownColumnAlias(uniqueTblAlias.alias(), colName);
    }

    private static String uniquePushDownColumnAlias(String uniqueTblAlias, String colName) {
        assert (!F.isEmpty((String)uniqueTblAlias));
        assert (!F.isEmpty((String)colName));
        return uniqueTblAlias + "__" + colName;
    }

    private void pushDownWhereConditions(Set<GridSqlAlias> tblAliases, Map<String, GridSqlAlias> cols, GridSqlAlias wrapAlias, GridSqlSelect select) {
        if (select.where() == null) {
            return;
        }
        GridSqlSelect wrapSelect = (GridSqlSelect)((GridSqlSubquery)GridSqlAlias.unwrap(wrapAlias)).subquery();
        ArrayList<AndCondition> andConditions = new ArrayList<AndCondition>();
        this.collectAndConditions(andConditions, select, 3);
        for (int i = 0; i < andConditions.size(); ++i) {
            AndCondition c = (AndCondition)andConditions.get(i);
            GridSqlAst condition = c.ast();
            if (this.isAllRelatedToTables(tblAliases, GridSqlQuerySplitter.newIdentityHashSet(), condition)) {
                if (GridSqlQuerySplitter.isTrue(condition)) continue;
                c.prnt.child(c.childIdx, GridSqlConst.TRUE);
                wrapSelect.whereAnd(condition);
                continue;
            }
            this.pushDownColumnsInExpression(tblAliases, cols, wrapAlias, c.prnt, c.childIdx);
        }
    }

    private static boolean isTrue(GridSqlAst expr) {
        return expr instanceof GridSqlConst && ((GridSqlConst)expr).value() == GridSqlConst.TRUE.value();
    }

    private boolean isAllRelatedToTables(Set<GridSqlAlias> tblAliases, Set<GridSqlAlias> locSubQryTblAliases, GridSqlAst ast) {
        if (ast instanceof GridSqlColumn) {
            GridSqlColumn col = (GridSqlColumn)ast;
            if (!tblAliases.contains(col.expressionInFrom()) && !locSubQryTblAliases.contains(col.expressionInFrom())) {
                return false;
            }
        } else {
            if (ast instanceof GridSqlSelect) {
                GridSqlQuerySplitter.collectFromAliases((GridSqlSelect)ast, locSubQryTblAliases);
            }
            for (int i = 0; i < ast.size(); ++i) {
                if (this.isAllRelatedToTables(tblAliases, locSubQryTblAliases, (GridSqlAst)ast.child(i))) continue;
                return false;
            }
        }
        return true;
    }

    private void collectAndConditions(List<AndCondition> andConditions, GridSqlAst prnt, int childIdx) {
        GridSqlOperation op;
        Object child = prnt.child(childIdx);
        if (child instanceof GridSqlOperation && (op = (GridSqlOperation)child).operationType() == GridSqlOperationType.AND) {
            this.collectAndConditions(andConditions, op, 0);
            this.collectAndConditions(andConditions, op, 1);
            return;
        }
        if (!GridSqlQuerySplitter.isTrue(child)) {
            andConditions.add(new AndCondition(prnt, childIdx));
        }
    }

    private static <X> Set<X> newIdentityHashSet() {
        return Collections.newSetFromMap(new IdentityHashMap());
    }

    private static GridSqlJoin findJoin(QueryModel qrym, int idx) {
        assert (qrym.type == Type.SELECT) : qrym.type;
        assert (qrym.size() > 1);
        assert (idx < qrym.size()) : idx;
        if (idx == 0) {
            idx = 1;
        }
        GridSqlJoin join = (GridSqlJoin)((GridSqlSelect)qrym.ast()).from();
        for (int i = qrym.size() - 1; i > idx; --i) {
            join = (GridSqlJoin)join.leftTable();
        }
        return join;
    }

    private void splitQueryModel(QueryModel qrym) throws IgniteCheckedException {
        switch (qrym.type) {
            case SELECT: {
                if (qrym.needSplit) {
                    this.splitSelect(qrym.prnt, qrym.childIdx);
                    break;
                }
            }
            case UNION: {
                for (int i = 0; i < qrym.size(); ++i) {
                    this.splitQueryModel((QueryModel)qrym.get(i));
                }
                break;
            }
            default: {
                throw new IllegalStateException("Type: " + (Object)((Object)qrym.type));
            }
        }
    }

    private void analyzeQueryModel(QueryModel qrym) {
        QueryModel child;
        int i;
        if (!qrym.isQuery()) {
            return;
        }
        for (i = 0; i < qrym.size(); ++i) {
            child = (QueryModel)qrym.get(i);
            this.analyzeQueryModel(child);
            if (!child.needSplit && !child.needSplitChild) continue;
            qrym.needSplitChild = true;
        }
        if (qrym.type == Type.SELECT) {
            if (!qrym.needSplitChild) {
                qrym.needSplit = this.needSplitSelect((GridSqlSelect)qrym.ast());
            }
        } else if (qrym.type == Type.UNION) {
            if (!(qrym.needSplitChild || qrym.unionAll && !GridSqlQuerySplitter.hasOffsetLimit((GridSqlQuery)qrym.ast()))) {
                qrym.needSplitChild = true;
            }
            if (qrym.needSplitChild) {
                for (i = 0; i < qrym.size(); ++i) {
                    child = (QueryModel)qrym.get(i);
                    assert (child.type == Type.SELECT) : child.type;
                    if (child.needSplitChild || child.needSplit) continue;
                    child.needSplit = true;
                }
            }
        } else {
            throw new IllegalStateException("Type: " + (Object)((Object)qrym.type));
        }
    }

    private void buildQueryModel(QueryModel prntModel, GridSqlAst prnt, int childIdx, GridSqlAlias uniqueAlias) {
        Object child = prnt.child(childIdx);
        assert (child != null);
        if (child instanceof GridSqlSelect) {
            QueryModel model = new QueryModel(Type.SELECT, prnt, childIdx, uniqueAlias);
            prntModel.add(model);
            this.buildQueryModel(model, (GridSqlAst)child, 2, null);
        } else if (child instanceof GridSqlUnion) {
            QueryModel model;
            if (prntModel.type == Type.UNION) {
                model = prntModel;
            } else {
                model = new QueryModel(Type.UNION, prnt, childIdx, uniqueAlias);
                prntModel.add(model);
            }
            if (((GridSqlUnion)child).unionType() != SelectUnion.UnionType.UNION_ALL) {
                model.unionAll = false;
            }
            this.buildQueryModel(model, (GridSqlAst)child, 2, null);
            this.buildQueryModel(model, (GridSqlAst)child, 3, null);
        } else {
            assert (prntModel.type == Type.SELECT) : prntModel.type;
            if (child instanceof GridSqlAlias) {
                this.buildQueryModel(prntModel, (GridSqlAst)child, 0, (GridSqlAlias)child);
            } else if (child instanceof GridSqlJoin) {
                this.buildQueryModel(prntModel, (GridSqlAst)child, 0, uniqueAlias);
                this.buildQueryModel(prntModel, (GridSqlAst)child, 1, uniqueAlias);
            } else {
                assert (prnt == uniqueAlias) : prnt.getClass();
                if (child instanceof GridSqlTable) {
                    prntModel.add(new QueryModel(Type.TABLE, prnt, childIdx, uniqueAlias));
                } else if (child instanceof GridSqlSubquery) {
                    this.buildQueryModel(prntModel, (GridSqlAst)child, 0, uniqueAlias);
                } else if (child instanceof GridSqlFunction) {
                    prntModel.add(new QueryModel(Type.FUNCTION, prnt, childIdx, uniqueAlias));
                } else {
                    throw new IllegalStateException("Unknown child type: " + child.getClass());
                }
            }
        }
    }

    private static boolean hasOffsetLimit(GridSqlQuery qry) {
        return qry.limit() != null || qry.offset() != null;
    }

    private boolean needSplitSelect(GridSqlSelect select) {
        if (select.distinct()) {
            return true;
        }
        if (GridSqlQuerySplitter.hasOffsetLimit(select)) {
            return true;
        }
        if (this.collocatedGrpBy) {
            return false;
        }
        if (select.groupColumns() != null) {
            return true;
        }
        for (int i = 0; i < select.allColumns(); ++i) {
            if (!GridSqlQuerySplitter.hasAggregates(select.column(i))) continue;
            return true;
        }
        return false;
    }

    private void splitSelect(GridSqlAst prnt, int childIdx) throws IgniteCheckedException {
        boolean hasSubQueries;
        int i;
        if (++this.splitId > 99) {
            throw new CacheException("Too complex query to process.");
        }
        GridSqlSelect mapQry = (GridSqlSelect)prnt.child(childIdx);
        int visibleCols = mapQry.visibleColumns();
        ArrayList<GridSqlAst> rdcExps = new ArrayList<GridSqlAst>(visibleCols);
        ArrayList<GridSqlAst> mapExps = new ArrayList<GridSqlAst>(mapQry.allColumns());
        mapExps.addAll(mapQry.columns(false));
        HashSet<String> colNames = new HashSet<String>();
        int havingCol = mapQry.havingColumn();
        boolean distinctAggregateFound = false;
        if (!this.collocatedGrpBy) {
            int len = mapExps.size();
            for (int i2 = 0; i2 < len; ++i2) {
                distinctAggregateFound |= GridSqlQuerySplitter.hasDistinctAggregates((GridSqlAst)mapExps.get(i2));
            }
        }
        boolean aggregateFound = distinctAggregateFound;
        int len = mapExps.size();
        for (int i3 = 0; i3 < len; ++i3) {
            aggregateFound |= this.splitSelectExpression(mapExps, rdcExps, colNames, i3, this.collocatedGrpBy, i3 == havingCol, distinctAggregateFound);
        }
        assert (!this.collocatedGrpBy || !aggregateFound);
        GridSqlSelect rdcQry = new GridSqlSelect().from(GridSqlQuerySplitter.mergeTable(this.splitId));
        mapQry.clearColumns();
        for (GridSqlAst exp : mapExps) {
            mapQry.addColumn(exp, true);
        }
        for (i = 0; i < visibleCols; ++i) {
            rdcQry.addColumn((GridSqlAst)rdcExps.get(i), true);
        }
        for (i = visibleCols; i < rdcExps.size(); ++i) {
            rdcQry.addColumn((GridSqlAst)rdcExps.get(i), false);
        }
        for (i = rdcExps.size(); i < mapExps.size(); ++i) {
            rdcQry.addColumn(GridSqlQuerySplitter.column(((GridSqlAlias)mapExps.get(i)).alias()), false);
        }
        if (mapQry.groupColumns() != null && !this.collocatedGrpBy) {
            rdcQry.groupColumns(mapQry.groupColumns());
            if (distinctAggregateFound) {
                mapQry.groupColumns(null);
            }
        }
        if (havingCol >= 0 && !this.collocatedGrpBy) {
            for (i = visibleCols; i < rdcQry.allColumns(); ++i) {
                GridSqlAst c = rdcQry.column(i);
                if (!(c instanceof GridSqlAlias) || !HAVING_COLUMN.equals(((GridSqlAlias)c).alias())) continue;
                rdcQry.havingColumn(i);
                break;
            }
            mapQry.havingColumn(-1);
        }
        if (!mapQry.sort().isEmpty()) {
            for (GridSqlSortColumn sortCol : mapQry.sort()) {
                rdcQry.addSort(sortCol);
            }
            if (aggregateFound) {
                mapQry.clearSort();
            }
        }
        if (mapQry.limit() != null) {
            rdcQry.limit(mapQry.limit());
            if (aggregateFound) {
                mapQry.limit(null);
            }
        }
        if (mapQry.offset() != null) {
            rdcQry.offset(mapQry.offset());
            if (mapQry.limit() != null) {
                mapQry.limit(GridSqlQuerySplitter.op(GridSqlOperationType.PLUS, mapQry.offset(), mapQry.limit()));
            }
            mapQry.offset(null);
        }
        if (mapQry.distinct()) {
            mapQry.distinct(!aggregateFound && mapQry.groupColumns() == null && mapQry.havingColumn() < 0);
            rdcQry.distinct(true);
        }
        boolean bl = hasSubQueries = this.hasSubQueries(mapQry.where()) || this.hasSubQueries(mapQry.from());
        if (!hasSubQueries) {
            for (int i4 = 0; i4 < mapQry.columns(false).size(); ++i4) {
                if (!this.hasSubQueries(mapQry.column(i4))) continue;
                hasSubQueries = true;
                break;
            }
        }
        prnt.child(childIdx, rdcQry);
        GridCacheSqlQuery map = new GridCacheSqlQuery(mapQry.getSQL());
        GridSqlQuerySplitter.setupParameters(map, mapQry, this.params);
        map.columns(this.collectColumns(mapExps));
        map.sortColumns(mapQry.sort());
        map.partitioned(GridSqlQuerySplitter.hasPartitionedTables(mapQry));
        map.hasSubQueries(hasSubQueries);
        if (map.isPartitioned()) {
            map.derivedPartitions((Object[])GridSqlQuerySplitter.derivePartitionsFromQuery(mapQry, this.ctx));
        }
        this.mapSqlQrys.add(map);
    }

    private static boolean hasPartitionedTables(GridSqlAst ast) {
        if (ast instanceof GridSqlTable) {
            if (((GridSqlTable)ast).dataTable() != null) {
                return ((GridSqlTable)ast).dataTable().isPartitioned();
            }
            return false;
        }
        for (int i = 0; i < ast.size(); ++i) {
            if (!GridSqlQuerySplitter.hasPartitionedTables(ast.child(i))) continue;
            return true;
        }
        return false;
    }

    private boolean hasSubQueries(GridSqlAst ast) {
        if (ast == null) {
            return false;
        }
        if (ast instanceof GridSqlSubquery) {
            return true;
        }
        for (int childIdx = 0; childIdx < ast.size(); ++childIdx) {
            if (!this.hasSubQueries((GridSqlAst)ast.child(childIdx))) continue;
            return true;
        }
        return false;
    }

    private static void setupParameters(GridCacheSqlQuery sqlQry, GridSqlQuery qryAst, Object[] params) {
        TreeSet<Integer> paramIdxs = new TreeSet<Integer>();
        GridSqlQuerySplitter.findParamsQuery(qryAst, params, paramIdxs);
        int[] paramIdxsArr = new int[paramIdxs.size()];
        int i = 0;
        for (Integer paramIdx : paramIdxs) {
            paramIdxsArr[i++] = paramIdx;
        }
        sqlQry.parameterIndexes(paramIdxsArr);
    }

    private LinkedHashMap<String, ?> collectColumns(List<GridSqlAst> cols) {
        LinkedHashMap<String, GridSqlType> res = new LinkedHashMap<String, GridSqlType>(cols.size(), 1.0f, false);
        for (int i = 0; i < cols.size(); ++i) {
            GridSqlAst col = cols.get(i);
            GridSqlType t = col.resultType();
            if (t == null) {
                throw new NullPointerException("Column type: " + col);
            }
            if (t == GridSqlType.UNKNOWN) {
                throw new IllegalStateException("Unknown type: " + col);
            }
            String alias = col instanceof GridSqlAlias ? ((GridSqlAlias)col).alias() : this.columnName(i);
            if (res.put(alias, t) == null) continue;
            throw new IllegalStateException("Alias already exists: " + alias);
        }
        return res;
    }

    private static GridSqlQuery parse(Prepared prepared, boolean useOptimizedSubqry) {
        return (GridSqlQuery)new GridSqlQueryParser(useOptimizedSubqry).parse(prepared);
    }

    private static Prepared optimize(IgniteH2Indexing h2, Connection c, String qry, Object[] params, boolean distributedJoins, boolean enforceJoinOrder) throws SQLException, IgniteCheckedException {
        H2Utils.setupConnection(c, distributedJoins, enforceJoinOrder);
        try (PreparedStatement s = c.prepareStatement(qry);){
            h2.bindParameters(s, F.asList((Object[])params));
            Prepared prepared = GridSqlQueryParser.prepared(s);
            return prepared;
        }
    }

    private void normalizeQuery(GridSqlQuery qry) {
        if (qry instanceof GridSqlUnion) {
            GridSqlUnion union = (GridSqlUnion)qry;
            this.normalizeQuery(union.left());
            this.normalizeQuery(union.right());
        } else {
            GridSqlSelect select = (GridSqlSelect)qry;
            this.normalizeFrom(select, 2, false);
            List<GridSqlAst> cols = select.columns(false);
            for (int i = 0; i < cols.size(); ++i) {
                this.normalizeExpression(select, GridSqlSelect.childIndexForColumn(i));
            }
            this.normalizeExpression(select, 3);
        }
        this.normalizeExpression(qry, 0);
        this.normalizeExpression(qry, 1);
    }

    private void generateUniqueAlias(GridSqlAst prnt, int childIdx) {
        Object child = prnt.child(childIdx);
        Object tbl = GridSqlAlias.unwrap(child);
        assert (tbl instanceof GridSqlTable || tbl instanceof GridSqlSubquery || tbl instanceof GridSqlFunction) : tbl.getClass();
        String uniqueAlias = this.nextUniqueTableAlias(tbl != child ? ((GridSqlAlias)child).alias() : null);
        GridSqlAlias uniqueAliasAst = new GridSqlAlias(uniqueAlias, (GridSqlAst)tbl);
        this.uniqueFromAliases.put((GridSqlAst)tbl, uniqueAliasAst);
        prnt.child(childIdx, uniqueAliasAst);
    }

    private String nextUniqueTableAlias(String origAlias) {
        String uniqueAlias = UNIQUE_TABLE_ALIAS_SUFFIX + this.nextTblAliasId++;
        if (origAlias != null) {
            uniqueAlias = origAlias + uniqueAlias;
        }
        return uniqueAlias;
    }

    private void normalizeFrom(GridSqlAst prnt, int childIdx, boolean prntAlias) {
        GridSqlElement from = (GridSqlElement)prnt.child(childIdx);
        if (from instanceof GridSqlTable) {
            GridSqlTable tbl = (GridSqlTable)from;
            String schemaName = tbl.dataTable() != null ? tbl.dataTable().identifier().schema() : tbl.schema();
            String tblName = tbl.dataTable() != null ? tbl.dataTable().identifier().table() : tbl.tableName();
            this.tbls.add(new QueryTable(schemaName, tblName));
            if (!prntAlias) {
                this.generateUniqueAlias(prnt, childIdx);
            }
        } else if (from instanceof GridSqlAlias) {
            this.normalizeFrom(from, 0, true);
            this.generateUniqueAlias(prnt, childIdx);
        } else if (from instanceof GridSqlSubquery) {
            this.normalizeQuery((GridSqlQuery)((GridSqlSubquery)from).subquery());
            if (!prntAlias) {
                throw new IllegalStateException("No alias for subquery: " + from.getSQL());
            }
        } else if (from instanceof GridSqlJoin) {
            this.normalizeFrom(from, 0, false);
            this.normalizeFrom(from, 1, false);
            this.normalizeExpression(from, 2);
        } else if (from instanceof GridSqlFunction) {
            if (!prntAlias) {
                this.generateUniqueAlias(prnt, childIdx);
            }
        } else {
            throw new IllegalStateException(from.getClass().getName() + " : " + from.getSQL());
        }
    }

    private void normalizeExpression(GridSqlAst prnt, int childIdx) {
        Object el = prnt.child(childIdx);
        if (el instanceof GridSqlAlias || el instanceof GridSqlOperation || el instanceof GridSqlFunction || el instanceof GridSqlArray) {
            for (int i = 0; i < el.size(); ++i) {
                this.normalizeExpression((GridSqlAst)el, i);
            }
        } else if (el instanceof GridSqlSubquery) {
            this.normalizeQuery((GridSqlQuery)((GridSqlSubquery)el).subquery());
        } else if (el instanceof GridSqlColumn) {
            GridSqlColumn col = (GridSqlColumn)el;
            Object tbl = GridSqlAlias.unwrap(col.expressionInFrom());
            GridSqlAlias uniqueAlias = this.uniqueFromAliases.get(tbl);
            assert (uniqueAlias != null) : childIdx + "\n" + prnt.getSQL();
            col.tableAlias(uniqueAlias.alias());
            col.expressionInFrom(uniqueAlias);
        } else if (!(el instanceof GridSqlParameter || el instanceof GridSqlPlaceholder || el instanceof GridSqlConst)) {
            throw new IllegalStateException(el + ": " + el.getClass());
        }
    }

    private static void findParamsQuery(GridSqlQuery qry, Object[] params, TreeSet<Integer> paramIdxs) {
        if (qry instanceof GridSqlSelect) {
            GridSqlQuerySplitter.findParamsSelect((GridSqlSelect)qry, params, paramIdxs);
        } else {
            GridSqlUnion union = (GridSqlUnion)qry;
            GridSqlQuerySplitter.findParamsQuery(union.left(), params, paramIdxs);
            GridSqlQuerySplitter.findParamsQuery(union.right(), params, paramIdxs);
            GridSqlQuerySplitter.findParams(qry.limit(), params, paramIdxs);
            GridSqlQuerySplitter.findParams(qry.offset(), params, paramIdxs);
        }
    }

    private static void findParamsSelect(GridSqlSelect select, Object[] params, TreeSet<Integer> paramIdxs) {
        if (params.length == 0) {
            return;
        }
        for (GridSqlAst el : select.columns(false)) {
            GridSqlQuerySplitter.findParams(el, params, paramIdxs);
        }
        GridSqlQuerySplitter.findParams(select.from(), params, paramIdxs);
        GridSqlQuerySplitter.findParams(select.where(), params, paramIdxs);
        GridSqlQuerySplitter.findParams(select.limit(), params, paramIdxs);
        GridSqlQuerySplitter.findParams(select.offset(), params, paramIdxs);
    }

    private static void findParams(@Nullable GridSqlAst el, Object[] params, TreeSet<Integer> paramIdxs) {
        if (el == null) {
            return;
        }
        if (el instanceof GridSqlParameter) {
            int idx = ((GridSqlParameter)el).index();
            if (params.length <= idx) {
                throw new IgniteException("Invalid number of query parameters. Cannot find " + idx + " parameter.");
            }
            paramIdxs.add(idx);
        } else if (el instanceof GridSqlSubquery) {
            GridSqlQuerySplitter.findParamsQuery(((GridSqlSubquery)el).subquery(), params, paramIdxs);
        } else {
            for (int i = 0; i < el.size(); ++i) {
                GridSqlQuerySplitter.findParams(el.child(i), params, paramIdxs);
            }
        }
    }

    private boolean splitSelectExpression(List<GridSqlAst> mapSelect, List<GridSqlAst> rdcSelect, Set<String> colNames, int idx, boolean collocatedGrpBy, boolean isHaving, boolean hasDistinctAggregate) {
        GridSqlAst el = mapSelect.get(idx);
        GridSqlAlias alias = null;
        boolean aggregateFound = false;
        if (el instanceof GridSqlAlias) {
            alias = (GridSqlAlias)el;
            el = alias.child();
        }
        if (!collocatedGrpBy && GridSqlQuerySplitter.hasAggregates(el)) {
            aggregateFound = true;
            if (alias == null) {
                alias = GridSqlQuerySplitter.alias(isHaving ? HAVING_COLUMN : this.columnName(idx), el);
            }
            this.splitAggregates(alias, 0, mapSelect, idx, hasDistinctAggregate, true);
            GridSqlQuerySplitter.set(rdcSelect, idx, alias);
        } else {
            String mapColAlias;
            String string = mapColAlias = isHaving ? HAVING_COLUMN : this.columnName(idx);
            String rdcColAlias = alias == null ? (el instanceof GridSqlColumn ? ((GridSqlColumn)el).columnName() : mapColAlias) : alias.alias();
            mapSelect.set(idx, GridSqlQuerySplitter.alias(mapColAlias, el));
            GridSqlElement rdcEl = GridSqlQuerySplitter.column(mapColAlias);
            if (colNames.add(rdcColAlias)) {
                rdcEl = GridSqlQuerySplitter.alias(rdcColAlias, rdcEl);
            }
            GridSqlQuerySplitter.set(rdcSelect, idx, rdcEl);
        }
        return aggregateFound;
    }

    private static <Z> void set(List<Z> list, int idx, Z item) {
        assert (list.size() == idx);
        list.add(item);
    }

    private static boolean hasAggregates(GridSqlAst el) {
        if (el instanceof GridSqlAggregateFunction) {
            return true;
        }
        if (el instanceof GridSqlSubquery) {
            return false;
        }
        for (int i = 0; i < el.size(); ++i) {
            if (!GridSqlQuerySplitter.hasAggregates(el.child(i))) continue;
            return true;
        }
        return false;
    }

    private static boolean hasDistinctAggregates(GridSqlAst el) {
        if (el instanceof GridSqlAggregateFunction) {
            GridSqlFunctionType type = ((GridSqlAggregateFunction)el).type();
            return ((GridSqlAggregateFunction)el).distinct() && type != GridSqlFunctionType.MIN && type != GridSqlFunctionType.MAX;
        }
        for (int i = 0; i < el.size(); ++i) {
            if (!GridSqlQuerySplitter.hasDistinctAggregates(el.child(i))) continue;
            return true;
        }
        return false;
    }

    private boolean splitAggregates(GridSqlAst parentExpr, int childIdx, List<GridSqlAst> mapSelect, int exprIdx, boolean hasDistinctAggregate, boolean first) {
        Object el = parentExpr.child(childIdx);
        if (el instanceof GridSqlAggregateFunction) {
            this.splitAggregate(parentExpr, childIdx, mapSelect, exprIdx, hasDistinctAggregate, first);
            return true;
        }
        for (int i = 0; i < el.size(); ++i) {
            if (!this.splitAggregates((GridSqlAst)el, i, mapSelect, exprIdx, hasDistinctAggregate, first)) continue;
            first = false;
        }
        return !first;
    }

    private void splitAggregate(GridSqlAst parentExpr, int aggIdx, List<GridSqlAst> mapSelect, int exprIdx, boolean hasDistinctAggregate, boolean first) {
        GridSqlElement rdcAgg;
        GridSqlElement mapAgg;
        GridSqlAggregateFunction agg = (GridSqlAggregateFunction)parentExpr.child(aggIdx);
        assert (agg.resultType() != null);
        GridSqlAlias mapAggAlias = GridSqlQuerySplitter.alias(this.columnName(first ? exprIdx : mapSelect.size()), GridSqlPlaceholder.EMPTY);
        if (first) {
            mapSelect.set(exprIdx, mapAggAlias);
        } else {
            mapSelect.add(mapAggAlias);
        }
        switch (agg.type()) {
            case AVG: {
                if (hasDistinctAggregate) {
                    mapAgg = (GridSqlElement)agg.child();
                    rdcAgg = GridSqlQuerySplitter.aggregate(agg.distinct(), agg.type()).resultType(agg.resultType()).addChild(GridSqlQuerySplitter.column(mapAggAlias.alias()));
                    break;
                }
                GridSqlElement cntMapAgg = GridSqlQuerySplitter.aggregate(agg.distinct(), GridSqlFunctionType.COUNT).resultType(GridSqlType.BIGINT).addChild((GridSqlAst)agg.child());
                String cntMapAggAlias = this.columnName(mapSelect.size());
                cntMapAgg = GridSqlQuerySplitter.alias(cntMapAggAlias, cntMapAgg);
                mapSelect.add(cntMapAgg);
                mapAgg = GridSqlQuerySplitter.aggregate(agg.distinct(), GridSqlFunctionType.AVG).resultType(GridSqlType.DOUBLE).addChild(GridSqlQuerySplitter.function(GridSqlFunctionType.CAST).resultType(GridSqlType.DOUBLE).addChild((GridSqlAst)agg.child()));
                GridSqlElement sumUpRdc = GridSqlQuerySplitter.aggregate(false, GridSqlFunctionType.SUM).addChild(GridSqlQuerySplitter.op(GridSqlOperationType.MULTIPLY, GridSqlQuerySplitter.column(mapAggAlias.alias()), GridSqlQuerySplitter.column(cntMapAggAlias)));
                GridSqlElement sumDownRdc = GridSqlQuerySplitter.aggregate(false, GridSqlFunctionType.SUM).addChild(GridSqlQuerySplitter.column(cntMapAggAlias));
                if (!GridSqlQuerySplitter.isFractionalType(agg.resultType().type())) {
                    sumUpRdc = GridSqlQuerySplitter.function(GridSqlFunctionType.CAST).resultType(GridSqlType.BIGINT).addChild(sumUpRdc);
                    sumDownRdc = GridSqlQuerySplitter.function(GridSqlFunctionType.CAST).resultType(GridSqlType.BIGINT).addChild(sumDownRdc);
                }
                rdcAgg = GridSqlQuerySplitter.function(GridSqlFunctionType.CAST).resultType(agg.resultType()).addChild(GridSqlQuerySplitter.op(GridSqlOperationType.DIVIDE, sumUpRdc, sumDownRdc));
                break;
            }
            case SUM: 
            case MAX: 
            case MIN: {
                GridSqlElement rdcAgg0;
                if (hasDistinctAggregate) {
                    mapAgg = (GridSqlElement)agg.child();
                    rdcAgg0 = GridSqlQuerySplitter.aggregate(agg.distinct(), agg.type()).addChild(GridSqlQuerySplitter.column(mapAggAlias.alias()));
                } else {
                    mapAgg = GridSqlQuerySplitter.aggregate(agg.distinct(), agg.type()).resultType(agg.resultType()).addChild((GridSqlAst)agg.child());
                    rdcAgg0 = GridSqlQuerySplitter.function(GridSqlFunctionType.CAST).resultType(agg.resultType()).addChild(GridSqlQuerySplitter.aggregate(agg.distinct(), agg.type()).addChild(GridSqlQuerySplitter.column(mapAggAlias.alias())));
                }
                rdcAgg = GridSqlQuerySplitter.function(GridSqlFunctionType.CAST).resultType(agg.resultType()).addChild(rdcAgg0);
                break;
            }
            case COUNT_ALL: 
            case COUNT: {
                if (hasDistinctAggregate) {
                    assert (agg.type() == GridSqlFunctionType.COUNT);
                    mapAgg = (GridSqlElement)agg.child();
                    rdcAgg = GridSqlQuerySplitter.aggregate(agg.distinct(), agg.type()).resultType(GridSqlType.BIGINT).addChild(GridSqlQuerySplitter.column(mapAggAlias.alias()));
                    break;
                }
                mapAgg = GridSqlQuerySplitter.aggregate(agg.distinct(), agg.type()).resultType(GridSqlType.BIGINT);
                if (agg.type() == GridSqlFunctionType.COUNT) {
                    mapAgg.addChild((GridSqlAst)agg.child());
                }
                rdcAgg = GridSqlQuerySplitter.aggregate(false, GridSqlFunctionType.SUM).addChild(GridSqlQuerySplitter.column(mapAggAlias.alias()));
                rdcAgg = GridSqlQuerySplitter.function(GridSqlFunctionType.CAST).resultType(GridSqlType.BIGINT).addChild(rdcAgg);
                break;
            }
            case GROUP_CONCAT: {
                if (agg.distinct() || agg.hasGroupConcatOrder()) {
                    throw new IgniteSQLException("Clauses DISTINCT and ORDER BY are unsupported for GROUP_CONCAT for not collocated data.", 1002);
                }
                mapAgg = hasDistinctAggregate ? (GridSqlElement)agg.child() : GridSqlQuerySplitter.aggregate(agg.distinct(), agg.type()).resultType(GridSqlType.STRING).addChild((GridSqlAst)agg.child());
                rdcAgg = GridSqlQuerySplitter.aggregate(false, GridSqlFunctionType.GROUP_CONCAT).setGroupConcatSeparator(agg.getGroupConcatSeparator()).resultType(GridSqlType.STRING).addChild(GridSqlQuerySplitter.column(mapAggAlias.alias()));
                break;
            }
            default: {
                throw new IgniteException("Unsupported aggregate: " + (Object)((Object)agg.type()));
            }
        }
        assert (!(mapAgg instanceof GridSqlAlias));
        assert (mapAgg.resultType() != null);
        mapAggAlias.child(0, mapAgg);
        mapAggAlias.resultType(mapAgg.resultType());
        parentExpr.child(aggIdx, rdcAgg);
    }

    private static GridSqlAggregateFunction aggregate(boolean distinct, GridSqlFunctionType type) {
        return new GridSqlAggregateFunction(distinct, type);
    }

    private static GridSqlColumn column(String name) {
        return new GridSqlColumn(null, null, null, null, name);
    }

    private static GridSqlAlias alias(String alias, GridSqlAst child) {
        GridSqlAlias res = new GridSqlAlias(alias, child);
        res.resultType(child.resultType());
        return res;
    }

    private static GridSqlOperation op(GridSqlOperationType type, GridSqlAst left, GridSqlAst right) {
        return new GridSqlOperation(type, left, right);
    }

    private static GridSqlFunction function(GridSqlFunctionType type) {
        return new GridSqlFunction(type);
    }

    private static boolean isFractionalType(int type) {
        return type == 6 || type == 8 || type == 7;
    }

    private static CacheQueryPartitionInfo[] derivePartitionsFromQuery(GridSqlQuery qry, GridKernalContext ctx) throws IgniteCheckedException {
        if (!(qry instanceof GridSqlSelect)) {
            return null;
        }
        GridSqlSelect select = (GridSqlSelect)qry;
        if (select.from() == null || select.from().size() != 1) {
            return null;
        }
        return GridSqlQuerySplitter.extractPartition(select.where(), ctx);
    }

    private static CacheQueryPartitionInfo[] extractPartition(GridSqlAst el, GridKernalContext ctx) throws IgniteCheckedException {
        if (!(el instanceof GridSqlOperation)) {
            return null;
        }
        GridSqlOperation op = (GridSqlOperation)el;
        switch (op.operationType()) {
            case EQUAL: {
                CacheQueryPartitionInfo partInfo = GridSqlQuerySplitter.extractPartitionFromEquality(op, ctx);
                if (partInfo != null) {
                    return new CacheQueryPartitionInfo[]{partInfo};
                }
                return null;
            }
            case AND: {
                assert (op.size() == 2);
                CacheQueryPartitionInfo[] partsLeft = GridSqlQuerySplitter.extractPartition(op.child(0), ctx);
                CacheQueryPartitionInfo[] partsRight = GridSqlQuerySplitter.extractPartition(op.child(1), ctx);
                if (partsLeft != null && partsRight != null) {
                    return null;
                }
                if (partsLeft != null) {
                    return partsLeft;
                }
                if (partsRight != null) {
                    return partsRight;
                }
                return null;
            }
            case OR: {
                assert (op.size() == 2);
                CacheQueryPartitionInfo[] partsLeft = GridSqlQuerySplitter.extractPartition(op.child(0), ctx);
                CacheQueryPartitionInfo[] partsRight = GridSqlQuerySplitter.extractPartition(op.child(1), ctx);
                if (partsLeft != null && partsRight != null) {
                    return GridSqlQuerySplitter.mergePartitionInfo(partsLeft, partsRight);
                }
                return null;
            }
        }
        return null;
    }

    private static CacheQueryPartitionInfo extractPartitionFromEquality(GridSqlOperation op, GridKernalContext ctx) throws IgniteCheckedException {
        assert (op.operationType() == GridSqlOperationType.EQUAL);
        GridSqlElement left = (GridSqlElement)op.child(0);
        GridSqlElement right = (GridSqlElement)op.child(1);
        if (!(left instanceof GridSqlColumn)) {
            return null;
        }
        if (!(right instanceof GridSqlConst) && !(right instanceof GridSqlParameter)) {
            return null;
        }
        GridSqlColumn column = (GridSqlColumn)left;
        if (!(column.column().getTable() instanceof GridH2Table)) {
            return null;
        }
        GridH2Table tbl = (GridH2Table)column.column().getTable();
        if (!GridSqlQuerySplitter.isAffinityKey(column.column().getColumnId(), tbl)) {
            return null;
        }
        GridH2RowDescriptor desc = tbl.rowDescriptor();
        IndexColumn affKeyCol = tbl.getAffinityKeyColumn();
        int colId = column.column().getColumnId();
        if (!(affKeyCol != null && colId == affKeyCol.column.getColumnId() || desc.isKeyColumn(colId))) {
            return null;
        }
        if (right instanceof GridSqlConst) {
            GridSqlConst constant = (GridSqlConst)right;
            return new CacheQueryPartitionInfo(ctx.affinity().partition(tbl.cacheName(), constant.value().getObject()), null, null, -1, -1);
        }
        GridSqlParameter param = (GridSqlParameter)right;
        return new CacheQueryPartitionInfo(-1, tbl.cacheName(), tbl.getName(), column.column().getType(), param.index());
    }

    private static boolean isAffinityKey(int colId, GridH2Table tbl) {
        GridH2RowDescriptor desc = tbl.rowDescriptor();
        if (desc.isKeyColumn(colId)) {
            return true;
        }
        IndexColumn affKeyCol = tbl.getAffinityKeyColumn();
        try {
            return affKeyCol != null && colId >= 3 && desc.isColumnKeyProperty(colId - 3) && colId == affKeyCol.column.getColumnId();
        }
        catch (IllegalStateException e) {
            return false;
        }
    }

    private static CacheQueryPartitionInfo[] mergePartitionInfo(CacheQueryPartitionInfo[] a, CacheQueryPartitionInfo[] b) {
        assert (a != null);
        assert (b != null);
        if (a.length == 1 && b.length == 1) {
            if (a[0].equals(b[0])) {
                return new CacheQueryPartitionInfo[]{a[0]};
            }
            return new CacheQueryPartitionInfo[]{a[0], b[0]};
        }
        ArrayList<CacheQueryPartitionInfo> list = new ArrayList<CacheQueryPartitionInfo>(a.length + b.length);
        Collections.addAll(list, a);
        for (CacheQueryPartitionInfo part : b) {
            int i;
            for (i = 0; i < list.size() && !((CacheQueryPartitionInfo)list.get(i)).equals(part); ++i) {
            }
            if (i != list.size()) continue;
            list.add(part);
        }
        CacheQueryPartitionInfo[] result = new CacheQueryPartitionInfo[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            result[i] = (CacheQueryPartitionInfo)list.get(i);
        }
        return result;
    }

    private String printQueryModel(QueryModel root) {
        GridTreePrinter<QueryModel> mp = new GridTreePrinter<QueryModel>(){

            protected List<QueryModel> getChildren(QueryModel m) {
                return m;
            }

            protected String formatTreeNode(QueryModel m) {
                return "[ " + (m.uniqueAlias == null ? "+" : m.uniqueAlias.alias()) + " -> " + (Object)((Object)m.type) + " ns:" + m.needSplit + " nsch:" + m.needSplitChild + " ast: " + this.ast(m) + " ]";
            }

            private String ast(QueryModel m) {
                if (m.prnt == null) {
                    return "-+-+-";
                }
                String ast = m.ast().getSQL().replace('\n', ' ');
                int maxLen = 2000;
                return ast.length() <= maxLen ? ast : ast.substring(0, maxLen);
            }
        };
        return mp.print((Object)root);
    }

    private static CacheQueryPartitionInfo[] mergePartitionsFromMultipleQueries(List<GridCacheSqlQuery> queries) {
        CacheQueryPartitionInfo[] result = null;
        for (GridCacheSqlQuery qry : queries) {
            CacheQueryPartitionInfo[] partInfo = (CacheQueryPartitionInfo[])qry.derivedPartitions();
            if (partInfo == null) {
                result = null;
                break;
            }
            if (result == null) {
                result = partInfo;
                continue;
            }
            result = GridSqlQuerySplitter.mergePartitionInfo(result, partInfo);
        }
        return result;
    }

    private static class AndCondition {
        GridSqlAst prnt;
        int childIdx;

        AndCondition(GridSqlAst prnt, int childIdx) {
            this.prnt = prnt;
            this.childIdx = childIdx;
        }

        private <X extends GridSqlAst> X ast() {
            return (X)this.prnt.child(this.childIdx);
        }
    }

    private static enum Type {
        SELECT,
        UNION,
        TABLE,
        FUNCTION;

    }

    private static final class QueryModel
    extends ArrayList<QueryModel> {
        @GridToStringInclude
        final Type type;
        GridSqlAlias uniqueAlias;
        GridSqlAst prnt;
        int childIdx;
        @GridToStringInclude
        boolean needSplit;
        @GridToStringInclude
        boolean needSplitChild;
        boolean unionAll = true;

        QueryModel(Type type, GridSqlAst prnt, int childIdx, GridSqlAlias uniqueAlias) {
            this.type = type;
            this.prnt = prnt;
            this.childIdx = childIdx;
            this.uniqueAlias = uniqueAlias;
        }

        private <X extends GridSqlAst> X ast() {
            return (X)this.prnt.child(this.childIdx);
        }

        private boolean isQuery() {
            return this.type == Type.SELECT || this.type == Type.UNION;
        }

        @Override
        public String toString() {
            return S.toString(QueryModel.class, (Object)this);
        }
    }
}

