/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.visor.verify;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.IgniteInterruptedException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.processors.cache.CacheGroupContext;
import org.apache.ignite.internal.processors.cache.CacheObject;
import org.apache.ignite.internal.processors.cache.CacheObjectContext;
import org.apache.ignite.internal.processors.cache.CacheObjectUtils;
import org.apache.ignite.internal.processors.cache.CacheObjectValueContext;
import org.apache.ignite.internal.processors.cache.DynamicCacheDescriptor;
import org.apache.ignite.internal.processors.cache.GridCacheContext;
import org.apache.ignite.internal.processors.cache.GridCacheSharedContext;
import org.apache.ignite.internal.processors.cache.KeyCacheObject;
import org.apache.ignite.internal.processors.cache.distributed.dht.topology.GridDhtLocalPartition;
import org.apache.ignite.internal.processors.cache.distributed.dht.topology.GridDhtPartitionState;
import org.apache.ignite.internal.processors.cache.persistence.CacheDataRow;
import org.apache.ignite.internal.processors.cache.persistence.DbCheckpointListener;
import org.apache.ignite.internal.processors.cache.persistence.GridCacheDatabaseSharedManager;
import org.apache.ignite.internal.processors.cache.persistence.IgniteCacheDatabaseSharedManager;
import org.apache.ignite.internal.processors.cache.persistence.file.FilePageStoreManager;
import org.apache.ignite.internal.processors.cache.persistence.tree.CorruptedTreeException;
import org.apache.ignite.internal.processors.cache.verify.GridNotIdleException;
import org.apache.ignite.internal.processors.cache.verify.IdleVerifyUtility;
import org.apache.ignite.internal.processors.cache.verify.PartitionKey;
import org.apache.ignite.internal.processors.query.GridQueryProcessor;
import org.apache.ignite.internal.processors.query.GridQueryTypeDescriptor;
import org.apache.ignite.internal.processors.query.QueryTypeDescriptorImpl;
import org.apache.ignite.internal.processors.query.h2.IgniteH2Indexing;
import org.apache.ignite.internal.processors.query.h2.database.H2TreeIndex;
import org.apache.ignite.internal.processors.query.h2.opt.GridH2Row;
import org.apache.ignite.internal.processors.query.h2.opt.GridH2RowDescriptor;
import org.apache.ignite.internal.processors.query.h2.opt.GridH2Table;
import org.apache.ignite.internal.util.lang.GridIterator;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.T2;
import org.apache.ignite.internal.util.typedef.X;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.internal.visor.verify.IndexIntegrityCheckIssue;
import org.apache.ignite.internal.visor.verify.IndexValidationIssue;
import org.apache.ignite.internal.visor.verify.ValidateIndexesPartitionResult;
import org.apache.ignite.internal.visor.verify.VisorValidateIndexesJobResult;
import org.apache.ignite.lang.IgniteCallable;
import org.apache.ignite.resources.IgniteInstanceResource;
import org.apache.ignite.resources.LoggerResource;
import org.h2.engine.Session;
import org.h2.index.Cursor;
import org.h2.index.Index;
import org.h2.message.DbException;
import org.h2.result.SearchRow;

public class ValidateIndexesClosure
implements IgniteCallable<VisorValidateIndexesJobResult> {
    private static final long serialVersionUID = 0L;
    @IgniteInstanceResource
    private transient IgniteEx ignite;
    @LoggerResource
    private IgniteLogger log;
    private Set<String> cacheNames;
    private final int checkFirst;
    private final int checkThrough;
    private final AtomicInteger processedPartitions = new AtomicInteger(0);
    private volatile int totalPartitions;
    private final AtomicInteger processedIndexes = new AtomicInteger(0);
    private final AtomicInteger integrityCheckedIndexes = new AtomicInteger(0);
    private volatile int totalIndexes;
    private volatile int totalCacheGrps;
    private final AtomicLong lastProgressPrintTs = new AtomicLong(0L);
    private volatile ExecutorService calcExecutor;

    public ValidateIndexesClosure(Set<String> cacheNames, int checkFirst, int checkThrough) {
        this.cacheNames = cacheNames;
        this.checkFirst = checkFirst;
        this.checkThrough = checkThrough;
    }

    public VisorValidateIndexesJobResult call() throws Exception {
        this.calcExecutor = Executors.newFixedThreadPool(Runtime.getRuntime().availableProcessors());
        try {
            VisorValidateIndexesJobResult visorValidateIndexesJobResult = this.call0();
            return visorValidateIndexesJobResult;
        }
        finally {
            this.calcExecutor.shutdown();
        }
    }

    private VisorValidateIndexesJobResult call0() {
        HashSet<Integer> grpIds = new HashSet<Integer>();
        HashSet<String> missingCaches = new HashSet<String>();
        if (this.cacheNames != null) {
            for (String string : this.cacheNames) {
                DynamicCacheDescriptor dynamicCacheDescriptor = this.ignite.context().cache().cacheDescriptor(string);
                if (dynamicCacheDescriptor == null) {
                    missingCaches.add(string);
                    continue;
                }
                grpIds.add(dynamicCacheDescriptor.groupId());
            }
            if (!missingCaches.isEmpty()) {
                StringBuilder strBuilder = new StringBuilder("The following caches do not exist: ");
                for (String string : missingCaches) {
                    strBuilder.append(string).append(", ");
                }
                strBuilder.delete(strBuilder.length() - 2, strBuilder.length());
                throw new IgniteException(strBuilder.toString());
            }
        } else {
            Collection groups = this.ignite.context().cache().cacheGroups();
            for (CacheGroupContext cacheGroupContext : groups) {
                if (cacheGroupContext.systemCache() || cacheGroupContext.isLocal()) continue;
                grpIds.add(cacheGroupContext.groupId());
            }
        }
        ArrayList<Future<Map<PartitionKey, ValidateIndexesPartitionResult>>> procPartFutures = new ArrayList<Future<Map<PartitionKey, ValidateIndexesPartitionResult>>>();
        ArrayList<Future<Map<String, ValidateIndexesPartitionResult>>> arrayList = new ArrayList<Future<Map<String, ValidateIndexesPartitionResult>>>();
        ArrayList<T2> arrayList2 = new ArrayList<T2>();
        ArrayList<T2> idxArgs = new ArrayList<T2>();
        this.totalCacheGrps = grpIds.size();
        Map<Integer, IndexIntegrityCheckIssue> integrityCheckResults = this.integrityCheckIndexesPartitions(grpIds);
        for (Integer grpId : grpIds) {
            CacheGroupContext grpCtx = this.ignite.context().cache().cacheGroup(grpId.intValue());
            if (grpCtx == null || integrityCheckResults.containsKey(grpId)) continue;
            List parts = grpCtx.topology().localPartitions();
            for (GridDhtLocalPartition part : parts) {
                arrayList2.add(new T2((Object)grpCtx, (Object)part));
            }
            GridQueryProcessor qry = this.ignite.context().query();
            IgniteH2Indexing indexing = (IgniteH2Indexing)qry.getIndexing();
            for (GridCacheContext ctx : grpCtx.caches()) {
                Collection types;
                if (this.cacheNames != null && !this.cacheNames.contains(ctx.name()) || F.isEmpty((Collection)(types = qry.types(ctx.name())))) continue;
                for (GridQueryTypeDescriptor type : types) {
                    GridH2Table gridH2Tbl = indexing.dataTable(ctx.name(), type.tableName());
                    if (gridH2Tbl == null) continue;
                    ArrayList<Index> indexes = gridH2Tbl.getIndexes();
                    for (Index idx : indexes) {
                        if (!(idx instanceof H2TreeIndex)) continue;
                        idxArgs.add(new T2((Object)ctx, (Object)idx));
                    }
                }
            }
        }
        Collections.shuffle(arrayList2);
        Collections.shuffle(idxArgs);
        this.totalPartitions = arrayList2.size();
        this.totalIndexes = idxArgs.size();
        for (T2 t2 : arrayList2) {
            procPartFutures.add(this.processPartitionAsync((CacheGroupContext)t2.get1(), (GridDhtLocalPartition)t2.get2()));
        }
        for (T2 t2 : idxArgs) {
            arrayList.add(this.processIndexAsync((GridCacheContext)t2.get1(), (Index)t2.get2()));
        }
        HashMap partResults = new HashMap();
        HashMap idxResults = new HashMap();
        int curIdx = 0;
        try {
            Future fut;
            for (int curPart = 0; curPart < procPartFutures.size(); ++curPart) {
                fut = (Future)procPartFutures.get(curPart);
                Map partRes = (Map)fut.get();
                if (partRes.isEmpty() || !partRes.entrySet().stream().anyMatch(e -> !((ValidateIndexesPartitionResult)e.getValue()).issues().isEmpty())) continue;
                partResults.putAll(partRes);
            }
            while (curIdx < arrayList.size()) {
                fut = (Future)arrayList.get(curIdx);
                Map idxRes = (Map)fut.get();
                if (!idxRes.isEmpty() && idxRes.entrySet().stream().anyMatch(e -> !((ValidateIndexesPartitionResult)e.getValue()).issues().isEmpty())) {
                    idxResults.putAll(idxRes);
                }
                ++curIdx;
            }
            this.log.warning("ValidateIndexesClosure finished: processed " + this.totalPartitions + " partitions and " + this.totalIndexes + " indexes.");
        }
        catch (InterruptedException | ExecutionException e2) {
            int j;
            for (j = curPart; j < procPartFutures.size(); ++j) {
                ((Future)procPartFutures.get(j)).cancel(false);
            }
            for (j = curIdx; j < arrayList.size(); ++j) {
                ((Future)arrayList.get(j)).cancel(false);
            }
            throw this.unwrapFutureException(e2);
        }
        return new VisorValidateIndexesJobResult(partResults, idxResults, integrityCheckResults.values());
    }

    private Map<Integer, IndexIntegrityCheckIssue> integrityCheckIndexesPartitions(Set<Integer> grpIds) {
        ArrayList<Future<T2<Integer, IndexIntegrityCheckIssue>>> integrityCheckFutures = new ArrayList<Future<T2<Integer, IndexIntegrityCheckIssue>>>(grpIds.size());
        HashMap<Integer, IndexIntegrityCheckIssue> integrityCheckResults = new HashMap<Integer, IndexIntegrityCheckIssue>();
        int curFut = 0;
        IgniteCacheDatabaseSharedManager db = this.ignite.context().cache().context().database();
        DbCheckpointListener lsnr = null;
        try {
            final AtomicBoolean cpFlag = new AtomicBoolean();
            if (db instanceof GridCacheDatabaseSharedManager) {
                lsnr = new DbCheckpointListener(){

                    public void onMarkCheckpointBegin(DbCheckpointListener.Context ctx) {
                    }

                    public void onCheckpointBegin(DbCheckpointListener.Context ctx) {
                        if (ctx.hasUserPages()) {
                            cpFlag.set(true);
                        }
                    }

                    public void beforeCheckpointBegin(DbCheckpointListener.Context ctx) throws IgniteCheckedException {
                    }
                };
                ((GridCacheDatabaseSharedManager)db).addCheckpointListener(lsnr);
                if (IdleVerifyUtility.isCheckpointNow((IgniteCacheDatabaseSharedManager)db)) {
                    throw new GridNotIdleException("Checkpoint with dirty pages started! Cluster not idle!");
                }
            }
            for (Integer n : grpIds) {
                final CacheGroupContext grpCtx = this.ignite.context().cache().cacheGroup(n.intValue());
                if (grpCtx == null || !grpCtx.persistenceEnabled()) {
                    this.integrityCheckedIndexes.incrementAndGet();
                    continue;
                }
                Future<T2<Integer, IndexIntegrityCheckIssue>> checkFut = this.calcExecutor.submit(new Callable<T2<Integer, IndexIntegrityCheckIssue>>(){

                    @Override
                    public T2<Integer, IndexIntegrityCheckIssue> call() throws Exception {
                        IndexIntegrityCheckIssue issue = ValidateIndexesClosure.this.integrityCheckIndexPartition(grpCtx, cpFlag);
                        return new T2((Object)grpCtx.groupId(), (Object)issue);
                    }
                });
                integrityCheckFutures.add(checkFut);
            }
            for (Future future : integrityCheckFutures) {
                T2 res = (T2)future.get();
                if (res.getValue() == null) continue;
                integrityCheckResults.put((Integer)res.getKey(), (IndexIntegrityCheckIssue)res.getValue());
            }
        }
        catch (InterruptedException | ExecutionException e) {
            try {
                for (int j = curFut; j < integrityCheckFutures.size(); ++j) {
                    ((Future)integrityCheckFutures.get(j)).cancel(false);
                }
                throw this.unwrapFutureException(e);
            }
            catch (Throwable throwable) {
                if (db instanceof GridCacheDatabaseSharedManager && lsnr != null) {
                    ((GridCacheDatabaseSharedManager)db).removeCheckpointListener(lsnr);
                }
                throw throwable;
            }
        }
        if (db instanceof GridCacheDatabaseSharedManager && lsnr != null) {
            ((GridCacheDatabaseSharedManager)db).removeCheckpointListener(lsnr);
        }
        return integrityCheckResults;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IndexIntegrityCheckIssue integrityCheckIndexPartition(CacheGroupContext gctx, AtomicBoolean cpFlag) {
        GridKernalContext ctx = this.ignite.context();
        GridCacheSharedContext cctx = ctx.cache().context();
        try {
            FilePageStoreManager pageStoreMgr = (FilePageStoreManager)cctx.pageStore();
            IdleVerifyUtility.checkPartitionsPageCrcSum((FilePageStoreManager)pageStoreMgr, (CacheGroupContext)gctx, (int)65535, (byte)2, (AtomicBoolean)cpFlag);
            IndexIntegrityCheckIssue indexIntegrityCheckIssue = null;
            return indexIntegrityCheckIssue;
        }
        catch (Throwable t) {
            if (cpFlag.get()) {
                throw new GridNotIdleException("Checkpoint with dirty pages started! Cluster not idle!", t);
            }
            this.log.error("Integrity check of index partition of cache group " + gctx.cacheOrGroupName() + " failed", t);
            IndexIntegrityCheckIssue indexIntegrityCheckIssue = new IndexIntegrityCheckIssue(gctx.cacheOrGroupName(), t);
            return indexIntegrityCheckIssue;
        }
        finally {
            this.integrityCheckedIndexes.incrementAndGet();
            this.printProgressIfNeeded("Current progress of ValidateIndexesClosure: checked integrity of " + this.integrityCheckedIndexes.get() + " index partitions of " + this.totalCacheGrps + " cache groups");
        }
    }

    private Future<Map<PartitionKey, ValidateIndexesPartitionResult>> processPartitionAsync(final CacheGroupContext grpCtx, final GridDhtLocalPartition part) {
        return this.calcExecutor.submit(new Callable<Map<PartitionKey, ValidateIndexesPartitionResult>>(){

            @Override
            public Map<PartitionKey, ValidateIndexesPartitionResult> call() throws Exception {
                return ValidateIndexesClosure.this.processPartition(grpCtx, part);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Map<PartitionKey, ValidateIndexesPartitionResult> processPartition(CacheGroupContext grpCtx, GridDhtLocalPartition part) {
        ValidateIndexesPartitionResult partRes;
        if (!part.reserve()) {
            return Collections.emptyMap();
        }
        try {
            Method m;
            if (part.state() != GridDhtPartitionState.OWNING) {
                Map<PartitionKey, ValidateIndexesPartitionResult> map = Collections.emptyMap();
                return map;
            }
            long updateCntrBefore = part.updateCounter();
            long partSize = part.dataStore().fullSize();
            GridIterator it = grpCtx.offheap().partitionIterator(part.id());
            Object consId = this.ignite.context().discovery().localNode().consistentId();
            boolean isPrimary = part.primary(grpCtx.topology().readyTopologyVersion());
            partRes = new ValidateIndexesPartitionResult(updateCntrBefore, partSize, isPrimary, consId, null);
            boolean enoughIssues = false;
            GridQueryProcessor qryProcessor = this.ignite.context().query();
            try {
                m = GridQueryProcessor.class.getDeclaredMethod("typeByValue", String.class, CacheObjectContext.class, KeyCacheObject.class, CacheObject.class, Boolean.TYPE);
            }
            catch (NoSuchMethodException e) {
                this.log.error("Failed to invoke typeByValue", (Throwable)e);
                throw new IgniteException((Throwable)e);
            }
            m.setAccessible(true);
            boolean skipConditions = this.checkFirst > 0 || this.checkThrough > 0;
            boolean bothSkipConditions = this.checkFirst > 0 && this.checkThrough > 0;
            long current = 0L;
            long processedNumber = 0L;
            while (it.hasNextX() && !enoughIssues) {
                GridCacheContext cacheCtx;
                CacheDataRow row = (CacheDataRow)it.nextX();
                if (skipConditions) {
                    if (bothSkipConditions) {
                        if (processedNumber > (long)this.checkFirst) break;
                        if (current++ % (long)this.checkThrough > 0L) continue;
                        ++processedNumber;
                    } else if (this.checkFirst > 0) {
                        if (current++ > (long)this.checkFirst) {
                            break;
                        }
                    } else if (current++ % (long)this.checkThrough > 0L) continue;
                }
                int cacheId = row.cacheId() == 0 ? grpCtx.groupId() : row.cacheId();
                GridCacheContext gridCacheContext = cacheCtx = row.cacheId() == 0 ? grpCtx.singleCacheContext() : grpCtx.shared().cacheContext(row.cacheId());
                if (cacheCtx == null) {
                    throw new IgniteException("Unknown cacheId of CacheDataRow: " + cacheId);
                }
                if (row.link() == 0L) {
                    String errMsg = "Invalid partition row, possibly deleted";
                    this.log.error(errMsg);
                    IndexValidationIssue is = new IndexValidationIssue(null, cacheCtx.name(), null, (Throwable)new IgniteCheckedException(errMsg));
                    enoughIssues |= partRes.reportIssue(is);
                    continue;
                }
                try {
                    IgniteH2Indexing indexing;
                    GridH2Table gridH2Tbl;
                    QueryTypeDescriptorImpl res = (QueryTypeDescriptorImpl)m.invoke((Object)qryProcessor, cacheCtx.name(), cacheCtx.cacheObjectContext(), row.key(), row.value(), true);
                    if (res == null || (gridH2Tbl = (indexing = (IgniteH2Indexing)qryProcessor.getIndexing()).dataTable(cacheCtx.name(), res.tableName())) == null) continue;
                    GridH2RowDescriptor gridH2RowDesc = gridH2Tbl.rowDescriptor();
                    GridH2Row h2Row = gridH2RowDesc.createRow(row);
                    ArrayList<Index> indexes = gridH2Tbl.getIndexes();
                    for (Index idx : indexes) {
                        if (!(idx instanceof H2TreeIndex)) continue;
                        try {
                            Cursor cursor = idx.find((Session)null, (SearchRow)h2Row, (SearchRow)h2Row);
                            if (cursor == null) throw new IgniteCheckedException("Key is present in CacheDataTree, but can't be found in SQL index.");
                            if (cursor.next()) continue;
                            throw new IgniteCheckedException("Key is present in CacheDataTree, but can't be found in SQL index.");
                        }
                        catch (Throwable t) {
                            Object o = CacheObjectUtils.unwrapBinaryIfNeeded((CacheObjectValueContext)grpCtx.cacheObjectContext(), (CacheObject)row.key(), (boolean)true, (boolean)true);
                            IndexValidationIssue is = new IndexValidationIssue(o.toString(), cacheCtx.name(), idx.getName(), t);
                            this.log.error("Failed to lookup key: " + is.toString(), t);
                            enoughIssues |= partRes.reportIssue(is);
                        }
                    }
                }
                catch (IllegalAccessException e) {
                    this.log.error("Failed to invoke typeByValue", (Throwable)e);
                    throw new IgniteException((Throwable)e);
                }
                catch (InvocationTargetException e) {
                    Throwable target = e.getTargetException();
                    this.log.error("Failed to invoke typeByValue", target);
                    throw new IgniteException(target);
                }
            }
        }
        catch (IgniteCheckedException e) {
            U.error((IgniteLogger)this.log, (Object)("Failed to process partition [grpId=" + grpCtx.groupId() + ", partId=" + part.id() + "]"), (Throwable)e);
            Map<PartitionKey, ValidateIndexesPartitionResult> map = Collections.emptyMap();
            return map;
        }
        finally {
            part.release();
            this.printProgressOfIndexValidationIfNeeded();
        }
        PartitionKey partKey = new PartitionKey(grpCtx.groupId(), part.id(), grpCtx.cacheOrGroupName());
        this.processedPartitions.incrementAndGet();
        return Collections.singletonMap(partKey, partRes);
    }

    private void printProgressOfIndexValidationIfNeeded() {
        this.printProgressIfNeeded("Current progress of ValidateIndexesClosure: processed " + this.processedPartitions.get() + " of " + this.totalPartitions + " partitions, " + this.processedIndexes.get() + " of " + this.totalIndexes + " SQL indexes");
    }

    private void printProgressIfNeeded(String msg) {
        long lastTs;
        long curTs = U.currentTimeMillis();
        if (curTs - (lastTs = this.lastProgressPrintTs.get()) >= 60000L && this.lastProgressPrintTs.compareAndSet(lastTs, curTs)) {
            this.log.warning(msg);
        }
    }

    private Future<Map<String, ValidateIndexesPartitionResult>> processIndexAsync(final GridCacheContext ctx, final Index idx) {
        return this.calcExecutor.submit(new Callable<Map<String, ValidateIndexesPartitionResult>>(){

            @Override
            public Map<String, ValidateIndexesPartitionResult> call() throws Exception {
                return ValidateIndexesClosure.this.processIndex(ctx, idx);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Map<String, ValidateIndexesPartitionResult> processIndex(GridCacheContext ctx, Index idx) {
        Object consId = this.ignite.context().discovery().localNode().consistentId();
        ValidateIndexesPartitionResult idxValidationRes = new ValidateIndexesPartitionResult(-1L, -1L, true, consId, idx.getName());
        boolean enoughIssues = false;
        Cursor cursor = null;
        try {
            cursor = idx.find((Session)null, null, null);
            if (cursor == null) {
                throw new IgniteCheckedException("Can't iterate through index: " + idx);
            }
        }
        catch (Throwable t) {
            IndexValidationIssue is = new IndexValidationIssue(null, ctx.name(), idx.getName(), t);
            this.log.error("Find in index failed: " + is.toString());
            enoughIssues = true;
        }
        boolean skipConditions = this.checkFirst > 0 || this.checkThrough > 0;
        boolean bothSkipConditions = this.checkFirst > 0 && this.checkThrough > 0;
        long current = 0L;
        long processedNumber = 0L;
        KeyCacheObject previousKey = null;
        while (!enoughIssues) {
            KeyCacheObject h2key = null;
            try {
                try {
                    try {
                        if (!cursor.next()) {
                            previousKey = h2key;
                            break;
                        }
                    }
                    catch (DbException e) {
                        if (X.hasCause((Throwable)e, (Class[])new Class[]{CorruptedTreeException.class})) {
                            throw new IgniteCheckedException("Key is present in SQL index, but is missing in corresponding data page. Previous successfully read key: " + CacheObjectUtils.unwrapBinaryIfNeeded((CacheObjectValueContext)ctx.cacheObjectContext(), (CacheObject)previousKey, (boolean)true, (boolean)true), X.cause((Throwable)e, CorruptedTreeException.class));
                        }
                        throw e;
                    }
                    GridH2Row h2Row = (GridH2Row)cursor.get();
                    if (skipConditions) {
                        if (bothSkipConditions) {
                            if (processedNumber > (long)this.checkFirst) {
                                previousKey = h2key;
                                break;
                            }
                            if (current++ % (long)this.checkThrough > 0L) {
                                previousKey = h2key;
                                continue;
                            }
                            ++processedNumber;
                        } else if (this.checkFirst > 0) {
                            if (current++ > (long)this.checkFirst) {
                                previousKey = h2key;
                                break;
                            }
                        } else if (current++ % (long)this.checkThrough > 0L) {
                            previousKey = h2key;
                            continue;
                        }
                    }
                    h2key = h2Row.key();
                    if (h2Row.link() == 0L) {
                        throw new IgniteCheckedException("Invalid index row, possibly deleted " + h2Row);
                    }
                    CacheDataRow cacheDataStoreRow = ctx.group().offheap().read(ctx, h2key);
                    if (cacheDataStoreRow == null) {
                        throw new IgniteCheckedException("Key is present in SQL index, but can't be found in CacheDataTree.");
                    }
                    previousKey = h2key;
                }
                catch (Throwable t) {
                    Object o = CacheObjectUtils.unwrapBinaryIfNeeded((CacheObjectValueContext)ctx.cacheObjectContext(), h2key, (boolean)true, (boolean)true);
                    IndexValidationIssue is = new IndexValidationIssue(String.valueOf(o), ctx.name(), idx.getName(), t);
                    this.log.error("Failed to lookup key: " + is.toString());
                    enoughIssues |= idxValidationRes.reportIssue(is);
                    previousKey = h2key;
                }
            }
            catch (Throwable throwable) {
                previousKey = h2key;
                throw throwable;
            }
        }
        String uniqueIdxName = "[cache=" + ctx.name() + ", idx=" + idx.getName() + "]";
        this.processedIndexes.incrementAndGet();
        this.printProgressOfIndexValidationIfNeeded();
        return Collections.singletonMap(uniqueIdxName, idxValidationRes);
    }

    private IgniteException unwrapFutureException(Exception e) {
        assert (e instanceof InterruptedException || e instanceof ExecutionException) : "Expecting either InterruptedException or ExecutionException";
        if (e instanceof InterruptedException) {
            return new IgniteInterruptedException((InterruptedException)e);
        }
        if (e.getCause() instanceof IgniteException) {
            return (IgniteException)e.getCause();
        }
        return new IgniteException(e.getCause());
    }
}

