/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.h2.opt;

import java.util.HashSet;
import org.apache.ignite.internal.processors.query.h2.database.H2TreeIndex;
import org.apache.ignite.internal.processors.query.h2.opt.GridH2IndexBase;
import org.apache.ignite.internal.processors.query.h2.opt.GridH2ScanIndex;
import org.apache.ignite.internal.processors.query.h2.opt.GridH2Table;
import org.h2.engine.Session;
import org.h2.result.SortOrder;
import org.h2.table.Column;
import org.h2.table.TableFilter;
import org.jetbrains.annotations.Nullable;

public class GridH2PrimaryScanIndex
extends GridH2ScanIndex<GridH2IndexBase> {
    static final String SCAN_INDEX_NAME_SUFFIX = "__SCAN_";
    private final GridH2Table tbl;
    private final GridH2IndexBase hashIdx;

    GridH2PrimaryScanIndex(GridH2Table tbl, GridH2IndexBase treeIdx, @Nullable GridH2IndexBase hashIdx) {
        super(treeIdx);
        this.tbl = tbl;
        this.hashIdx = hashIdx;
    }

    @Override
    protected GridH2IndexBase delegate() {
        boolean rebuildFromHashInProgress = this.tbl.rebuildFromHashInProgress();
        if (this.hashIdx != null) {
            return rebuildFromHashInProgress ? this.hashIdx : (GridH2IndexBase)((Object)super.delegate());
        }
        assert (!rebuildFromHashInProgress);
        return (GridH2IndexBase)((Object)super.delegate());
    }

    public double getCost(Session ses, int[] masks, TableFilter[] filters, int filter, SortOrder sortOrder, HashSet<Column> allColumnsSet) {
        long rows = this.getRowCountApproximation();
        double baseCost = H2TreeIndex.getTreeIndexCost(this, masks, rows, filters, filter, sortOrder, true, allColumnsSet);
        int mul = this.delegate().getDistributedMultiplier(ses, filters, filter);
        return (double)mul * baseCost;
    }

    public String getPlanSQL() {
        return this.delegate().getTable().getSQL() + "." + SCAN_INDEX_NAME_SUFFIX;
    }

    public String getName() {
        return this.delegate().getName() + SCAN_INDEX_NAME_SUFFIX;
    }
}

