/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.h2.database;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.IgniteSystemProperties;
import org.apache.ignite.internal.pagemem.PageIdUtils;
import org.apache.ignite.internal.processors.cache.GridCacheContext;
import org.apache.ignite.internal.processors.cache.persistence.IgniteCacheDatabaseSharedManager;
import org.apache.ignite.internal.processors.cache.persistence.RootPage;
import org.apache.ignite.internal.processors.cache.persistence.tree.BPlusTree;
import org.apache.ignite.internal.processors.cache.persistence.tree.io.BPlusIO;
import org.apache.ignite.internal.processors.query.GridQueryTypeDescriptor;
import org.apache.ignite.internal.processors.query.h2.H2Cursor;
import org.apache.ignite.internal.processors.query.h2.H2RowCache;
import org.apache.ignite.internal.processors.query.h2.database.H2Tree;
import org.apache.ignite.internal.processors.query.h2.database.InlineIndexHelper;
import org.apache.ignite.internal.processors.query.h2.database.io.H2RowLinkIO;
import org.apache.ignite.internal.processors.query.h2.opt.GridH2IndexBase;
import org.apache.ignite.internal.processors.query.h2.opt.GridH2Row;
import org.apache.ignite.internal.processors.query.h2.opt.GridH2Table;
import org.apache.ignite.internal.util.IgniteTree;
import org.apache.ignite.internal.util.lang.GridCursor;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.spi.indexing.IndexingQueryCacheFilter;
import org.apache.ignite.spi.indexing.IndexingQueryFilter;
import org.h2.engine.Session;
import org.h2.index.BaseIndex;
import org.h2.index.Cursor;
import org.h2.index.IndexType;
import org.h2.index.SingleRowCursor;
import org.h2.message.DbException;
import org.h2.result.Row;
import org.h2.result.SearchRow;
import org.h2.result.SortOrder;
import org.h2.table.Column;
import org.h2.table.IndexColumn;
import org.h2.table.Table;
import org.h2.table.TableFilter;
import org.h2.value.Value;
import org.jetbrains.annotations.Nullable;

public class H2TreeIndex
extends GridH2IndexBase {
    public static final int IGNITE_MAX_INDEX_PAYLOAD_SIZE_DEFAULT = 10;
    private final H2Tree[] segments;
    private final List<InlineIndexHelper> inlineIdxs;
    private final GridCacheContext<?, ?> cctx;
    private final String treeName;
    public static final Cursor EMPTY_CURSOR = new Cursor(){

        public Row get() {
            throw DbException.convert((Throwable)new NoSuchElementException("Empty cursor"));
        }

        public SearchRow getSearchRow() {
            throw DbException.convert((Throwable)new NoSuchElementException("Empty cursor"));
        }

        public boolean next() {
            return false;
        }

        public boolean previous() {
            return false;
        }
    };

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public H2TreeIndex(GridCacheContext<?, ?> cctx, @Nullable H2RowCache rowCache, GridH2Table tbl, String name, boolean pk, List<IndexColumn> colsList, int inlineSize, int segmentsCnt, IgniteLogger log) throws IgniteCheckedException {
        assert (segmentsCnt > 0) : segmentsCnt;
        this.cctx = cctx;
        IndexColumn[] cols = colsList.toArray(new IndexColumn[colsList.size()]);
        IndexColumn.mapColumns((IndexColumn[])cols, (Table)tbl);
        this.initBaseIndex((Table)tbl, 0, name, cols, pk ? IndexType.createPrimaryKey((boolean)false, (boolean)false) : IndexType.createNonUnique((boolean)false, (boolean)false, (boolean)false));
        GridQueryTypeDescriptor typeDesc = tbl.rowDescriptor().type();
        int typeId = cctx.binaryMarshaller() ? typeDesc.typeId() : typeDesc.valueClass().hashCode();
        this.treeName = BPlusTree.treeName((String)((tbl.rowDescriptor() == null ? "" : typeId + "_") + name), (String)"H2Tree");
        if (cctx.affinityNode()) {
            this.inlineIdxs = this.getAvailableInlineColumns(cols);
            this.segments = new H2Tree[segmentsCnt];
            IgniteCacheDatabaseSharedManager db = cctx.shared().database();
            for (int i = 0; i < this.segments.length; ++i) {
                db.checkpointReadLock();
                try {
                    RootPage page = this.getMetaPage(i);
                    this.segments[i] = new H2Tree(name, tbl.getName(), tbl.cacheName(), name, cctx.offheap().reuseListForIndex(name), cctx.groupId(), cctx.group().name(), cctx.dataRegion().pageMemory(), cctx.shared().wal(), (AtomicLong)cctx.offheap().globalRemoveId(), tbl.rowFactory(), page.pageId().pageId(), page.isAllocated(), cols, this.inlineIdxs, this.computeInlineSize(this.inlineIdxs, inlineSize), rowCache, cctx.kernalContext().failure(), log){

                        @Override
                        public int compareValues(Value v1, Value v2) {
                            return v1 == v2 ? 0 : H2TreeIndex.this.table.compareTypeSafe(v1, v2);
                        }
                    };
                    continue;
                }
                finally {
                    db.checkpointReadUnlock();
                }
            }
        } else {
            this.segments = null;
            this.inlineIdxs = null;
        }
        this.initDistributedJoinMessaging(tbl);
    }

    public boolean rebuildRequired() {
        assert (this.segments != null);
        for (int i = 0; i < this.segments.length; ++i) {
            try {
                H2Tree segment = this.segments[i];
                if (!segment.created()) continue;
                return true;
            }
            catch (Exception e) {
                throw new IgniteException("Failed to check index tree root page existence [cacheName=" + this.cctx.name() + ", segment=" + i + ']');
            }
        }
        return false;
    }

    private List<InlineIndexHelper> getAvailableInlineColumns(IndexColumn[] cols) {
        ArrayList<InlineIndexHelper> res = new ArrayList<InlineIndexHelper>();
        for (IndexColumn col : cols) {
            if (!InlineIndexHelper.AVAILABLE_TYPES.contains(col.column.getType())) break;
            InlineIndexHelper idx = new InlineIndexHelper(col.column.getName(), col.column.getType(), col.column.getColumnId(), col.sortType, this.table.getCompareMode());
            res.add(idx);
        }
        return res;
    }

    @Override
    protected int segmentsCount() {
        return this.segments.length;
    }

    public Cursor find(Session ses, SearchRow lower, SearchRow upper) {
        try {
            IndexingQueryCacheFilter filter = this.partitionFilter(H2TreeIndex.threadLocalFilter());
            int seg = this.threadLocalSegment();
            H2Tree tree = this.treeForRead(seg);
            if (this.indexType.isPrimaryKey() && lower != null && upper != null && tree.compareRows(lower, upper) == 0) {
                GridH2Row row = (GridH2Row)tree.findOne(lower, filter);
                return row == null ? EMPTY_CURSOR : new SingleRowCursor((Row)row);
            }
            GridCursor cursor = tree.find(lower, upper, filter);
            return new H2Cursor((GridCursor<GridH2Row>)cursor);
        }
        catch (IgniteCheckedException e) {
            throw DbException.convert((Throwable)e);
        }
    }

    @Override
    public GridH2Row put(GridH2Row row) {
        try {
            InlineIndexHelper.setCurrentInlineIndexes(this.inlineIdxs);
            int seg = this.segmentForRow((SearchRow)row);
            H2Tree tree = this.treeForRead(seg);
            assert (this.cctx.shared().database().checkpointLockIsHeldByThread());
            GridH2Row gridH2Row = (GridH2Row)tree.put(row);
            return gridH2Row;
        }
        catch (IgniteCheckedException e) {
            throw DbException.convert((Throwable)e);
        }
        finally {
            InlineIndexHelper.clearCurrentInlineIndexes();
        }
    }

    @Override
    public boolean putx(GridH2Row row) {
        try {
            int seg = this.segmentForRow((SearchRow)row);
            H2Tree tree = this.treeForRead(seg);
            InlineIndexHelper.setCurrentInlineIndexes(tree.inlineIndexes());
            assert (this.cctx.shared().database().checkpointLockIsHeldByThread());
            boolean bl = tree.putx(row);
            return bl;
        }
        catch (IgniteCheckedException e) {
            throw DbException.convert((Throwable)e);
        }
        finally {
            InlineIndexHelper.clearCurrentInlineIndexes();
        }
    }

    @Override
    public GridH2Row remove(SearchRow row) {
        try {
            InlineIndexHelper.setCurrentInlineIndexes(this.inlineIdxs);
            int seg = this.segmentForRow(row);
            H2Tree tree = this.treeForRead(seg);
            assert (this.cctx.shared().database().checkpointLockIsHeldByThread());
            GridH2Row gridH2Row = (GridH2Row)tree.remove(row);
            return gridH2Row;
        }
        catch (IgniteCheckedException e) {
            throw DbException.convert((Throwable)e);
        }
        finally {
            InlineIndexHelper.clearCurrentInlineIndexes();
        }
    }

    @Override
    public boolean removex(SearchRow row) {
        try {
            InlineIndexHelper.setCurrentInlineIndexes(this.inlineIdxs);
            int seg = this.segmentForRow(row);
            H2Tree tree = this.treeForRead(seg);
            assert (this.cctx.shared().database().checkpointLockIsHeldByThread());
            boolean bl = tree.removex(row);
            return bl;
        }
        catch (IgniteCheckedException e) {
            throw DbException.convert((Throwable)e);
        }
        finally {
            InlineIndexHelper.clearCurrentInlineIndexes();
        }
    }

    public double getCost(Session ses, int[] masks, TableFilter[] filters, int filter, SortOrder sortOrder, HashSet<Column> allColumnsSet) {
        long rowCnt = this.getRowCountApproximation();
        double baseCost = H2TreeIndex.getTreeIndexCost(this, masks, rowCnt, filters, filter, sortOrder, false, allColumnsSet);
        int mul = this.getDistributedMultiplier(ses, filters, filter);
        return (double)mul * baseCost;
    }

    public static long getTreeIndexCost(BaseIndex idx, int[] masks, long rowCount, TableFilter[] filters, int filter, SortOrder sortOrder, boolean isScanIndex, HashSet<Column> allColumnsSet) {
        int totalSelectivity = 0;
        long rowsCost = rowCount += 1000L;
        if (masks != null) {
            int i = 0;
            int len = idx.getColumns().length;
            boolean tryAdditional = false;
            while (i < len) {
                Column column = idx.getColumns()[i++];
                int index = column.getColumnId();
                int mask = masks[index];
                if ((mask & 1) == 1) {
                    if (i == len && idx.getIndexType().isUnique()) {
                        rowsCost = 3L;
                        break;
                    }
                    long distinctRows = rowCount * (long)(totalSelectivity = 100 - (100 - totalSelectivity) * (100 - column.getSelectivity()) / 100) / 100L;
                    if (distinctRows <= 0L) {
                        distinctRows = 1L;
                    }
                    rowsCost = 2L + Math.max(rowCount / distinctRows, 1L);
                    continue;
                }
                if ((mask & 6) == 6) {
                    rowsCost = 2L + rowsCost / 4L;
                    tryAdditional = true;
                    break;
                }
                if ((mask & 2) == 2) {
                    rowsCost = 2L + rowsCost / 3L;
                    tryAdditional = true;
                    break;
                }
                if ((mask & 4) == 4) {
                    rowsCost /= 3L;
                    tryAdditional = true;
                    break;
                }
                if (mask != 0) break;
                --i;
                break;
            }
            if (tryAdditional) {
                while (i < len && masks[idx.getColumns()[i].getColumnId()] != 0) {
                    ++i;
                    --rowsCost;
                }
            }
            rowsCost += (long)(len - i);
        }
        long sortingCost = 0L;
        if (sortOrder != null) {
            sortingCost = 100L + rowCount / 10L;
        }
        if (sortOrder != null && !isScanIndex) {
            boolean sortOrderMatches = true;
            int coveringCount = 0;
            int[] sortTypes = sortOrder.getSortTypes();
            TableFilter tableFilter = filters == null ? null : filters[filter];
            int len = sortTypes.length;
            for (int i = 0; i < len && i < idx.getIndexColumns().length; ++i) {
                Column col = sortOrder.getColumn(i, tableFilter);
                if (col == null) {
                    sortOrderMatches = false;
                    break;
                }
                IndexColumn indexCol = idx.getIndexColumns()[i];
                if (!col.equals((Object)indexCol.column)) {
                    sortOrderMatches = false;
                    break;
                }
                int sortType = sortTypes[i];
                if (sortType != indexCol.sortType) {
                    sortOrderMatches = false;
                    break;
                }
                ++coveringCount;
            }
            if (sortOrderMatches) {
                sortingCost = 100 - coveringCount;
            }
        }
        boolean needsToReadFromScanIndex = true;
        if (!isScanIndex && allColumnsSet != null && !allColumnsSet.isEmpty()) {
            boolean foundAllColumnsWeNeed = true;
            for (Column c : allColumnsSet) {
                if (c.getTable() != idx.getTable()) continue;
                boolean found = false;
                for (Column c2 : idx.getColumns()) {
                    if (c != c2) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                foundAllColumnsWeNeed = false;
                break;
            }
            if (foundAllColumnsWeNeed) {
                needsToReadFromScanIndex = false;
            }
        }
        long rc = isScanIndex ? rowsCost + sortingCost + 20L : (needsToReadFromScanIndex ? rowsCost + rowsCost + sortingCost + 20L : rowsCost + sortingCost + (long)idx.getColumns().length);
        return rc;
    }

    public long getRowCount(Session ses) {
        try {
            int seg = this.threadLocalSegment();
            H2Tree tree = this.treeForRead(seg);
            BPlusTree.TreeRowClosure<SearchRow, GridH2Row> filter = this.filterClosure();
            return tree.size(filter);
        }
        catch (IgniteCheckedException e) {
            throw DbException.convert((Throwable)e);
        }
    }

    public long getRowCountApproximation() {
        return 10000L;
    }

    public boolean canGetFirstOrLast() {
        return true;
    }

    public Cursor findFirstOrLast(Session session, boolean b) {
        try {
            int seg = this.threadLocalSegment();
            H2Tree tree = this.treeForRead(seg);
            GridH2Row row = b ? (GridH2Row)tree.findFirst() : (GridH2Row)tree.findLast();
            return new SingleRowCursor((Row)row);
        }
        catch (IgniteCheckedException e) {
            throw DbException.convert((Throwable)e);
        }
    }

    @Override
    public void destroy(boolean rmvIndex) {
        try {
            if (this.cctx.affinityNode() && rmvIndex) {
                assert (this.cctx.shared().database().checkpointLockIsHeldByThread());
                for (int i = 0; i < this.segments.length; ++i) {
                    H2Tree tree = this.segments[i];
                    tree.destroy();
                    this.dropMetaPage(i);
                }
            }
        }
        catch (IgniteCheckedException e) {
            throw new IgniteException((Throwable)e);
        }
        finally {
            super.destroy(rmvIndex);
        }
    }

    protected H2Tree treeForRead(int segment) {
        return this.segments[segment];
    }

    @Override
    protected H2Cursor doFind0(IgniteTree t, @Nullable SearchRow first, boolean includeFirst, @Nullable SearchRow last, IndexingQueryFilter filter) {
        try {
            IndexingQueryCacheFilter pf = this.partitionFilter(filter);
            GridCursor<GridH2Row> range = t.find((Object)first, (Object)last, (Object)pf);
            if (range == null) {
                range = GridH2IndexBase.EMPTY_CURSOR;
            }
            return new H2Cursor(range);
        }
        catch (IgniteCheckedException e) {
            throw DbException.convert((Throwable)e);
        }
    }

    private int computeInlineSize(List<InlineIndexHelper> inlineIdxs, int cfgInlineSize) {
        int propSize;
        int confSize = this.cctx.config().getSqlIndexMaxInlineSize();
        int n = propSize = confSize == -1 ? IgniteSystemProperties.getInteger((String)"IGNITE_MAX_INDEX_PAYLOAD_SIZE", (int)10) : confSize;
        if (cfgInlineSize == 0) {
            return 0;
        }
        if (F.isEmpty(inlineIdxs)) {
            return 0;
        }
        if (cfgInlineSize == -1) {
            if (propSize == 0) {
                return 0;
            }
            int size = 0;
            for (InlineIndexHelper idxHelper : inlineIdxs) {
                if (idxHelper.size() <= 0) {
                    size = propSize;
                    break;
                }
                size += idxHelper.size() + 1;
            }
            return Math.min(2048, size);
        }
        return Math.min(2048, cfgInlineSize);
    }

    private RootPage getMetaPage(int segIdx) throws IgniteCheckedException {
        return this.cctx.offheap().rootPageForIndex(this.cctx.cacheId(), this.treeName, segIdx);
    }

    private void dropMetaPage(int segIdx) throws IgniteCheckedException {
        this.cctx.offheap().dropRootPageForIndex(this.cctx.cacheId(), this.treeName, segIdx);
    }

    @Nullable
    private IndexingQueryCacheFilter partitionFilter(@Nullable IndexingQueryFilter qryFilter) {
        if (qryFilter == null) {
            return null;
        }
        String cacheName = this.getTable().cacheName();
        return qryFilter.forCache(cacheName);
    }

    @Nullable
    private BPlusTree.TreeRowClosure<SearchRow, GridH2Row> filterClosure() {
        IndexingQueryCacheFilter filter = this.partitionFilter(H2TreeIndex.threadLocalFilter());
        return filter != null ? new PartitionFilterTreeRowClosure(filter) : null;
    }

    @Override
    public void refreshColumnIds() {
        super.refreshColumnIds();
        if (this.inlineIdxs == null) {
            return;
        }
        List<InlineIndexHelper> inlineHelpers = this.getAvailableInlineColumns(this.indexColumns);
        assert (this.inlineIdxs.size() == inlineHelpers.size());
        for (int pos = 0; pos < inlineHelpers.size(); ++pos) {
            this.inlineIdxs.set(pos, inlineHelpers.get(pos));
        }
        for (H2Tree seg : this.segments) {
            seg.refreshColumnIds(this.inlineIdxs);
        }
    }

    private static class PartitionFilterTreeRowClosure
    implements BPlusTree.TreeRowClosure<SearchRow, GridH2Row> {
        private final IndexingQueryCacheFilter filter;

        public PartitionFilterTreeRowClosure(IndexingQueryCacheFilter filter) {
            this.filter = filter;
        }

        public boolean apply(BPlusTree<SearchRow, GridH2Row> tree, BPlusIO<SearchRow> io, long pageAddr, int idx) throws IgniteCheckedException {
            H2RowLinkIO h2io = (H2RowLinkIO)io;
            return this.filter.applyPartition(PageIdUtils.partId((long)PageIdUtils.pageId((long)h2io.getLink(pageAddr, idx))));
        }
    }
}

