/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.h2.affinity;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.processors.cache.query.GridCacheSqlQuery;
import org.apache.ignite.internal.processors.query.h2.affinity.PartitionInfo;
import org.apache.ignite.internal.processors.query.h2.opt.GridH2RowDescriptor;
import org.apache.ignite.internal.processors.query.h2.opt.GridH2Table;
import org.apache.ignite.internal.processors.query.h2.sql.GridSqlAst;
import org.apache.ignite.internal.processors.query.h2.sql.GridSqlColumn;
import org.apache.ignite.internal.processors.query.h2.sql.GridSqlConst;
import org.apache.ignite.internal.processors.query.h2.sql.GridSqlElement;
import org.apache.ignite.internal.processors.query.h2.sql.GridSqlOperation;
import org.apache.ignite.internal.processors.query.h2.sql.GridSqlOperationType;
import org.apache.ignite.internal.processors.query.h2.sql.GridSqlParameter;
import org.apache.ignite.internal.processors.query.h2.sql.GridSqlQuery;
import org.apache.ignite.internal.processors.query.h2.sql.GridSqlSelect;
import org.h2.table.Column;
import org.h2.table.IndexColumn;
import org.jetbrains.annotations.Nullable;

public class PartitionExtractor {
    public static PartitionInfo[] mergePartitionsFromMultipleQueries(List<GridCacheSqlQuery> queries) {
        PartitionInfo[] result = null;
        for (GridCacheSqlQuery qry : queries) {
            PartitionInfo[] partInfo = (PartitionInfo[])qry.derivedPartitions();
            if (partInfo == null) {
                result = null;
                break;
            }
            if (result == null) {
                result = partInfo;
                continue;
            }
            result = PartitionExtractor.mergePartitionInfo(result, partInfo);
        }
        return result;
    }

    public static PartitionInfo[] derivePartitionsFromQuery(GridSqlQuery qry, GridKernalContext ctx) throws IgniteCheckedException {
        if (!(qry instanceof GridSqlSelect)) {
            return null;
        }
        GridSqlSelect select = (GridSqlSelect)qry;
        if (select.from() == null || select.from().size() != 1) {
            return null;
        }
        return PartitionExtractor.extractPartition(select.where(), ctx);
    }

    private static PartitionInfo[] extractPartition(GridSqlAst el, GridKernalContext ctx) throws IgniteCheckedException {
        if (!(el instanceof GridSqlOperation)) {
            return null;
        }
        GridSqlOperation op = (GridSqlOperation)el;
        switch (op.operationType()) {
            case EQUAL: {
                PartitionInfo partInfo = PartitionExtractor.extractPartitionFromEquality(op, ctx);
                if (partInfo != null) {
                    return new PartitionInfo[]{partInfo};
                }
                return null;
            }
            case AND: {
                assert (op.size() == 2);
                PartitionInfo[] partsLeft = PartitionExtractor.extractPartition(op.child(0), ctx);
                PartitionInfo[] partsRight = PartitionExtractor.extractPartition(op.child(1), ctx);
                if (partsLeft != null && partsRight != null) {
                    return null;
                }
                if (partsLeft != null) {
                    return partsLeft;
                }
                if (partsRight != null) {
                    return partsRight;
                }
                return null;
            }
            case OR: {
                assert (op.size() == 2);
                PartitionInfo[] partsLeft = PartitionExtractor.extractPartition(op.child(0), ctx);
                PartitionInfo[] partsRight = PartitionExtractor.extractPartition(op.child(1), ctx);
                if (partsLeft != null && partsRight != null) {
                    return PartitionExtractor.mergePartitionInfo(partsLeft, partsRight);
                }
                return null;
            }
            case IN: {
                if (op.size() < 2) {
                    return null;
                }
                Object left = op.child();
                if (!(left instanceof GridSqlColumn)) {
                    return null;
                }
                GridSqlColumn leftCol = (GridSqlColumn)left;
                if (!(leftCol.column().getTable() instanceof GridH2Table)) {
                    return null;
                }
                PartitionInfo[] res = new PartitionInfo[op.size() - 1];
                for (int i = 1; i < op.size(); ++i) {
                    GridSqlParameter rightParam;
                    GridSqlConst rightConst;
                    Object right = op.child(i);
                    if (right instanceof GridSqlConst) {
                        rightConst = (GridSqlConst)right;
                        rightParam = null;
                    } else if (right instanceof GridSqlParameter) {
                        rightConst = null;
                        rightParam = (GridSqlParameter)right;
                    } else {
                        return null;
                    }
                    PartitionInfo cur = PartitionExtractor.getCacheQueryPartitionInfo(leftCol.column(), rightConst, rightParam, ctx);
                    if (cur == null) {
                        return null;
                    }
                    res[i - 1] = cur;
                }
                return res;
            }
        }
        return null;
    }

    private static PartitionInfo extractPartitionFromEquality(GridSqlOperation op, GridKernalContext ctx) throws IgniteCheckedException {
        GridSqlParameter rightParam;
        GridSqlConst rightConst;
        assert (op.operationType() == GridSqlOperationType.EQUAL);
        GridSqlElement left = (GridSqlElement)op.child(0);
        GridSqlElement right = (GridSqlElement)op.child(1);
        if (!(left instanceof GridSqlColumn)) {
            return null;
        }
        GridSqlColumn leftCol = (GridSqlColumn)left;
        if (!(leftCol.column().getTable() instanceof GridH2Table)) {
            return null;
        }
        if (right instanceof GridSqlConst) {
            rightConst = (GridSqlConst)right;
            rightParam = null;
        } else if (right instanceof GridSqlParameter) {
            rightConst = null;
            rightParam = (GridSqlParameter)right;
        } else {
            return null;
        }
        return PartitionExtractor.getCacheQueryPartitionInfo(leftCol.column(), rightConst, rightParam, ctx);
    }

    private static PartitionInfo[] mergePartitionInfo(PartitionInfo[] a, PartitionInfo[] b) {
        assert (a != null);
        assert (b != null);
        if (a.length == 1 && b.length == 1) {
            if (a[0].equals(b[0])) {
                return new PartitionInfo[]{a[0]};
            }
            return new PartitionInfo[]{a[0], b[0]};
        }
        ArrayList<PartitionInfo> list = new ArrayList<PartitionInfo>(a.length + b.length);
        Collections.addAll(list, a);
        for (PartitionInfo part : b) {
            int i;
            for (i = 0; i < list.size() && !((PartitionInfo)list.get(i)).equals(part); ++i) {
            }
            if (i != list.size()) continue;
            list.add(part);
        }
        PartitionInfo[] result = new PartitionInfo[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            result[i] = (PartitionInfo)list.get(i);
        }
        return result;
    }

    @Nullable
    private static PartitionInfo getCacheQueryPartitionInfo(Column leftCol, GridSqlConst rightConst, GridSqlParameter rightParam, GridKernalContext ctx) throws IgniteCheckedException {
        assert (leftCol != null);
        assert (leftCol.getTable() != null);
        assert (leftCol.getTable() instanceof GridH2Table);
        GridH2Table tbl = (GridH2Table)leftCol.getTable();
        if (!PartitionExtractor.isAffinityKey(leftCol.getColumnId(), tbl)) {
            return null;
        }
        GridH2RowDescriptor desc = tbl.rowDescriptor();
        IndexColumn affKeyCol = tbl.getAffinityKeyColumn();
        int colId = leftCol.getColumnId();
        if (!(affKeyCol != null && colId == affKeyCol.column.getColumnId() || desc.isKeyColumn(colId))) {
            return null;
        }
        if (rightConst != null) {
            int part = ctx.affinity().partition(tbl.cacheName(), rightConst.value().getObject());
            return new PartitionInfo(part, null, null, -1, -1);
        }
        if (rightParam != null) {
            return new PartitionInfo(-1, tbl.cacheName(), tbl.getName(), leftCol.getType(), rightParam.index());
        }
        return null;
    }

    private static boolean isAffinityKey(int colId, GridH2Table tbl) {
        GridH2RowDescriptor desc = tbl.rowDescriptor();
        if (desc.isKeyColumn(colId)) {
            return true;
        }
        IndexColumn affKeyCol = tbl.getAffinityKeyColumn();
        try {
            return affKeyCol != null && colId >= 3 && desc.isColumnKeyProperty(colId - 3) && colId == affKeyCol.column.getColumnId();
        }
        catch (IllegalStateException e) {
            return false;
        }
    }

    private PartitionExtractor() {
    }
}

