/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.h2.opt;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.ignite.IgniteException;
import org.apache.ignite.internal.processors.query.h2.opt.GridLuceneFile;
import org.apache.ignite.internal.processors.query.h2.opt.GridLuceneInputStream;
import org.apache.ignite.internal.processors.query.h2.opt.GridLuceneLockFactory;
import org.apache.ignite.internal.processors.query.h2.opt.GridLuceneOutputStream;
import org.apache.ignite.internal.util.offheap.unsafe.GridUnsafeMemory;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.lucene.store.BaseDirectory;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.store.IndexOutput;
import org.apache.lucene.store.LockFactory;
import org.apache.lucene.util.Accountable;
import org.apache.lucene.util.Accountables;

public class GridLuceneDirectory
extends BaseDirectory
implements Accountable {
    protected final Map<String, GridLuceneFile> fileMap = new ConcurrentHashMap<String, GridLuceneFile>();
    protected final AtomicLong sizeInBytes = new AtomicLong();
    private final GridUnsafeMemory mem;

    GridLuceneDirectory(GridUnsafeMemory mem) {
        super((LockFactory)new GridLuceneLockFactory());
        this.mem = mem;
    }

    public final String[] listAll() {
        this.ensureOpen();
        Set<String> fileNames = this.fileMap.keySet();
        ArrayList<String> names = new ArrayList<String>(fileNames);
        return names.toArray(new String[names.size()]);
    }

    public void rename(String source, String dest) throws IOException {
        this.ensureOpen();
        GridLuceneFile file = this.fileMap.get(source);
        if (file == null) {
            throw new FileNotFoundException(source);
        }
        this.fileMap.put(dest, file);
        this.fileMap.remove(source);
    }

    public void syncMetaData() throws IOException {
    }

    public IndexOutput createTempOutput(String prefix, String suffix, IOContext context) throws IOException {
        throw new UnsupportedOperationException();
    }

    public final long fileLength(String name) throws IOException {
        this.ensureOpen();
        GridLuceneFile file = this.fileMap.get(name);
        if (file == null) {
            throw new FileNotFoundException(name);
        }
        return file.getLength();
    }

    public void deleteFile(String name) throws IOException {
        this.ensureOpen();
        this.doDeleteFile(name, false);
    }

    private void doDeleteFile(String name, boolean onClose) throws IOException {
        GridLuceneFile file = this.fileMap.remove(name);
        if (file != null) {
            file.delete();
            assert (!onClose || !file.hasRefs()) : "Possible memory leak, resource is not closed: " + file.toString();
        } else {
            throw new FileNotFoundException(name);
        }
        this.sizeInBytes.addAndGet(-file.getSizeInBytes());
    }

    public IndexOutput createOutput(String name, IOContext context) throws IOException {
        this.ensureOpen();
        GridLuceneFile file = new GridLuceneFile(this);
        file.lockRef();
        GridLuceneFile existing = this.fileMap.put(name, file);
        if (existing != null) {
            this.sizeInBytes.addAndGet(-existing.getSizeInBytes());
            existing.delete();
        }
        return new GridLuceneOutputStream(file);
    }

    public void sync(Collection<String> names) throws IOException {
    }

    public IndexInput openInput(String name, IOContext context) throws IOException {
        this.ensureOpen();
        GridLuceneFile file = this.fileMap.get(name);
        if (file == null) {
            throw new FileNotFoundException(name);
        }
        file.lockRef();
        if (!this.fileMap.containsKey(name)) {
            file.releaseRef();
            throw new FileNotFoundException(name);
        }
        return new GridLuceneInputStream(name, file);
    }

    public void close() {
        this.isOpen = false;
        IgniteException errs = null;
        for (String fileName : this.fileMap.keySet()) {
            try {
                this.doDeleteFile(fileName, true);
            }
            catch (IOException e) {
                if (errs == null) {
                    errs = new IgniteException("Failed to close index directory. Some index readers weren't closed properly, that may leads memory leak.");
                }
                errs.addSuppressed((Throwable)e);
            }
        }
        assert (this.fileMap.isEmpty());
        if (errs != null && !F.isEmpty((Object[])errs.getSuppressed())) {
            throw errs;
        }
    }

    public long ramBytesUsed() {
        this.ensureOpen();
        return this.sizeInBytes.get();
    }

    public synchronized Collection<Accountable> getChildResources() {
        return Accountables.namedAccountables((String)"file", new HashMap<String, GridLuceneFile>(this.fileMap));
    }

    GridUnsafeMemory memory() {
        return this.mem;
    }
}

