/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.h2;

import java.lang.reflect.Field;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.NoSuchElementException;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.internal.processors.query.IgniteSQLException;
import org.apache.ignite.internal.processors.query.h2.H2QueryFetchSizeInterceptor;
import org.apache.ignite.internal.processors.query.h2.H2QueryInfo;
import org.apache.ignite.internal.processors.query.h2.IgniteH2Indexing;
import org.apache.ignite.internal.processors.query.h2.opt.GridH2ValueCacheObject;
import org.apache.ignite.internal.util.GridCloseableIteratorAdapter;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.h2.jdbc.JdbcResultSet;
import org.h2.result.ResultInterface;
import org.h2.value.Value;

public abstract class H2ResultSetIterator<T>
extends GridCloseableIteratorAdapter<T> {
    private static final Field RESULT_FIELD;
    private static final long serialVersionUID = 0L;
    private ResultInterface res;
    private ResultSet data;
    protected final Object[] row;
    private boolean hasRow;
    final H2QueryFetchSizeInterceptor fetchSizeInterceptor;

    protected H2ResultSetIterator(ResultSet data, IgniteLogger log, IgniteH2Indexing h2, H2QueryInfo qryInfo) throws IgniteCheckedException {
        this.data = data;
        try {
            this.res = (ResultInterface)RESULT_FIELD.get(data);
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException(e);
        }
        if (data != null) {
            try {
                this.row = new Object[data.getMetaData().getColumnCount()];
            }
            catch (SQLException e) {
                throw new IgniteCheckedException((Throwable)e);
            }
        } else {
            this.row = null;
        }
        assert (log != null);
        assert (h2 != null);
        assert (qryInfo != null);
        this.fetchSizeInterceptor = new H2QueryFetchSizeInterceptor(h2, qryInfo, log);
    }

    private boolean fetchNext() {
        if (this.data == null) {
            return false;
        }
        try {
            if (!this.data.next()) {
                this.onClose();
                return false;
            }
            if (this.res != null) {
                Value[] values = this.res.currentRow();
                for (int c = 0; c < this.row.length; ++c) {
                    Value val = values[c];
                    if (val instanceof GridH2ValueCacheObject) {
                        GridH2ValueCacheObject valCacheObj = (GridH2ValueCacheObject)values[c];
                        this.row[c] = valCacheObj.getObject(true);
                        continue;
                    }
                    this.row[c] = val.getObject();
                }
            } else {
                for (int c = 0; c < this.row.length; ++c) {
                    this.row[c] = this.data.getObject(c + 1);
                }
            }
            this.fetchSizeInterceptor.checkOnFetchNext();
            return true;
        }
        catch (SQLException e) {
            throw new IgniteSQLException(e);
        }
    }

    public boolean onHasNext() {
        return this.hasRow || (this.hasRow = this.fetchNext());
    }

    public T onNext() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        this.hasRow = false;
        return this.createRow();
    }

    protected abstract T createRow();

    public void onRemove() {
        throw new UnsupportedOperationException();
    }

    public void onClose() {
        if (this.data == null) {
            return;
        }
        this.fetchSizeInterceptor.checkOnFetchNext();
        U.closeQuiet((AutoCloseable)this.data);
        this.res = null;
        this.data = null;
    }

    public String toString() {
        return S.toString(H2ResultSetIterator.class, (Object)((Object)this));
    }

    static {
        try {
            RESULT_FIELD = JdbcResultSet.class.getDeclaredField("result");
            RESULT_FIELD.setAccessible(true);
        }
        catch (NoSuchFieldException e) {
            throw new IllegalStateException("Check H2 version in classpath.", e);
        }
    }
}

