/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.h2;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.internal.processors.query.IgniteSQLException;
import org.apache.ignite.internal.processors.query.h2.ConnectionManager;
import org.apache.ignite.internal.processors.query.h2.H2Utils;
import org.apache.ignite.internal.processors.query.h2.sql.GridSqlQueryParser;
import org.apache.ignite.internal.processors.query.h2.twostep.MapQueryLazyWorker;
import org.apache.ignite.internal.util.typedef.internal.LT;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.h2.command.Prepared;
import org.h2.command.dml.Query;
import org.h2.command.dml.Select;
import org.h2.command.dml.SelectUnion;
import org.h2.engine.Session;

public class H2QueryInfo {
    private final QueryType type;
    private final long beginTs;
    private final String schema;
    private final String sql;
    private final boolean enforceJoinOrder;
    private final boolean distributedJoin;
    private final boolean lazy;
    private final PreparedStatement stmt;

    public H2QueryInfo(QueryType type, PreparedStatement stmt, String sql) {
        try {
            assert (stmt != null);
            this.type = type;
            this.sql = sql;
            this.beginTs = U.currentTimeMillis();
            this.schema = stmt.getConnection().getSchema();
            Session s = H2Utils.session(stmt.getConnection());
            this.enforceJoinOrder = s.isForceJoinOrder();
            this.distributedJoin = s.isJoinBatchEnabled();
            this.lazy = s.isLazyQueryExecution() || MapQueryLazyWorker.currentWorker() != null;
            this.stmt = stmt;
        }
        catch (SQLException e) {
            throw new IgniteSQLException("Cannot collect query info", 1, (Throwable)e);
        }
    }

    protected void printInfo(StringBuilder msg) {
    }

    public long time() {
        return U.currentTimeMillis() - this.beginTs;
    }

    public void printLogMessage(IgniteLogger log, String msg, String additionalInfo) {
        this.printLogMessage(log, null, msg, additionalInfo);
    }

    public void printLogMessage(IgniteLogger log, ConnectionManager connMgr, String msg, String additionalInfo) {
        Prepared prep = GridSqlQueryParser.prepared(this.stmt);
        assert (prep instanceof Query);
        StringBuilder msgSb = new StringBuilder(msg + " [");
        if (additionalInfo != null) {
            msgSb.append(additionalInfo).append(", ");
        }
        msgSb.append("duration=").append(this.time()).append("ms").append(", type=").append((Object)this.type).append(", distributedJoin=").append(this.distributedJoin).append(", enforceJoinOrder=").append(this.enforceJoinOrder).append(", lazy=").append(this.lazy).append(", scansCount=[").append(H2QueryInfo.scanCounts((Query)prep)).append(']');
        msgSb.append(", sql='").append(this.sql);
        if (this.type != QueryType.REDUCE && connMgr != null) {
            msgSb.append("', plan=").append(this.queryPlan(log, connMgr));
        }
        this.printInfo(msgSb);
        msgSb.append(']');
        LT.warn((IgniteLogger)log, (String)msgSb.toString());
    }

    /*
     * Exception decompiling
     */
    protected String queryPlan(IgniteLogger log, ConnectionManager connMgr) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static String scanCounts(Query qry) {
        StringBuilder scanCnt = new StringBuilder();
        H2QueryInfo.printScanCounts(qry, scanCnt);
        return scanCnt.toString();
    }

    private static void printScanCounts(Query qry, StringBuilder sb) {
        if (qry.isUnion()) {
            SelectUnion union = (SelectUnion)qry;
            H2QueryInfo.printScanCounts(union.getLeft(), sb);
            H2QueryInfo.printScanCounts(union.getRight(), sb);
        } else {
            Select select = (Select)qry;
            select.getTopTableFilter().visit(f -> {
                if (sb.length() > 0) {
                    sb.append(", ");
                }
                sb.append("[alias=").append(f.getTableAlias());
                if (f.getTable() != null) {
                    sb.append(", table=").append(f.getTable().getName());
                }
                sb.append(", scan=").append(GridSqlQueryParser.TABLE_FILTER_SCAN_COUNT.get(f));
                sb.append("]");
            });
        }
    }

    public boolean lazy() {
        return this.lazy;
    }

    public static enum QueryType {
        LOCAL,
        MAP,
        REDUCE;

    }
}

