/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.h2;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.processors.query.IgniteSQLException;
import org.apache.ignite.internal.processors.query.h2.H2CachedStatementKey;
import org.apache.ignite.internal.processors.query.h2.H2ConnectionWrapper;
import org.apache.ignite.internal.processors.query.h2.H2StatementCache;
import org.apache.ignite.internal.processors.query.h2.ThreadLocalObjectPool;
import org.apache.ignite.internal.processors.query.h2.opt.GridH2DefaultTableEngine;
import org.apache.ignite.internal.processors.query.h2.opt.GridH2PlainRowFactory;
import org.apache.ignite.internal.processors.query.h2.opt.GridH2Table;
import org.apache.ignite.internal.processors.query.h2.sql.GridSqlQueryParser;
import org.apache.ignite.internal.processors.timeout.GridTimeoutProcessor;
import org.apache.ignite.internal.util.IgniteUtils;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.h2.Driver;
import org.h2.jdbc.JdbcStatement;
import org.jetbrains.annotations.Nullable;

public class ConnectionManager {
    private static final String DB_OPTIONS = ";LOCK_MODE=3;MULTI_THREADED=1;DB_CLOSE_ON_EXIT=FALSE;DEFAULT_LOCK_TIMEOUT=10000;FUNCTIONS_IN_SCHEMA=true;OPTIMIZE_REUSE_RESULTS=0;QUERY_CACHE_SIZE=0;RECOMPILE_ALWAYS=1;MAX_OPERATION_MEMORY=0;NESTED_JOINS=0;BATCH_JOINS=1;ROW_FACTORY=\"" + GridH2PlainRowFactory.class.getName() + "\";DEFAULT_TABLE_ENGINE=" + GridH2DefaultTableEngine.class.getName();
    private static final Long CONN_CLEANUP_PERIOD = 2000L;
    private final Long stmtCleanupPeriod = Long.getLong("IGNITE_H2_INDEXING_CACHE_CLEANUP_PERIOD", 10000L);
    private final Long stmtTimeout = Long.getLong("IGNITE_H2_INDEXING_CACHE_THREAD_USAGE_TIMEOUT", 600000L);
    private final ThreadLocalObjectPool<H2ConnectionWrapper> connPool = new ThreadLocalObjectPool<H2ConnectionWrapper>(5, this::newConnectionWrapper, this::closeDetachedConnection, this::addConnectionToThreaded);
    private final ConcurrentMap<Thread, ConcurrentMap<H2ConnectionWrapper, Boolean>> threadConns = new ConcurrentHashMap<Thread, ConcurrentMap<H2ConnectionWrapper, Boolean>>();
    private final ConcurrentMap<H2ConnectionWrapper, Boolean> detachedConns = new ConcurrentHashMap<H2ConnectionWrapper, Boolean>();
    private final ThreadLocal<ThreadLocalObjectPool.Reusable> threadConn = new ThreadLocal<ThreadLocalObjectPool.Reusable>(){

        @Override
        public ThreadLocalObjectPool.Reusable get() {
            ThreadLocalObjectPool.Reusable reusable = (ThreadLocalObjectPool.Reusable)super.get();
            boolean reconnect = true;
            try {
                reconnect = reusable == null || ((H2ConnectionWrapper)reusable.object()).connection().isClosed();
            }
            catch (SQLException e) {
                U.warn((IgniteLogger)ConnectionManager.this.log, (Object)"Failed to check connection status.", (Throwable)e);
            }
            if (reconnect) {
                reusable = this.initialValue();
                this.set(reusable);
            }
            return reusable;
        }

        @Override
        protected ThreadLocalObjectPool.Reusable initialValue() {
            ThreadLocalObjectPool.Reusable reusableConnection = ConnectionManager.this.connPool.borrow();
            ConnectionManager.this.addConnectionToThreaded((H2ConnectionWrapper)reusableConnection.object());
            return reusableConnection;
        }
    };
    private final String dbUrl;
    private final GridTimeoutProcessor.CancelableTask connCleanupTask;
    private final GridTimeoutProcessor.CancelableTask stmtCleanupTask;
    private volatile Connection sysConn;
    private final IgniteLogger log;

    public ConnectionManager(GridKernalContext ctx) {
        this.dbUrl = "jdbc:h2:mem:" + ctx.localNodeId() + DB_OPTIONS;
        this.log = ctx.log(ConnectionManager.class);
        Driver.load();
        this.sysConn = this.connectionNoCache("INFORMATION_SCHEMA");
        this.stmtCleanupTask = ctx.timeout().schedule(this::cleanupStatements, this.stmtCleanupPeriod.longValue(), this.stmtCleanupPeriod.longValue());
        this.connCleanupTask = ctx.timeout().schedule(this::cleanupConnections, CONN_CLEANUP_PERIOD.longValue(), CONN_CLEANUP_PERIOD.longValue());
    }

    public H2ConnectionWrapper connectionForThread() {
        return (H2ConnectionWrapper)this.threadConn.get().object();
    }

    public Map<Thread, ConcurrentMap<H2ConnectionWrapper, Boolean>> connectionsForThread() {
        return this.threadConns;
    }

    public ThreadLocalObjectPool.Reusable detachThreadConnection() {
        Thread key = Thread.currentThread();
        ThreadLocalObjectPool.Reusable reusableConn = this.threadConn.get();
        ConcurrentMap connSet = (ConcurrentMap)this.threadConns.get(key);
        assert (connSet != null);
        Boolean rmv = (Boolean)connSet.remove(reusableConn.object());
        assert (rmv != null);
        this.threadConn.remove();
        this.detachedConns.putIfAbsent((H2ConnectionWrapper)reusableConn.object(), false);
        return reusableConn;
    }

    public Connection connectionNoCache(String schema) throws IgniteSQLException {
        try {
            return this.newConnectionWrapper().connection(schema);
        }
        catch (Exception e) {
            throw new IgniteSQLException("Failed to initialize system DB connection: " + this.dbUrl, (Throwable)e);
        }
    }

    public H2StatementCache statementCacheForThread() {
        H2StatementCache statementCache = ((H2ConnectionWrapper)this.threadConn.get().object()).statementCache();
        statementCache.updateLastUsage();
        return statementCache;
    }

    public void executeStatement(String schema, String sql) throws IgniteCheckedException {
        Statement stmt = null;
        Connection c = null;
        try {
            c = this.connectionForThread().connection(schema);
            stmt = c.createStatement();
            stmt.executeUpdate(sql);
        }
        catch (SQLException e) {
            try {
                this.onSqlException(c);
                throw new IgniteCheckedException("Failed to execute statement: " + sql, (Throwable)e);
            }
            catch (Throwable throwable) {
                U.close(stmt, (IgniteLogger)this.log);
                throw throwable;
            }
        }
        U.close((AutoCloseable)stmt, (IgniteLogger)this.log);
    }

    public void executeSystemStatement(String sql) throws IgniteCheckedException {
        Statement stmt = null;
        try {
            stmt = this.sysConn.createStatement();
            stmt.executeUpdate(sql);
        }
        catch (SQLException e) {
            U.close((AutoCloseable)this.sysConn, (IgniteLogger)this.log);
            throw new IgniteCheckedException("Failed to execute system statement: " + sql, (Throwable)e);
        }
        finally {
            U.close((AutoCloseable)stmt, (IgniteLogger)this.log);
        }
    }

    @Nullable
    public PreparedStatement cachedPreparedStatement(Connection c, String sql) throws SQLException {
        H2CachedStatementKey key;
        H2StatementCache cache = this.statementCacheForThread();
        PreparedStatement stmt = cache.get(key = new H2CachedStatementKey(c.getSchema(), sql));
        if (stmt == null) {
            return null;
        }
        if (stmt.getConnection() != c) {
            return null;
        }
        if (stmt.isClosed() || stmt.unwrap(JdbcStatement.class).isCancelled() || GridSqlQueryParser.prepared(stmt).needRecompile()) {
            return null;
        }
        return stmt;
    }

    public PreparedStatement prepareStatement(Connection c, String sql) throws SQLException {
        PreparedStatement stmt = this.cachedPreparedStatement(c, sql);
        if (stmt == null) {
            H2StatementCache cache = this.statementCacheForThread();
            H2CachedStatementKey key = new H2CachedStatementKey(c.getSchema(), sql);
            stmt = this.prepareStatementNoCache(c, sql);
            cache.put(key, stmt);
        }
        return stmt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PreparedStatement prepareStatementNoCache(Connection c, String sql) throws SQLException {
        boolean insertHack = GridH2Table.insertHackRequired(sql);
        if (insertHack) {
            GridH2Table.insertHack(true);
            try {
                PreparedStatement preparedStatement = c.prepareStatement(sql, 1004, 1007);
                return preparedStatement;
            }
            finally {
                GridH2Table.insertHack(false);
            }
        }
        return c.prepareStatement(sql, 1004, 1007);
    }

    public void onCacheDestroyed() {
        this.threadConns.values().forEach(set -> set.keySet().forEach(H2ConnectionWrapper::clearStatementCache));
    }

    private void closeConnections() {
        this.threadConns.values().forEach(set -> set.keySet().forEach(IgniteUtils::closeQuiet));
        this.detachedConns.keySet().forEach(IgniteUtils::closeQuiet);
        this.threadConns.clear();
        this.detachedConns.clear();
        if (this.sysConn != null) {
            U.close((AutoCloseable)this.sysConn, (IgniteLogger)this.log);
            this.sysConn = null;
        }
    }

    public void onKernalStop() {
        this.closeConnections();
    }

    public void stop() {
        if (this.stmtCleanupTask != null) {
            this.stmtCleanupTask.close();
        }
        if (this.connCleanupTask != null) {
            this.connCleanupTask.close();
        }
        this.closeConnections();
        try (Connection c = this.connectionNoCache("INFORMATION_SCHEMA");
             Statement s = c.createStatement();){
            s.execute("SHUTDOWN");
        }
        catch (SQLException e) {
            U.error((IgniteLogger)this.log, (Object)"Failed to shutdown database.", (Throwable)e);
        }
    }

    public void onSqlException(Connection c) {
        H2ConnectionWrapper conn = (H2ConnectionWrapper)this.threadConn.get().object();
        if (conn.connection() == c) {
            this.threadConn.remove();
        }
        if (c != null) {
            this.threadConns.remove(Thread.currentThread());
            U.close((AutoCloseable)c, (IgniteLogger)this.log);
        }
    }

    private H2ConnectionWrapper newConnectionWrapper() {
        try {
            return new H2ConnectionWrapper(DriverManager.getConnection(this.dbUrl));
        }
        catch (SQLException e) {
            throw new IgniteSQLException("Failed to initialize DB connection: " + this.dbUrl, (Throwable)e);
        }
    }

    private void addConnectionToThreaded(H2ConnectionWrapper conn) {
        Thread cur = Thread.currentThread();
        ConcurrentHashMap<H2ConnectionWrapper, Boolean> setConn = (ConcurrentHashMap<H2ConnectionWrapper, Boolean>)this.threadConns.get(cur);
        if (setConn == null) {
            setConn = new ConcurrentHashMap<H2ConnectionWrapper, Boolean>();
            this.threadConns.putIfAbsent(cur, setConn);
        }
        setConn.put(conn, false);
        this.detachedConns.remove(conn);
    }

    private void closeDetachedConnection(H2ConnectionWrapper conn) {
        U.close((AutoCloseable)conn, (IgniteLogger)this.log);
        this.detachedConns.remove(conn);
    }

    private void cleanupConnections() {
        this.threadConns.entrySet().removeIf(e -> {
            Thread t = (Thread)e.getKey();
            if (t.getState() == Thread.State.TERMINATED) {
                ((ConcurrentMap)e.getValue()).keySet().forEach(c -> U.close((AutoCloseable)c, (IgniteLogger)this.log));
                return true;
            }
            return false;
        });
    }

    private void cleanupStatements() {
        long now = U.currentTimeMillis();
        this.threadConns.values().forEach(set -> set.keySet().forEach(c -> {
            if (now - c.statementCache().lastUsage() > this.stmtTimeout) {
                c.clearStatementCache();
            }
        }));
    }

    static {
        System.setProperty("h2.objectCache", "false");
        System.setProperty("h2.serializeJavaObject", "false");
        System.setProperty("h2.objectCacheMaxPerElementSize", "0");
        System.setProperty("h2.optimizeTwoEquals", "false");
        System.setProperty("h2.dropRestrict", "false");
    }
}

