/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.h2.twostep;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.cache.CacheException;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.IgniteSystemProperties;
import org.apache.ignite.cache.query.QueryCancelledException;
import org.apache.ignite.cache.query.SqlFieldsQuery;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.events.CacheQueryExecutedEvent;
import org.apache.ignite.events.DiscoveryEvent;
import org.apache.ignite.events.Event;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.GridTopic;
import org.apache.ignite.internal.managers.communication.GridMessageListener;
import org.apache.ignite.internal.managers.eventstorage.GridLocalEventListener;
import org.apache.ignite.internal.processors.affinity.AffinityTopologyVersion;
import org.apache.ignite.internal.processors.cache.GridCacheContext;
import org.apache.ignite.internal.processors.cache.GridCacheSharedContext;
import org.apache.ignite.internal.processors.cache.query.CacheQueryType;
import org.apache.ignite.internal.processors.cache.query.GridCacheQueryMarshallable;
import org.apache.ignite.internal.processors.cache.query.GridCacheSqlQuery;
import org.apache.ignite.internal.processors.query.GridQueryCancel;
import org.apache.ignite.internal.processors.query.h2.H2StatementCache;
import org.apache.ignite.internal.processors.query.h2.H2Utils;
import org.apache.ignite.internal.processors.query.h2.IgniteH2Indexing;
import org.apache.ignite.internal.processors.query.h2.MapH2QueryInfo;
import org.apache.ignite.internal.processors.query.h2.UpdateResult;
import org.apache.ignite.internal.processors.query.h2.opt.DistributedJoinMode;
import org.apache.ignite.internal.processors.query.h2.opt.GridH2QueryContext;
import org.apache.ignite.internal.processors.query.h2.opt.GridH2QueryType;
import org.apache.ignite.internal.processors.query.h2.opt.GridH2RetryException;
import org.apache.ignite.internal.processors.query.h2.opt.GridH2StatementCleaner;
import org.apache.ignite.internal.processors.query.h2.twostep.MapNodeResults;
import org.apache.ignite.internal.processors.query.h2.twostep.MapQueryLazyWorker;
import org.apache.ignite.internal.processors.query.h2.twostep.MapQueryLazyWorkerKey;
import org.apache.ignite.internal.processors.query.h2.twostep.MapQueryResult;
import org.apache.ignite.internal.processors.query.h2.twostep.MapQueryResults;
import org.apache.ignite.internal.processors.query.h2.twostep.PartitionReservation;
import org.apache.ignite.internal.processors.query.h2.twostep.messages.GridQueryCancelRequest;
import org.apache.ignite.internal.processors.query.h2.twostep.messages.GridQueryFailResponse;
import org.apache.ignite.internal.processors.query.h2.twostep.messages.GridQueryNextPageRequest;
import org.apache.ignite.internal.processors.query.h2.twostep.messages.GridQueryNextPageResponse;
import org.apache.ignite.internal.processors.query.h2.twostep.msg.GridH2DmlRequest;
import org.apache.ignite.internal.processors.query.h2.twostep.msg.GridH2DmlResponse;
import org.apache.ignite.internal.processors.query.h2.twostep.msg.GridH2QueryRequest;
import org.apache.ignite.internal.processors.query.h2.twostep.msg.GridH2ValueMessageFactory;
import org.apache.ignite.internal.util.GridSpinBusyLock;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.X;
import org.apache.ignite.internal.util.typedef.internal.CU;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.internal.util.worker.GridWorker;
import org.apache.ignite.plugin.extensions.communication.Message;
import org.apache.ignite.spi.indexing.IndexingQueryFilter;
import org.apache.ignite.thread.IgniteThread;
import org.apache.ignite.thread.IgniteThreadPoolExecutor;
import org.h2.jdbc.JdbcResultSet;
import org.h2.jdbc.JdbcSQLException;
import org.h2.value.Value;

public class GridMapQueryExecutor {
    public static final boolean USE_POOL_FOR_LAZY_STUB = IgniteSystemProperties.getBoolean((String)"IGNITE_USE_POOL_FOR_LAZY_QUERIES");
    public static final boolean FORCE_LAZY = IgniteSystemProperties.getBoolean((String)"IGNITE_SQL_FORCE_LAZY_RESULT_SET");
    private IgniteLogger log;
    private GridKernalContext ctx;
    private IgniteH2Indexing h2;
    private ConcurrentMap<UUID, MapNodeResults> qryRess = new ConcurrentHashMap<UUID, MapNodeResults>();
    private final GridSpinBusyLock busyLock;
    private final ConcurrentHashMap<MapQueryLazyWorkerKey, MapQueryLazyWorker> lazyWorkers = new ConcurrentHashMap();
    private final GridSpinBusyLock lazyWorkerBusyLock = new GridSpinBusyLock();
    private final AtomicBoolean lazyWorkerStopGuard = new AtomicBoolean();
    private static final int POOL_SIZE = 150;
    private IgniteThreadPoolExecutor lazyExecSvc;

    public GridMapQueryExecutor(GridSpinBusyLock busyLock) {
        this.busyLock = busyLock;
    }

    public void start(final GridKernalContext ctx, IgniteH2Indexing h2) throws IgniteCheckedException {
        this.ctx = ctx;
        this.h2 = h2;
        this.log = ctx.log(GridMapQueryExecutor.class);
        final UUID locNodeId = ctx.localNodeId();
        ctx.event().addLocalEventListener(new GridLocalEventListener(){

            public void onEvent(Event evt) {
                UUID nodeId = ((DiscoveryEvent)evt).eventNode().id();
                GridH2QueryContext.clearAfterDeadNode(locNodeId, nodeId);
                MapNodeResults nodeRess = (MapNodeResults)GridMapQueryExecutor.this.qryRess.remove(nodeId);
                if (nodeRess == null) {
                    return;
                }
                nodeRess.cancelAll();
            }
        }, 12, new int[]{11});
        ctx.io().addMessageListener(GridTopic.TOPIC_QUERY, new GridMessageListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onMessage(UUID nodeId, Object msg, byte plc) {
                if (!GridMapQueryExecutor.this.busyLock.enterBusy()) {
                    return;
                }
                try {
                    if (msg instanceof GridCacheQueryMarshallable) {
                        ((GridCacheQueryMarshallable)msg).unmarshall(ctx.config().getMarshaller(), ctx);
                    }
                    GridMapQueryExecutor.this.onMessage(nodeId, msg);
                }
                finally {
                    GridMapQueryExecutor.this.busyLock.leaveBusy();
                }
            }
        });
        if (USE_POOL_FOR_LAZY_STUB) {
            this.lazyExecSvc = new IgniteThreadPoolExecutor("lazyStub", ctx.igniteInstanceName(), 150, 150, 30000L, new SynchronousQueue());
        }
    }

    public void cancelLazyWorkers() {
        if (!this.lazyWorkerStopGuard.compareAndSet(false, true)) {
            return;
        }
        this.lazyWorkerBusyLock.block();
        for (MapQueryLazyWorker worker : this.lazyWorkers.values()) {
            worker.stop(false);
            if (!USE_POOL_FOR_LAZY_STUB) continue;
            this.lazyExecSvc.remove((Runnable)((Object)worker));
        }
        this.lazyWorkers.clear();
        if (USE_POOL_FOR_LAZY_STUB) {
            this.lazyExecSvc.shutdownNow();
        }
    }

    public void onMessage(UUID nodeId, Object msg) {
        try {
            assert (msg != null);
            ClusterNode node = this.ctx.discovery().node(nodeId);
            if (node == null) {
                return;
            }
            boolean processed = true;
            if (msg instanceof GridH2QueryRequest) {
                this.onQueryRequest(node, (GridH2QueryRequest)msg);
            } else if (msg instanceof GridQueryNextPageRequest) {
                this.onNextPageRequest(node, (GridQueryNextPageRequest)msg);
            } else if (msg instanceof GridQueryCancelRequest) {
                this.onCancel(node, (GridQueryCancelRequest)msg);
            } else if (msg instanceof GridH2DmlRequest) {
                this.onDmlRequest(node, (GridH2DmlRequest)msg);
            } else {
                processed = false;
            }
            if (processed && this.log.isDebugEnabled()) {
                this.log.debug("Processed request: " + nodeId + "->" + this.ctx.localNodeId() + " " + msg);
            }
        }
        catch (Throwable th) {
            U.error((IgniteLogger)this.log, (Object)("Failed to process message: " + msg), (Throwable)th);
        }
    }

    GridSpinBusyLock busyLock() {
        return this.busyLock;
    }

    private void onCancel(ClusterNode node, GridQueryCancelRequest msg) {
        long qryReqId = msg.queryRequestId();
        MapNodeResults nodeRess = this.resultsForNode(node.id());
        boolean clear = GridH2QueryContext.clear(this.ctx.localNodeId(), node.id(), qryReqId, GridH2QueryType.MAP);
        if (!clear) {
            nodeRess.onCancel(qryReqId);
            GridH2QueryContext.clear(this.ctx.localNodeId(), node.id(), qryReqId, GridH2QueryType.MAP);
        }
        nodeRess.cancelRequest(qryReqId);
    }

    private MapNodeResults resultsForNode(UUID nodeId) {
        MapNodeResults old;
        MapNodeResults nodeRess = (MapNodeResults)this.qryRess.get(nodeId);
        if (nodeRess == null && (old = this.qryRess.putIfAbsent(nodeId, nodeRess = new MapNodeResults(nodeId))) != null) {
            nodeRess = old;
        }
        return nodeRess;
    }

    private void onQueryRequest(final ClusterNode node, final GridH2QueryRequest req) throws IgniteCheckedException {
        int[] qryParts = req.queryPartitions();
        final Map<UUID, int[]> partsMap = req.partitions();
        final int[] parts = qryParts == null ? (Object)(partsMap == null ? null : partsMap.get(this.ctx.localNodeId())) : qryParts;
        final DistributedJoinMode joinMode = DistributedJoinMode.distributedJoinMode(req.isFlagSet(4), req.isFlagSet(1));
        final boolean enforceJoinOrder = req.isFlagSet(2);
        boolean explain = req.isFlagSet(8);
        boolean replicated = req.isFlagSet(16);
        boolean lazy = FORCE_LAZY && req.queries().size() == 1 || req.isFlagSet(32);
        final List<Integer> cacheIds = req.caches();
        int segments = explain || replicated || F.isEmpty(cacheIds) ? 1 : CU.firstPartitioned((GridCacheSharedContext)this.ctx.cache().context(), cacheIds).config().getQueryParallelism();
        final Object[] params = req.parameters();
        for (int i = 1; i < segments; ++i) {
            assert (!F.isEmpty(cacheIds));
            final int segment = i;
            if (lazy) {
                this.onQueryRequest0(node, req.requestId(), segment, req.schemaName(), req.queries(), cacheIds, req.topologyVersion(), partsMap, parts, req.pageSize(), joinMode, enforceJoinOrder, false, req.timeout(), params, true);
                continue;
            }
            this.ctx.closure().callLocal((Callable)new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    GridMapQueryExecutor.this.onQueryRequest0(node, req.requestId(), segment, req.schemaName(), req.queries(), cacheIds, req.topologyVersion(), partsMap, parts, req.pageSize(), joinMode, enforceJoinOrder, false, req.timeout(), params, false);
                    return null;
                }
            }, (byte)10);
        }
        this.onQueryRequest0(node, req.requestId(), 0, req.schemaName(), req.queries(), cacheIds, req.topologyVersion(), partsMap, parts, req.pageSize(), joinMode, enforceJoinOrder, replicated, req.timeout(), params, lazy);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onQueryRequest0(final ClusterNode node, final long reqId, final int segmentId, final String schemaName, final Collection<GridCacheSqlQuery> qrys, final List<Integer> cacheIds, final AffinityTopologyVersion topVer, final Map<UUID, int[]> partsMap, final int[] parts, final int pageSize, final DistributedJoinMode distributedJoinMode, final boolean enforceJoinOrder, final boolean replicated, final int timeout, final Object[] params, boolean lazy) {
        MapQueryLazyWorker worker = MapQueryLazyWorker.currentWorker();
        if (lazy && worker == null) {
            MapQueryLazyWorkerKey key = new MapQueryLazyWorkerKey(node.id(), reqId, segmentId);
            worker = new MapQueryLazyWorker(this.ctx.igniteInstanceName(), key, this.log, this);
            worker.submit(new Runnable(){

                @Override
                public void run() {
                    GridMapQueryExecutor.this.onQueryRequest0(node, reqId, segmentId, schemaName, qrys, cacheIds, topVer, partsMap, parts, pageSize, distributedJoinMode, enforceJoinOrder, replicated, timeout, params, true);
                }
            });
            if (this.lazyWorkerBusyLock.enterBusy()) {
                try {
                    MapQueryLazyWorker oldWorker = this.lazyWorkers.put(key, worker);
                    if (oldWorker != null) {
                        oldWorker.stop(false);
                    }
                    if (USE_POOL_FOR_LAZY_STUB) {
                        try {
                            this.lazyExecSvc.execute((Runnable)((Object)worker));
                        }
                        catch (RejectedExecutionException e) {
                            new IgniteThread((GridWorker)worker).start();
                        }
                    }
                    new IgniteThread((GridWorker)worker).start();
                }
                finally {
                    this.lazyWorkerBusyLock.leaveBusy();
                }
            } else {
                this.log.info("Ignored query request (node is stopping) [nodeId=" + node.id() + ", reqId=" + reqId + ']');
            }
            return;
        }
        GridCacheContext mainCctx = !F.isEmpty(cacheIds) ? this.ctx.cache().context().cacheContext(cacheIds.get(0).intValue()) : null;
        MapNodeResults nodeRess = this.resultsForNode(node.id());
        MapQueryResults qr = null;
        PartitionReservation reserved = null;
        try {
            if (topVer != null && (reserved = this.h2.partitionReservationManager().reservePartitions(cacheIds, topVer, parts, node.id(), reqId)).failed()) {
                if (lazy) {
                    this.stopAndUnregisterCurrentLazyWorker();
                }
                this.sendRetry(node, reqId, segmentId, reserved.error());
                return;
            }
            qr = new MapQueryResults(this.h2, reqId, qrys.size(), mainCctx, MapQueryLazyWorker.currentWorker());
            if (nodeRess.put(reqId, segmentId, qr) != null) {
                throw new IllegalStateException();
            }
            GridH2QueryContext qctx = new GridH2QueryContext(this.ctx.localNodeId(), node.id(), reqId, segmentId, replicated ? GridH2QueryType.REPLICATED : GridH2QueryType.MAP).filter(this.h2.backupFilter(topVer, parts)).partitionsMap(partsMap).distributedJoinMode(distributedJoinMode).pageSize(pageSize).topologyVersion(topVer).reservations(reserved).lazyWorker(worker);
            Connection conn = this.h2.connections().connectionForThread().connection(schemaName);
            H2Utils.setupConnection(conn, distributedJoinMode != DistributedJoinMode.OFF, enforceJoinOrder);
            GridH2QueryContext.set(qctx);
            reserved = null;
            try {
                if (nodeRess.cancelled(reqId)) {
                    GridH2QueryContext.clear(this.ctx.localNodeId(), node.id(), reqId, qctx.type());
                    nodeRess.cancelRequest(reqId);
                    throw new QueryCancelledException();
                }
                int qryIdx = 0;
                boolean evt = mainCctx != null && mainCctx.events().isRecordable(96);
                for (GridCacheSqlQuery qry : qrys) {
                    ResultSet rs = null;
                    MapH2QueryInfo qryInfo = null;
                    if (qry.node() == null || segmentId == 0 && qry.node().equals(this.ctx.localNodeId())) {
                        List params0 = F.asList((Object[])qry.parameters(params));
                        PreparedStatement stmt = this.h2.preparedStatementWithParams(conn, qry.query(), params0, true, H2StatementCache.queryFlags(distributedJoinMode != DistributedJoinMode.OFF, enforceJoinOrder, false));
                        GridH2StatementCleaner stmtCleaner = GridH2StatementCleaner.fromPrepared(stmt);
                        qctx.addResource(stmtCleaner);
                        qryInfo = new MapH2QueryInfo(stmt, qry.query(), node, reqId, segmentId);
                        rs = this.h2.executeSqlQueryWithTimer(stmt, conn, qry.query(), params0, timeout, qr.queryCancel(qryIdx), qryInfo);
                        if (evt) {
                            this.ctx.event().record((Event)new CacheQueryExecutedEvent(node, "SQL query executed.", 96, CacheQueryType.SQL.name(), mainCctx.name(), null, qry.query(), null, null, params, node.id(), null));
                        }
                        assert (rs instanceof JdbcResultSet) : rs.getClass();
                    }
                    qr.addResult(qryIdx, qry, node.id(), rs, params, this.log, qryInfo);
                    if (qr.cancelled()) {
                        qr.result(qryIdx).close();
                        throw new QueryCancelledException();
                    }
                    this.sendNextPage(nodeRess, node, qr, qryIdx, segmentId, pageSize);
                    ++qryIdx;
                }
                if (!lazy) {
                    this.releaseReservations();
                }
            }
            catch (Throwable e) {
                this.releaseReservations();
                throw e;
            }
        }
        catch (Throwable e) {
            if (qr != null) {
                nodeRess.remove(reqId, segmentId, qr);
                qr.cancel(false);
            }
            if (lazy) {
                this.stopAndUnregisterCurrentLazyWorker();
            }
            if (e instanceof QueryCancelledException) {
                this.sendError(node, reqId, e);
            } else {
                GridH2RetryException retryErr = (GridH2RetryException)((Object)X.cause((Throwable)e, GridH2RetryException.class));
                if (retryErr != null) {
                    String retryCause = String.format("Failed to execute non-collocated query (will retry) [localNodeId=%s, rmtNodeId=%s, reqId=%s, errMsg=%s]", this.ctx.localNodeId(), node.id(), reqId, retryErr.getMessage());
                    this.sendRetry(node, reqId, segmentId, retryCause);
                } else {
                    U.error((IgniteLogger)this.log, (Object)"Failed to execute local query.", (Throwable)e);
                    this.sendError(node, reqId, e);
                    if (e instanceof Error) {
                        throw (Error)e;
                    }
                }
            }
        }
        finally {
            if (reserved != null) {
                reserved.release();
            }
        }
    }

    private void releaseReservations() {
        GridH2QueryContext qctx = GridH2QueryContext.get();
        if (qctx != null) {
            qctx.closeResources();
            GridH2QueryContext.clearThreadLocal();
            if (qctx.distributedJoinMode() == DistributedJoinMode.OFF) {
                qctx.clearContext(false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onDmlRequest(ClusterNode node, GridH2DmlRequest req) throws IgniteCheckedException {
        int[] parts = req.queryPartitions();
        List<Integer> cacheIds = req.caches();
        long reqId = req.requestId();
        AffinityTopologyVersion topVer = req.topologyVersion();
        PartitionReservation reserved = null;
        MapNodeResults nodeResults = this.resultsForNode(node.id());
        try {
            boolean evt;
            reserved = this.h2.partitionReservationManager().reservePartitions(cacheIds, topVer, parts, node.id(), reqId);
            if (reserved.failed()) {
                U.error((IgniteLogger)this.log, (Object)("Failed to reserve partitions for DML request. [localNodeId=" + this.ctx.localNodeId() + ", nodeId=" + node.id() + ", reqId=" + req.requestId() + ", cacheIds=" + cacheIds + ", topVer=" + topVer + ", parts=" + Arrays.toString(parts) + ']'));
                this.sendUpdateResponse(node, reqId, null, "Failed to reserve partitions for DML request. " + reserved.error());
                return;
            }
            IndexingQueryFilter filter = this.h2.backupFilter(topVer, parts);
            GridQueryCancel cancel = nodeResults.putUpdate(reqId);
            SqlFieldsQuery fldsQry = new SqlFieldsQuery(req.query());
            if (req.parameters() != null) {
                fldsQry.setArgs(req.parameters());
            }
            fldsQry.setEnforceJoinOrder(req.isFlagSet(2));
            fldsQry.setTimeout(req.timeout(), TimeUnit.MILLISECONDS);
            fldsQry.setPageSize(req.pageSize());
            fldsQry.setLocal(true);
            boolean local = true;
            boolean replicated = req.isFlagSet(16);
            if (!replicated && !F.isEmpty(cacheIds) && CU.firstPartitioned((GridCacheSharedContext)this.ctx.cache().context(), cacheIds).config().getQueryParallelism() > 1) {
                fldsQry.setDistributedJoins(true);
                local = false;
            }
            UpdateResult updRes = this.h2.mapDistributedUpdate(req.schemaName(), fldsQry, filter, cancel, local);
            GridCacheContext mainCctx = !F.isEmpty(cacheIds) ? this.ctx.cache().context().cacheContext(cacheIds.get(0).intValue()) : null;
            boolean bl = evt = local && mainCctx != null && mainCctx.events().isRecordable(96);
            if (evt) {
                this.ctx.event().record((Event)new CacheQueryExecutedEvent(node, "SQL query executed.", 96, CacheQueryType.SQL.name(), mainCctx.name(), null, req.query(), null, null, req.parameters(), node.id(), null));
            }
            this.sendUpdateResponse(node, reqId, updRes, null);
        }
        catch (Exception e) {
            U.error((IgniteLogger)this.log, (Object)("Error processing dml request. [localNodeId=" + this.ctx.localNodeId() + ", nodeId=" + node.id() + ", req=" + req + ']'), (Throwable)e);
            this.sendUpdateResponse(node, reqId, null, e.getMessage());
        }
        finally {
            if (reserved != null) {
                reserved.release();
            }
            nodeResults.removeUpdate(reqId);
        }
    }

    private void sendError(ClusterNode node, long qryReqId, Throwable err) {
        try {
            GridQueryFailResponse msg = new GridQueryFailResponse(qryReqId, err);
            if (node.isLocal()) {
                if (err instanceof QueryCancelledException) {
                    String errMsg = "Failed to run cancelled map query on local node: [localNodeId=" + node.id() + ", reqId=" + qryReqId + ']';
                    if (this.log.isDebugEnabled()) {
                        U.warn((IgniteLogger)this.log, (Object)errMsg, (Throwable)err);
                    } else if (this.log.isInfoEnabled()) {
                        this.log.info(errMsg);
                    }
                } else {
                    U.error((IgniteLogger)this.log, (Object)"Failed to run map query on local node.", (Throwable)err);
                }
                this.h2.reduceQueryExecutor().onMessage(this.ctx.localNodeId(), msg);
            } else {
                this.ctx.io().sendToGridTopic(node, GridTopic.TOPIC_QUERY, (Message)msg, (byte)10);
            }
        }
        catch (Exception e) {
            e.addSuppressed(err);
            U.error((IgniteLogger)this.log, (Object)"Failed to send error message.", (Throwable)e);
        }
    }

    private void sendUpdateResponse(ClusterNode node, long reqId, UpdateResult updResult, String error) {
        try {
            GridH2DmlResponse rsp = new GridH2DmlResponse(reqId, updResult == null ? 0L : updResult.counter(), updResult == null ? null : updResult.errorKeys(), error);
            if (this.log.isDebugEnabled()) {
                this.log.debug("Sending: [localNodeId=" + this.ctx.localNodeId() + ", node=" + node.id() + ", msg=" + rsp + "]");
            }
            if (node.isLocal()) {
                this.h2.reduceQueryExecutor().onMessage(this.ctx.localNodeId(), rsp);
            } else {
                rsp.marshall(this.ctx.config().getMarshaller());
                this.ctx.io().sendToGridTopic(node, GridTopic.TOPIC_QUERY, (Message)rsp, (byte)10);
            }
        }
        catch (Exception e) {
            U.error((IgniteLogger)this.log, (Object)"Failed to send message.", (Throwable)e);
        }
    }

    private void onNextPageRequest(final ClusterNode node, final GridQueryNextPageRequest req) {
        final MapNodeResults nodeRess = (MapNodeResults)this.qryRess.get(node.id());
        final long reqId = req.queryRequestId();
        if (nodeRess == null) {
            this.sendError(node, reqId, (Throwable)new CacheException("No node result found for request: " + req));
            return;
        }
        if (nodeRess.cancelled(req.queryRequestId())) {
            this.sendError(node, reqId, (Throwable)new QueryCancelledException());
            return;
        }
        final MapQueryResults qr = nodeRess.get(reqId, req.segmentId());
        if (qr == null) {
            this.sendError(node, reqId, (Throwable)new CacheException("No query result found for request: " + req));
        } else if (qr.cancelled()) {
            this.sendError(node, reqId, (Throwable)new QueryCancelledException());
        } else {
            MapQueryLazyWorker lazyWorker = qr.lazyWorker();
            if (lazyWorker != null) {
                lazyWorker.submit(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            GridMapQueryExecutor.this.sendNextPage(nodeRess, node, qr, req.query(), req.segmentId(), req.pageSize());
                        }
                        catch (Exception e) {
                            GridH2RetryException retryEx = (GridH2RetryException)((Object)X.cause((Throwable)e, GridH2RetryException.class));
                            if (retryEx != null) {
                                GridMapQueryExecutor.this.sendError(node, reqId, (Throwable)((Object)retryEx));
                            } else {
                                JdbcSQLException sqlEx = (JdbcSQLException)X.cause((Throwable)e, JdbcSQLException.class);
                                if (sqlEx != null && sqlEx.getErrorCode() == 57014) {
                                    GridMapQueryExecutor.this.sendError(node, reqId, (Throwable)new QueryCancelledException());
                                } else {
                                    GridMapQueryExecutor.this.sendError(node, reqId, e);
                                }
                            }
                            qr.cancel(false);
                        }
                    }
                });
            } else {
                this.sendNextPage(nodeRess, node, qr, req.query(), req.segmentId(), req.pageSize());
            }
        }
    }

    private void sendNextPage(MapNodeResults nodeRess, ClusterNode node, MapQueryResults qr, int qry, int segmentId, int pageSize) {
        MapQueryResult res = qr.result(qry);
        assert (res != null);
        if (res.closed()) {
            return;
        }
        int page = res.page();
        ArrayList<Value[]> rows = new ArrayList<Value[]>(Math.min(64, pageSize));
        boolean last = res.fetchNextPage(rows, pageSize);
        if (last) {
            res.close();
            if (qr.isAllClosed()) {
                nodeRess.remove(qr.queryRequestId(), segmentId, qr);
                if (MapQueryLazyWorker.currentWorker() != null) {
                    this.releaseReservations();
                }
            }
        }
        try {
            boolean loc = node.isLocal();
            GridQueryNextPageResponse msg = new GridQueryNextPageResponse(qr.queryRequestId(), segmentId, qry, page, page == 0 ? res.rowCount() : -1, res.columnCount(), loc ? null : GridH2ValueMessageFactory.toMessages(rows, new ArrayList<Message>(res.columnCount())), loc ? rows : null, last);
            if (loc) {
                this.h2.reduceQueryExecutor().onMessage(this.ctx.localNodeId(), msg);
            } else {
                this.ctx.io().sendToGridTopic(node, GridTopic.TOPIC_QUERY, (Message)msg, (byte)10);
            }
        }
        catch (IgniteCheckedException e) {
            U.error((IgniteLogger)this.log, (Object)"Failed to send message.", (Throwable)e);
            throw new IgniteException((Throwable)e);
        }
    }

    private void sendRetry(ClusterNode node, long reqId, int segmentId, String retryCause) {
        try {
            boolean loc = node.isLocal();
            GridQueryNextPageResponse msg = new GridQueryNextPageResponse(reqId, segmentId, 0, 0, 0, 1, loc ? null : Collections.emptyList(), loc ? Collections.emptyList() : null, false);
            msg.retry(this.h2.readyTopologyVersion());
            msg.retryCause(retryCause);
            if (loc) {
                this.h2.reduceQueryExecutor().onMessage(this.ctx.localNodeId(), msg);
            } else {
                this.ctx.io().sendToGridTopic(node, GridTopic.TOPIC_QUERY, (Message)msg, (byte)10);
            }
        }
        catch (Exception e) {
            U.warn((IgniteLogger)this.log, (Object)("Failed to send retry message: " + e.getMessage()));
        }
    }

    public void stopAndUnregisterCurrentLazyWorker() {
        MapQueryLazyWorker worker = MapQueryLazyWorker.currentWorker();
        if (worker != null) {
            worker.stop(false);
            this.unregisterLazyWorker(worker);
        }
    }

    public void unregisterLazyWorker(MapQueryLazyWorker worker) {
        this.lazyWorkers.remove(worker.key(), (Object)worker);
        if (USE_POOL_FOR_LAZY_STUB) {
            this.lazyExecSvc.remove((Runnable)((Object)worker));
        }
    }

    public int registeredLazyWorkers() {
        return this.lazyWorkers.size();
    }
}

