/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.h2.sys.view;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.function.Predicate;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.processors.cache.CacheGroupDescriptor;
import org.apache.ignite.internal.processors.query.h2.IgniteH2Indexing;
import org.apache.ignite.internal.processors.query.h2.database.IndexInformation;
import org.apache.ignite.internal.processors.query.h2.opt.GridH2Table;
import org.apache.ignite.internal.processors.query.h2.sys.view.SqlAbstractLocalSystemView;
import org.apache.ignite.internal.processors.query.h2.sys.view.SqlSystemViewColumnCondition;
import org.h2.engine.Session;
import org.h2.result.Row;
import org.h2.result.SearchRow;

public class SqlSystemViewIndexes
extends SqlAbstractLocalSystemView {
    private final IgniteH2Indexing idx;

    public SqlSystemViewIndexes(GridKernalContext ctx, IgniteH2Indexing idx) {
        super("INDEXES", "Ignite SQL indexes", ctx, "TABLE_NAME", SqlSystemViewIndexes.newColumn("SCHEMA_NAME"), SqlSystemViewIndexes.newColumn("TABLE_NAME"), SqlSystemViewIndexes.newColumn("INDEX_NAME"), SqlSystemViewIndexes.newColumn("COLUMNS"), SqlSystemViewIndexes.newColumn("INDEX_TYPE"), SqlSystemViewIndexes.newColumn("IS_PK", 1), SqlSystemViewIndexes.newColumn("IS_UNIQUE", 1), SqlSystemViewIndexes.newColumn("CACHE_ID", 4), SqlSystemViewIndexes.newColumn("CACHE_NAME"), SqlSystemViewIndexes.newColumn("GROUP_ID", 4), SqlSystemViewIndexes.newColumn("GROUP_NAME"), SqlSystemViewIndexes.newColumn("INLINE_SIZE", 4));
        this.idx = idx;
    }

    @Override
    public Iterator<Row> getRows(Session ses, SearchRow first, SearchRow last) {
        Predicate<GridH2Table> filter;
        SqlSystemViewColumnCondition tblNameCond = this.conditionForColumn("TABLE_NAME", first, last);
        if (tblNameCond.isEquality()) {
            String tblName = tblNameCond.valueForEquality().getString();
            filter = tbl -> tblName.equals(tbl.getName());
        } else {
            filter = tbl -> true;
        }
        ArrayList rows = new ArrayList();
        this.idx.dataTables().stream().filter(filter).forEach(tbl -> {
            String schema = tbl.getSchema().getName();
            String tblName = tbl.getName();
            int grpId = tbl.cache().groupId();
            String grpName = ((CacheGroupDescriptor)this.ctx.cache().cacheGroupDescriptors().get(grpId)).cacheOrGroupName();
            int cacheId = tbl.cacheId();
            String cacheName = tbl.cacheName();
            List<IndexInformation> idxInfoList = tbl.indexesInformation();
            for (IndexInformation idxInfo : idxInfoList) {
                Object[] data = new Object[]{schema, tblName, idxInfo.name(), idxInfo.keySql(), idxInfo.type(), idxInfo.pk(), idxInfo.unique(), cacheId, cacheName, grpId, grpName, idxInfo.inlineSize()};
                rows.add(this.createRow(ses, rows.size(), data));
            }
        });
        return rows.iterator();
    }

    @Override
    public boolean canGetRowCount() {
        return true;
    }

    @Override
    public long getRowCount() {
        return this.idx.dataTables().stream().mapToInt(t -> t.indexesInformation().size()).sum();
    }
}

