/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.h2.opt;

import java.util.Arrays;
import java.util.HashSet;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.IgniteSystemProperties;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.processors.query.h2.opt.GridH2Table;
import org.apache.ignite.internal.util.typedef.internal.LT;
import org.h2.index.BaseIndex;
import org.h2.result.SortOrder;
import org.h2.table.Column;
import org.h2.table.IndexColumn;
import org.h2.table.TableFilter;

public abstract class H2IndexCostedBase
extends BaseIndex {
    private final CostFunction constFunc;
    private final IgniteLogger log;

    protected H2IndexCostedBase(GridH2Table tbl) {
        this(tbl != null ? tbl.rowDescriptor().tableDescriptor().indexing().kernalContext() : null);
    }

    protected H2IndexCostedBase(GridKernalContext ctx) {
        CostFunctionType costFuncType;
        this.log = ctx != null ? ctx.log("H2Index") : null;
        try {
            costFuncType = CostFunctionType.valueOf(IgniteSystemProperties.getString((String)"IGNITE_INDEX_COST_FUNCTION", (String)CostFunctionType.LAST.name()));
        }
        catch (IllegalArgumentException e) {
            if (this.log != null) {
                this.log.warning("Invalid cost function: " + IgniteSystemProperties.getString((String)"IGNITE_INDEX_COST_FUNCTION") + ", the LAST cost function is used. Available functions: " + Arrays.toString((Object[])CostFunctionType.values()));
            } else {
                LT.warn((IgniteLogger)this.log, (String)("Invalid cost function: " + IgniteSystemProperties.getString((String)"IGNITE_INDEX_COST_FUNCTION") + ", the LAST cost function is used. Available functions: " + Arrays.toString((Object[])CostFunctionType.values())));
            }
            costFuncType = CostFunctionType.LAST;
        }
        switch (costFuncType) {
            case COMPATIBLE_8_5_17: {
                this.constFunc = this::getCostRangeIndex_8_7_12;
                break;
            }
            case COMPATIBLE_8_5_13: {
                this.constFunc = this::getCostRangeIndex_8_7_6;
                break;
            }
            default: {
                this.constFunc = this::getCostRangeIndex_Last;
            }
        }
    }

    protected long costRangeIndex(int[] masks, long rowCount, TableFilter[] filters, int filter, SortOrder sortOrder, boolean isScanIndex, HashSet<Column> allColumnsSet) {
        return this.constFunc.getCostRangeIndex(masks, rowCount, filters, filter, sortOrder, isScanIndex, allColumnsSet);
    }

    private long getCostRangeIndex_Last(int[] masks, long rowCount, TableFilter[] filters, int filter, SortOrder sortOrder, boolean isScanIndex, HashSet<Column> allColumnsSet) {
        int totalSelectivity = 0;
        long rowsCost = rowCount += 1000L;
        if (masks != null) {
            int i = 0;
            int len = this.columns.length;
            while (i < len) {
                Column column;
                int index;
                int mask;
                if (((mask = masks[index = (column = this.columns[i++]).getColumnId()]) & 1) == 1) {
                    if (i == len && this.getIndexType().isUnique()) {
                        rowsCost = 3L;
                        break;
                    }
                    long distinctRows = rowCount * (long)(totalSelectivity = 100 - (100 - totalSelectivity) * (100 - column.getSelectivity()) / 100) / 100L;
                    if (distinctRows <= 0L) {
                        distinctRows = 1L;
                    }
                    rowsCost = Math.min(5L + Math.max(rowsCost / distinctRows, 1L), rowsCost - (long)(i > 0 ? 1 : 0));
                    continue;
                }
                if ((mask & 6) == 6) {
                    rowsCost = Math.min(5L + rowsCost / 4L, rowsCost - (long)(i > 0 ? 1 : 0));
                    break;
                }
                if ((mask & 2) == 2) {
                    rowsCost = Math.min(5L + rowsCost / 3L, rowsCost - (long)(i > 0 ? 1 : 0));
                    break;
                }
                if ((mask & 4) != 4) break;
                rowsCost = Math.min(rowsCost / 3L, rowsCost - (long)(i > 0 ? 1 : 0));
                break;
            }
        }
        long sortingCost = 0L;
        if (sortOrder != null) {
            sortingCost = 100L + rowCount / 10L;
        }
        if (sortOrder != null && !isScanIndex) {
            boolean sortOrderMatches = true;
            int coveringCount = 0;
            int[] sortTypes = sortOrder.getSortTypes();
            TableFilter tableFilter = filters == null ? null : filters[filter];
            int len = sortTypes.length;
            for (int i = 0; i < len && i < this.indexColumns.length; ++i) {
                Column col = sortOrder.getColumn(i, tableFilter);
                if (col == null) {
                    sortOrderMatches = false;
                    break;
                }
                IndexColumn indexCol = this.indexColumns[i];
                if (!col.equals((Object)indexCol.column)) {
                    sortOrderMatches = false;
                    break;
                }
                int sortType = sortTypes[i];
                if (sortType != indexCol.sortType) {
                    sortOrderMatches = false;
                    break;
                }
                ++coveringCount;
            }
            if (sortOrderMatches) {
                sortingCost = 100 - coveringCount;
            }
        }
        boolean needsToReadFromScanIndex = true;
        if (!isScanIndex && allColumnsSet != null && !allColumnsSet.isEmpty()) {
            boolean foundAllColumnsWeNeed = true;
            for (Column c : allColumnsSet) {
                if (c.getTable() != this.getTable()) continue;
                boolean found = false;
                for (Column c2 : this.getColumns()) {
                    if (c != c2) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                foundAllColumnsWeNeed = false;
                break;
            }
            if (foundAllColumnsWeNeed) {
                needsToReadFromScanIndex = false;
            }
        }
        long rc = isScanIndex ? rowsCost + sortingCost + 20L : (needsToReadFromScanIndex ? rowsCost + rowsCost + sortingCost + 20L : rowsCost + sortingCost + (long)this.getColumns().length);
        return rc;
    }

    protected final long getCostRangeIndex_8_7_12(int[] masks, long rowCount, TableFilter[] filters, int filter, SortOrder sortOrder, boolean isScanIndex, HashSet<Column> allColumnsSet) {
        int totalSelectivity = 0;
        long rowsCost = rowCount += 1000L;
        if (masks != null) {
            int i = 0;
            int len = this.columns.length;
            boolean tryAdditional = false;
            while (i < len) {
                Column column;
                int index;
                int mask;
                if (((mask = masks[index = (column = this.columns[i++]).getColumnId()]) & 1) == 1) {
                    if (i == len && this.getIndexType().isUnique()) {
                        rowsCost = 3L;
                        break;
                    }
                    long distinctRows = rowCount * (long)(totalSelectivity = 100 - (100 - totalSelectivity) * (100 - column.getSelectivity()) / 100) / 100L;
                    if (distinctRows <= 0L) {
                        distinctRows = 1L;
                    }
                    rowsCost = 2L + Math.max(rowCount / distinctRows, 1L);
                    continue;
                }
                if ((mask & 6) == 6) {
                    rowsCost = 2L + rowsCost / 4L;
                    tryAdditional = true;
                    break;
                }
                if ((mask & 2) == 2) {
                    rowsCost = 2L + rowsCost / 3L;
                    tryAdditional = true;
                    break;
                }
                if ((mask & 4) == 4) {
                    rowsCost /= 3L;
                    tryAdditional = true;
                    break;
                }
                if (mask != 0) break;
                --i;
                break;
            }
            if (tryAdditional) {
                while (i < len && masks[this.columns[i].getColumnId()] != 0) {
                    ++i;
                    --rowsCost;
                }
            }
            rowsCost += (long)(len - i);
        }
        long sortingCost = 0L;
        if (sortOrder != null) {
            sortingCost = 100L + rowCount / 10L;
        }
        if (sortOrder != null && !isScanIndex) {
            boolean sortOrderMatches = true;
            int coveringCount = 0;
            int[] sortTypes = sortOrder.getSortTypes();
            TableFilter tableFilter = filters == null ? null : filters[filter];
            int len = sortTypes.length;
            for (int i = 0; i < len && i < this.indexColumns.length; ++i) {
                Column col = sortOrder.getColumn(i, tableFilter);
                if (col == null) {
                    sortOrderMatches = false;
                    break;
                }
                IndexColumn indexCol = this.indexColumns[i];
                if (!col.equals((Object)indexCol.column)) {
                    sortOrderMatches = false;
                    break;
                }
                int sortType = sortTypes[i];
                if (sortType != indexCol.sortType) {
                    sortOrderMatches = false;
                    break;
                }
                ++coveringCount;
            }
            if (sortOrderMatches) {
                sortingCost = 100 - coveringCount;
            }
        }
        boolean needsToReadFromScanIndex = true;
        if (!isScanIndex && allColumnsSet != null && !allColumnsSet.isEmpty()) {
            boolean foundAllColumnsWeNeed = true;
            for (Column c : allColumnsSet) {
                if (c.getTable() != this.getTable()) continue;
                boolean found = false;
                for (Column c2 : this.columns) {
                    if (c != c2) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                foundAllColumnsWeNeed = false;
                break;
            }
            if (foundAllColumnsWeNeed) {
                needsToReadFromScanIndex = false;
            }
        }
        long rc = isScanIndex ? rowsCost + sortingCost + 20L : (needsToReadFromScanIndex ? rowsCost + rowsCost + sortingCost + 20L : rowsCost + sortingCost + (long)this.columns.length);
        return rc;
    }

    private final long getCostRangeIndex_8_7_6(int[] masks, long rowCount, TableFilter[] filters, int filter, SortOrder sortOrder, boolean isScanIndex, HashSet<Column> allColumnsSet) {
        int totalSelectivity = 0;
        long rowsCost = rowCount += 1000L;
        if (masks != null) {
            int len = this.columns.length;
            for (int i = 0; i < len; ++i) {
                long distinctRows;
                Column column = this.columns[i];
                int index = column.getColumnId();
                int mask = masks[index];
                if ((mask & 1) == 1) {
                    if (i == this.columns.length - 1 && this.getIndexType().isUnique()) {
                        rowsCost = 3L;
                        break;
                    }
                    distinctRows = rowCount * (long)(totalSelectivity = 100 - (100 - totalSelectivity) * (100 - column.getSelectivity()) / 100) / 100L;
                    if (distinctRows <= 0L) {
                        distinctRows = 1L;
                    }
                } else {
                    if ((mask & 6) == 6) {
                        rowsCost = 2L + rowCount / 4L;
                        break;
                    }
                    if ((mask & 2) == 2) {
                        rowsCost = 2L + rowCount / 3L;
                        break;
                    }
                    if ((mask & 4) != 4) break;
                    rowsCost = rowCount / 3L;
                    break;
                }
                rowsCost = 2L + Math.max(rowCount / distinctRows, 1L);
            }
        }
        long sortingCost = 0L;
        if (sortOrder != null) {
            sortingCost = 100L + rowCount / 10L;
        }
        if (sortOrder != null && !isScanIndex) {
            boolean sortOrderMatches = true;
            int coveringCount = 0;
            int[] sortTypes = sortOrder.getSortTypes();
            TableFilter tableFilter = filters == null ? null : filters[filter];
            int len = sortTypes.length;
            for (int i = 0; i < len && i < this.indexColumns.length; ++i) {
                Column col = sortOrder.getColumn(i, tableFilter);
                if (col == null) {
                    sortOrderMatches = false;
                    break;
                }
                IndexColumn indexCol = this.indexColumns[i];
                if (!col.equals((Object)indexCol.column)) {
                    sortOrderMatches = false;
                    break;
                }
                int sortType = sortTypes[i];
                if (sortType != indexCol.sortType) {
                    sortOrderMatches = false;
                    break;
                }
                ++coveringCount;
            }
            if (sortOrderMatches) {
                sortingCost = 100 - coveringCount;
            }
        }
        boolean needsToReadFromScanIndex = true;
        if (!isScanIndex && allColumnsSet != null && !allColumnsSet.isEmpty()) {
            boolean foundAllColumnsWeNeed = true;
            for (Column c : allColumnsSet) {
                if (c.getTable() != this.getTable()) continue;
                boolean found = false;
                for (Column c2 : this.columns) {
                    if (c != c2) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                foundAllColumnsWeNeed = false;
                break;
            }
            if (foundAllColumnsWeNeed) {
                needsToReadFromScanIndex = false;
            }
        }
        long rc = isScanIndex ? rowsCost + sortingCost + 20L : (needsToReadFromScanIndex ? rowsCost + rowsCost + sortingCost + 20L : rowsCost + sortingCost + (long)this.columns.length);
        return rc;
    }

    private static interface CostFunction {
        public long getCostRangeIndex(int[] var1, long var2, TableFilter[] var4, int var5, SortOrder var6, boolean var7, HashSet<Column> var8);
    }

    private static enum CostFunctionType {
        LAST,
        COMPATIBLE_8_5_17,
        COMPATIBLE_8_5_13;

    }
}

