/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.h2.opt;

import java.sql.PreparedStatement;
import java.util.ArrayList;
import java.util.List;
import org.apache.ignite.internal.processors.query.h2.sql.GridSqlQueryParser;
import org.h2.command.Prepared;
import org.h2.command.dml.Query;
import org.h2.command.dml.Select;
import org.h2.command.dml.SelectUnion;
import org.h2.table.TableFilter;

public class GridH2StatementCleaner
implements AutoCloseable {
    private final List<TableFilter> filters;

    private GridH2StatementCleaner(List<TableFilter> filters) {
        this.filters = filters;
    }

    public static GridH2StatementCleaner fromPrepared(PreparedStatement stmt) {
        Prepared p = GridSqlQueryParser.prepared(stmt);
        if (!(p instanceof Query)) {
            return null;
        }
        ArrayList<TableFilter> filters = new ArrayList<TableFilter>();
        GridH2StatementCleaner.collectTableFilters((Query)p, filters);
        return new GridH2StatementCleaner(filters);
    }

    private static void collectTableFilters(Query qry, final List<TableFilter> filters) {
        if (qry.isUnion()) {
            SelectUnion union = (SelectUnion)qry;
            GridH2StatementCleaner.collectTableFilters(union.getLeft(), filters);
            GridH2StatementCleaner.collectTableFilters(union.getRight(), filters);
        } else {
            Select select = (Select)qry;
            select.getTopTableFilter().visit(new TableFilter.TableFilterVisitor(){

                public void accept(TableFilter f) {
                    filters.add(f);
                }
            });
        }
    }

    @Override
    public void close() throws Exception {
        for (TableFilter f : this.filters) {
            f.set(null);
        }
    }
}

