/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.h2.opt;

import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.internal.processors.cache.persistence.CacheDataRow;
import org.apache.ignite.internal.processors.query.h2.opt.GridH2Row;
import org.apache.ignite.internal.processors.query.h2.opt.GridH2RowDescriptor;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.SB;
import org.h2.message.DbException;
import org.h2.value.Value;
import org.h2.value.ValueNull;

public class GridH2KeyValueRowOnheap
extends GridH2Row {
    public static final int DEFAULT_COLUMNS_COUNT = 3;
    public static final int KEY_COL = 0;
    public static final int VAL_COL = 1;
    public static final int VER_COL = 2;
    protected final GridH2RowDescriptor desc;
    private Value key;
    private volatile Value val;
    private Value[] valCache;
    private Value ver;

    public GridH2KeyValueRowOnheap(GridH2RowDescriptor desc, CacheDataRow row, int keyType, int valType) throws IgniteCheckedException {
        super(row);
        this.desc = desc;
        this.key = desc.wrap(row.key(), keyType);
        if (row.value() != null) {
            this.val = desc.wrap(row.value(), valType);
        }
        if (row.version() != null) {
            this.ver = desc.wrap(row.version(), 19);
        }
    }

    public int getColumnCount() {
        return 3 + this.desc.fieldsCount();
    }

    public Value getValue(int col) {
        switch (col) {
            case 0: {
                return this.key;
            }
            case 1: {
                return this.val;
            }
            case 2: {
                return this.ver;
            }
        }
        if (this.desc.isKeyAliasColumn(col)) {
            return this.key;
        }
        if (this.desc.isValueAliasColumn(col)) {
            return this.val;
        }
        return this.getValue0(col - 3);
    }

    private Value getValue0(int col) {
        Value v = this.getCached(col);
        if (v != null) {
            return v;
        }
        Object res = this.desc.columnValue(this.key.getObject(), this.val.getObject(), col);
        if (res == null) {
            v = ValueNull.INSTANCE;
        } else {
            try {
                v = this.desc.wrap(res, this.desc.fieldType(col));
            }
            catch (IgniteCheckedException e) {
                throw DbException.convert((Throwable)e);
            }
        }
        this.setCached(col, v);
        return v;
    }

    public void prepareValuesCache() {
        this.valCache = new Value[this.desc.fieldsCount()];
    }

    public void clearValuesCache() {
        this.valCache = null;
    }

    private Value getCached(int colIdx) {
        return this.valCache != null ? this.valCache[colIdx] : null;
    }

    private void setCached(int colIdx, Value val) {
        if (this.valCache != null) {
            this.valCache[colIdx] = val;
        }
    }

    public String toString() {
        SB sb = new SB("Row@");
        sb.a(Integer.toHexString(System.identityHashCode(this)));
        Value v = this.key;
        sb.a("[ key: ").a(v == null ? "nil" : v.getString());
        v = this.val;
        sb.a(", val: ").a(v == null ? "nil" : (S.includeSensitive() ? v.getString() : "Data hidden due to IGNITE_TO_STRING_INCLUDE_SENSITIVE flag."));
        v = this.ver;
        sb.a(", ver: ").a(v == null ? "nil" : v.getString());
        sb.a(" ][ ");
        if (v != null) {
            int cnt = this.getColumnCount();
            for (int i = 3; i < cnt; ++i) {
                v = this.getValue(i);
                if (i != 3) {
                    sb.a(", ");
                }
                if (this.desc.isKeyValueOrVersionColumn(i)) continue;
                sb.a(v == null ? "nil" : (S.includeSensitive() ? v.getString() : "data hidden"));
            }
        }
        sb.a(" ]");
        return sb.toString();
    }

    @Override
    public void setKey(long key) {
        throw new UnsupportedOperationException();
    }

    public void setValue(int idx, Value v) {
        throw new UnsupportedOperationException();
    }

    public int size() throws IgniteCheckedException {
        throw new UnsupportedOperationException();
    }

    public final int hashCode() {
        throw new UnsupportedOperationException();
    }
}

