/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.h2.database;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.IgniteSystemProperties;
import org.apache.ignite.failure.FailureType;
import org.apache.ignite.internal.pagemem.FullPageId;
import org.apache.ignite.internal.pagemem.PageIdUtils;
import org.apache.ignite.internal.pagemem.PageMemory;
import org.apache.ignite.internal.pagemem.wal.IgniteWriteAheadLogManager;
import org.apache.ignite.internal.pagemem.wal.record.PageSnapshot;
import org.apache.ignite.internal.pagemem.wal.record.WALRecord;
import org.apache.ignite.internal.processors.cache.GridCacheContext;
import org.apache.ignite.internal.processors.cache.persistence.tree.BPlusTree;
import org.apache.ignite.internal.processors.cache.persistence.tree.CorruptedTreeException;
import org.apache.ignite.internal.processors.cache.persistence.tree.io.BPlusIO;
import org.apache.ignite.internal.processors.cache.persistence.tree.io.BPlusMetaIO;
import org.apache.ignite.internal.processors.cache.persistence.tree.reuse.ReuseList;
import org.apache.ignite.internal.processors.failure.FailureProcessor;
import org.apache.ignite.internal.processors.query.h2.H2RowCache;
import org.apache.ignite.internal.processors.query.h2.database.H2RowFactory;
import org.apache.ignite.internal.processors.query.h2.database.H2TreeInlineObjectDetector;
import org.apache.ignite.internal.processors.query.h2.database.InlineIndexHelper;
import org.apache.ignite.internal.processors.query.h2.database.io.H2ExtrasInnerIO;
import org.apache.ignite.internal.processors.query.h2.database.io.H2ExtrasLeafIO;
import org.apache.ignite.internal.processors.query.h2.database.io.H2RowLinkIO;
import org.apache.ignite.internal.processors.query.h2.opt.GridH2KeyValueRowOnheap;
import org.apache.ignite.internal.processors.query.h2.opt.GridH2Row;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgnitePredicate;
import org.apache.ignite.lang.IgniteProductVersion;
import org.apache.ignite.spi.indexing.IndexingQueryCacheFilter;
import org.h2.message.DbException;
import org.h2.result.SearchRow;
import org.h2.table.IndexColumn;
import org.h2.value.Value;
import org.jetbrains.annotations.Nullable;

public abstract class H2Tree
extends BPlusTree<SearchRow, GridH2Row> {
    public static final String IGNITE_THROTTLE_INLINE_SIZE_CALCULATION = "IGNITE_THROTTLE_INLINE_SIZE_CALCULATION";
    private final GridCacheContext cctx;
    private final H2RowFactory rowStore;
    private final int inlineSize;
    private final List<InlineIndexHelper> inlineIdxs;
    private final IndexColumn[] cols;
    private final int[] columnIds;
    private final boolean pk;
    private final boolean affinityKey;
    private final IgniteLogger log;
    private final String tblName;
    private final String cacheName;
    private final String idxName;
    private final Comparator<Value> comp = new Comparator<Value>(){

        @Override
        public int compare(Value o1, Value o2) {
            return H2Tree.this.compareValues(o1, o2);
        }
    };
    private final H2RowCache rowCache;
    private final boolean created;
    private final int THROTTLE_INLINE_SIZE_CALCULATION = IgniteSystemProperties.getInteger((String)"IGNITE_THROTTLE_INLINE_SIZE_CALCULATION", (int)1000);
    private final ThreadLocal<Long> inlineSizeCalculationCntr = ThreadLocal.withInitial(() -> 0L);
    private final AtomicInteger maxCalculatedInlineSize = new AtomicInteger();

    public H2Tree(GridCacheContext cctx, String name, String tblName, String cacheName, String idxName, ReuseList reuseList, int grpId, String grpName, PageMemory pageMem, IgniteWriteAheadLogManager wal, AtomicLong globalRmvId, H2RowFactory rowStore, long metaPageId, boolean initNew, IndexColumn[] cols, List<InlineIndexHelper> inlineIdxs, int inlineSize, boolean pk, boolean affinityKey, @Nullable H2RowCache rowCache, @Nullable FailureProcessor failureProcessor, IgniteLogger log) throws IgniteCheckedException {
        super(name, grpId, grpName, pageMem, wal, globalRmvId, metaPageId, reuseList, failureProcessor, null);
        this.cctx = cctx;
        this.log = log;
        this.rowCache = rowCache;
        this.tblName = tblName;
        this.idxName = idxName;
        this.cacheName = cacheName;
        this.rowStore = rowStore;
        this.cols = cols;
        this.pk = pk;
        this.affinityKey = affinityKey;
        this.columnIds = new int[cols.length];
        for (int i = 0; i < cols.length; ++i) {
            this.columnIds[i] = cols[i].column.getColumnId();
        }
        if (!initNew) {
            MetaPageInfo metaInfo = this.getMetaInfo();
            if (metaInfo.useUnwrappedPk()) {
                throw new IgniteCheckedException("Unwrapped PK is not supported by current version");
            }
            if (inlineSize != metaInfo.inlineSize()) {
                log.warning("New inline size for idx=" + idxName + " will not be applied");
            }
            this.inlineSize = inlineSize = metaInfo.inlineSize();
            this.setIos(H2ExtrasInnerIO.getVersions(inlineSize), H2ExtrasLeafIO.getVersions(inlineSize));
            boolean inlineObjSupported = inlineSize > 0 && this.inlineObjectSupported(metaInfo, inlineIdxs);
            List<InlineIndexHelper> list = this.inlineIdxs = inlineObjSupported ? inlineIdxs : inlineIdxs.stream().filter(ih -> ih.type() != 19).collect(Collectors.toList());
            if (!metaInfo.flagsSupported()) {
                this.upgradeMetaPage(inlineObjSupported);
            }
        } else {
            this.inlineSize = inlineSize;
            this.inlineIdxs = inlineIdxs;
            this.setIos(H2ExtrasInnerIO.getVersions(inlineSize), H2ExtrasLeafIO.getVersions(inlineSize));
            this.initTree(initNew, inlineSize);
        }
        this.created = initNew;
    }

    private boolean inlineObjectSupported(MetaPageInfo metaInfo, List<InlineIndexHelper> inlineIdxs) {
        if (metaInfo.flagsSupported()) {
            return metaInfo.inlineObjectSupported();
        }
        try {
            if (H2TreeInlineObjectDetector.objectMayBeInlined(this.inlineSize, inlineIdxs)) {
                H2TreeInlineObjectDetector inlineObjDetector = new H2TreeInlineObjectDetector(this.inlineSize, inlineIdxs, this.tblName, this.idxName, this.log);
                this.findFirst(inlineObjDetector);
                return inlineObjDetector.inlineObjectSupported();
            }
            return false;
        }
        catch (IgniteCheckedException e) {
            throw new IgniteException("Unexpected exception on detect inline object", (Throwable)e);
        }
    }

    public GridH2Row createRowFromLink(long link) throws IgniteCheckedException {
        if (this.rowCache != null) {
            GridH2Row row = this.rowCache.get(link);
            if (row == null && (row = this.rowStore.getRow(link)) instanceof GridH2KeyValueRowOnheap) {
                this.rowCache.put((GridH2KeyValueRowOnheap)row);
            }
            return row;
        }
        return this.rowStore.getRow(link);
    }

    protected GridH2Row getRow(BPlusIO<SearchRow> io, long pageAddr, int idx, Object filter) throws IgniteCheckedException {
        long link;
        int part;
        IndexingQueryCacheFilter filter0;
        if (filter != null && !(filter0 = (IndexingQueryCacheFilter)filter).applyPartition(part = PageIdUtils.partId((long)PageIdUtils.pageId((long)(link = ((H2RowLinkIO)io).getLink(pageAddr, idx)))))) {
            return null;
        }
        return (GridH2Row)io.getLookupRow((BPlusTree)this, pageAddr, idx);
    }

    public int inlineSize() {
        return this.inlineSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MetaPageInfo getMetaInfo() throws IgniteCheckedException {
        long metaPage = this.acquirePage(this.metaPageId);
        try {
            MetaPageInfo metaPageInfo;
            long pageAddr = this.readLock(this.metaPageId, metaPage);
            assert (pageAddr != 0L) : "Failed to read lock meta page [metaPageId=" + U.hexLong((long)this.metaPageId) + ']';
            try {
                BPlusMetaIO io = (BPlusMetaIO)BPlusMetaIO.VERSIONS.forPage(pageAddr);
                metaPageInfo = new MetaPageInfo(io, pageAddr);
            }
            catch (Throwable throwable) {
                this.readUnlock(this.metaPageId, metaPage, pageAddr);
                throw throwable;
            }
            this.readUnlock(this.metaPageId, metaPage, pageAddr);
            return metaPageInfo;
        }
        finally {
            this.releasePage(this.metaPageId, metaPage);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void upgradeMetaPage(boolean inlineObjSupported) throws IgniteCheckedException {
        long metaPage = this.acquirePage(this.metaPageId);
        try {
            long pageAddr = this.writeLock(this.metaPageId, metaPage);
            assert (pageAddr != 0L) : "Failed to read lock meta page [metaPageId=" + U.hexLong((long)this.metaPageId) + ']';
            try {
                BPlusMetaIO.upgradePageVersion((long)pageAddr, (boolean)inlineObjSupported, (boolean)false, (int)this.pageSize());
                if (this.wal != null) {
                    this.wal.log((WALRecord)new PageSnapshot(new FullPageId(this.metaPageId, this.grpId), pageAddr, this.pageMem.pageSize()));
                }
            }
            finally {
                this.writeUnlock(this.metaPageId, metaPage, pageAddr, true);
            }
        }
        finally {
            this.releasePage(this.metaPageId, metaPage);
        }
    }

    protected int compare(BPlusIO<SearchRow> io, long pageAddr, int idx, SearchRow row) throws IgniteCheckedException {
        try {
            if (this.inlineSize() == 0) {
                return this.compareRows((SearchRow)this.getRow(io, pageAddr, idx), row);
            }
            int off = io.offset(idx);
            int fieldOff = 0;
            int lastIdxUsed = 0;
            for (int i = 0; i < this.inlineIdxs.size(); ++i) {
                InlineIndexHelper inlineIdx = this.inlineIdxs.get(i);
                Value v2 = row.getValue(inlineIdx.columnIndex());
                if (v2 == null) {
                    return 0;
                }
                int c = inlineIdx.compare(pageAddr, off + fieldOff, this.inlineSize() - fieldOff, v2, this.comp);
                if (c == -2) break;
                ++lastIdxUsed;
                if (c != 0) {
                    return c;
                }
                if ((fieldOff += inlineIdx.fullSize(pageAddr, off + fieldOff)) > this.inlineSize()) break;
            }
            if (lastIdxUsed == this.cols.length) {
                return 0;
            }
            this.inlineSizeRecomendation(row);
            SearchRow rowData = (SearchRow)this.getRow(io, pageAddr, idx);
            int len = this.cols.length;
            for (int i = lastIdxUsed; i < len; ++i) {
                IndexColumn col = this.cols[i];
                int idx0 = col.column.getColumnId();
                Value v2 = row.getValue(idx0);
                if (v2 == null) {
                    return 0;
                }
                Value v1 = rowData.getValue(idx0);
                int c = this.compareValues(v1, v2);
                if (c == 0) continue;
                return InlineIndexHelper.fixSort(c, col.sortType);
            }
            return 0;
        }
        catch (DbException ex) {
            throw new IgniteCheckedException("Rows cannot be compared", (Throwable)ex);
        }
    }

    private void inlineSizeRecomendation(SearchRow row) {
        boolean throttle;
        if (!(row instanceof GridH2KeyValueRowOnheap)) {
            return;
        }
        Long invokeCnt = this.inlineSizeCalculationCntr.get();
        invokeCnt = invokeCnt + 1L;
        this.inlineSizeCalculationCntr.set(invokeCnt);
        boolean bl = throttle = invokeCnt % (long)this.THROTTLE_INLINE_SIZE_CALCULATION != 0L;
        if (throttle) {
            return;
        }
        int newSize = 0;
        ArrayList<String> colNames = new ArrayList<String>();
        ArrayList<Integer> colTypes = new ArrayList<Integer>();
        Iterator<InlineIndexHelper> iterator = this.inlineIdxs.iterator();
        while (iterator.hasNext()) {
            InlineIndexHelper index;
            InlineIndexHelper idx = index = iterator.next();
            newSize += idx.inlineSizeOf(row.getValue(idx.columnIndex()));
            colNames.add(index.colName());
            colTypes.add(row.getValue(idx.columnIndex()).getType());
        }
        if (newSize > this.inlineSize()) {
            int oldSize;
            do {
                if ((oldSize = this.maxCalculatedInlineSize.get()) < newSize) continue;
                return;
            } while (!this.maxCalculatedInlineSize.compareAndSet(oldSize, newSize));
            String cols = colNames.stream().collect(Collectors.joining(", ", "[", "]"));
            String idxType = this.pk ? "PRIMARY KEY" : (this.affinityKey ? "AFFINITY KEY (implicit)" : "SECONDARY");
            String recommendation = this.pk || this.affinityKey ? "set system property IGNITE_MAX_INDEX_PAYLOAD_SIZE with recommended size (be aware it will be used by default for all indexes without explicit inline size)" : "use INLINE_SIZE option for CREATE INDEX command, QuerySqlField.inlineSize for annotated classes, or QueryIndex.inlineSize for explicit QueryEntity configuration";
            String warn = "Indexed columns of a row cannot be fully inlined into index what may lead to slowdown due to additional data page reads, increase index inline size if needed (" + recommendation + ") [cacheName=" + this.cacheName + ", tableName=" + this.tblName + ", idxName=" + this.idxName + ", idxCols=" + cols + ", idxTypes=" + colTypes + ", curSize=" + this.inlineSize() + ", idxType=" + idxType + ", recommendedInlineSize=" + newSize + "]";
            U.warn((IgniteLogger)this.log, (Object)warn);
        }
    }

    public int compareRows(SearchRow r1, SearchRow r2) {
        if (r1 == r2) {
            return 0;
        }
        for (IndexColumn idxCol : this.cols) {
            int idx = idxCol.column.getColumnId();
            Value v1 = r1.getValue(idx);
            Value v2 = r2.getValue(idx);
            if (v1 == null || v2 == null) {
                return 0;
            }
            int c = this.compareValues(v1, v2);
            if (c == 0) continue;
            return InlineIndexHelper.fixSort(c, idxCol.sortType);
        }
        return 0;
    }

    public List<InlineIndexHelper> inlineIndexes() {
        return this.inlineIdxs;
    }

    public void refreshColumnIds(List<InlineIndexHelper> idxs) {
        assert (this.inlineIdxs.size() <= idxs.size());
        for (int i = 0; i < this.inlineIdxs.size(); ++i) {
            int idx = i;
            this.inlineIdxs.set(idx, (InlineIndexHelper)F.find(idxs, null, (IgnitePredicate[])new IgnitePredicate[]{(IgnitePredicate & Serializable)ih -> ih.colName().equals(this.inlineIdxs.get(idx).colName())}));
            assert (this.inlineIdxs.get(idx) != null);
        }
    }

    public abstract int compareValues(Value var1, Value var2);

    public boolean created() {
        return this.created;
    }

    public String toString() {
        return S.toString(H2Tree.class, (Object)((Object)this), (String)"super", (Object)super.toString());
    }

    protected CorruptedTreeException corruptedTreeException(String msg, Throwable cause, int grpId, long ... pageIds) {
        CorruptedTreeException e = new CorruptedTreeException(msg, cause, grpId, this.grpName, this.cacheName, this.idxName, pageIds);
        this.processFailure(FailureType.CRITICAL_ERROR, (Throwable)e);
        return e;
    }

    protected void temporaryReleaseLock() {
        this.cctx.kernalContext().cache().context().database().checkpointReadUnlock();
        this.cctx.kernalContext().cache().context().database().checkpointReadLock();
    }

    protected long maxLockHoldTime() {
        long sysWorkerBlockedTimeout = this.cctx.kernalContext().workersRegistry().getSystemWorkerBlockedTimeout();
        return sysWorkerBlockedTimeout == 0L ? Long.MAX_VALUE : sysWorkerBlockedTimeout / 10L;
    }

    private static class MetaPageInfo {
        int inlineSize;
        boolean useUnwrappedPk;
        boolean flagsSupported;
        Boolean inlineObjectSupported;
        IgniteProductVersion createdVer;

        public MetaPageInfo(BPlusMetaIO io, long pageAddr) {
            this.inlineSize = io.getInlineSize(pageAddr);
            this.useUnwrappedPk = io.unwrappedPk(pageAddr);
            this.flagsSupported = io.supportFlags();
            if (this.flagsSupported) {
                this.inlineObjectSupported = io.inlineObjectSupported(pageAddr);
            }
            this.createdVer = io.createdVersion(pageAddr);
        }

        public int inlineSize() {
            return this.inlineSize;
        }

        public boolean useUnwrappedPk() {
            return this.useUnwrappedPk;
        }

        public boolean flagsSupported() {
            return this.flagsSupported;
        }

        public boolean inlineObjectSupported() {
            return this.inlineObjectSupported;
        }
    }
}

