/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.h2.database;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.internal.processors.cache.GridCacheContext;
import org.apache.ignite.internal.processors.cache.IgniteCacheOffheapManager;
import org.apache.ignite.internal.processors.cache.KeyCacheObject;
import org.apache.ignite.internal.processors.cache.persistence.CacheDataRow;
import org.apache.ignite.internal.processors.query.h2.opt.GridH2IndexBase;
import org.apache.ignite.internal.processors.query.h2.opt.GridH2Row;
import org.apache.ignite.internal.processors.query.h2.opt.GridH2Table;
import org.apache.ignite.internal.util.lang.GridCursor;
import org.apache.ignite.spi.indexing.IndexingQueryCacheFilter;
import org.apache.ignite.spi.indexing.IndexingQueryFilter;
import org.h2.engine.Session;
import org.h2.index.Cursor;
import org.h2.index.IndexType;
import org.h2.message.DbException;
import org.h2.result.Row;
import org.h2.result.SearchRow;
import org.h2.result.SortOrder;
import org.h2.table.Column;
import org.h2.table.IndexColumn;
import org.h2.table.Table;
import org.h2.table.TableFilter;

public class H2PkHashIndex
extends GridH2IndexBase {
    private final GridH2Table tbl;
    private final GridCacheContext cctx;

    public H2PkHashIndex(GridCacheContext<?, ?> cctx, GridH2Table tbl, String name, List<IndexColumn> colsList) {
        super(tbl);
        IndexColumn[] cols = colsList.toArray(new IndexColumn[colsList.size()]);
        IndexColumn.mapColumns((IndexColumn[])cols, (Table)tbl);
        this.initBaseIndex((Table)tbl, 0, name, cols, IndexType.createPrimaryKey((boolean)false, (boolean)true));
        this.tbl = tbl;
        this.cctx = cctx;
    }

    @Override
    protected int segmentsCount() {
        return 1;
    }

    public Cursor find(Session ses, SearchRow lower, SearchRow upper) {
        IndexingQueryFilter f = H2PkHashIndex.threadLocalFilter();
        IndexingQueryCacheFilter p = null;
        if (f != null) {
            String cacheName = this.getTable().cacheName();
            p = f.forCache(cacheName);
        }
        KeyCacheObject lowerObj = null;
        KeyCacheObject upperObj = null;
        if (lower != null) {
            lowerObj = this.cctx.toCacheKeyObject(lower.getValue(0).getObject());
        }
        if (upper != null) {
            upperObj = this.cctx.toCacheKeyObject(upper.getValue(0).getObject());
        }
        try {
            ArrayList<GridCursor> cursors = new ArrayList<GridCursor>();
            for (IgniteCacheOffheapManager.CacheDataStore store : this.cctx.offheap().cacheDataStores()) {
                cursors.add(store.cursor(this.cctx.cacheId(), lowerObj, upperObj));
            }
            return new H2Cursor(new CompositeGridCursor(cursors.iterator()), p);
        }
        catch (IgniteCheckedException e) {
            throw DbException.convert((Throwable)e);
        }
    }

    public boolean canScan() {
        return false;
    }

    @Override
    public GridH2Row put(GridH2Row row) {
        assert (false);
        throw DbException.getUnsupportedException((String)"put");
    }

    @Override
    public boolean putx(GridH2Row row) {
        assert (false);
        throw DbException.getUnsupportedException((String)"putx");
    }

    @Override
    public GridH2Row remove(SearchRow row) {
        assert (false);
        throw DbException.getUnsupportedException((String)"remove");
    }

    @Override
    public boolean removex(SearchRow row) {
        assert (false);
        throw DbException.getUnsupportedException((String)"removex");
    }

    public double getCost(Session ses, int[] masks, TableFilter[] filters, int filter, SortOrder sortOrder, HashSet<Column> allColumnsSet) {
        return Double.MAX_VALUE;
    }

    public long getRowCount(Session ses) {
        Cursor cursor = this.find(ses, null, null);
        long res = 0L;
        while (cursor.next()) {
            ++res;
        }
        return res;
    }

    public long getRowCountApproximation() {
        return 10000L;
    }

    public boolean canGetFirstOrLast() {
        return false;
    }

    public Cursor findFirstOrLast(Session ses, boolean b) {
        throw new UnsupportedOperationException();
    }

    private static class CompositeGridCursor<T>
    implements GridCursor<T> {
        private final Iterator<GridCursor<? extends T>> iter;
        private GridCursor<? extends T> curr;

        public CompositeGridCursor(Iterator<GridCursor<? extends T>> iter) {
            this.iter = iter;
            if (iter.hasNext()) {
                this.curr = iter.next();
            }
        }

        public boolean next() throws IgniteCheckedException {
            if (this.curr.next()) {
                return true;
            }
            while (this.iter.hasNext()) {
                this.curr = this.iter.next();
                if (!this.curr.next()) continue;
                return true;
            }
            return false;
        }

        public T get() throws IgniteCheckedException {
            return (T)this.curr.get();
        }

        public void close() throws Exception {
            if (this.curr != null) {
                this.curr.close();
            }
        }
    }

    private class H2Cursor
    implements Cursor {
        final GridCursor<? extends CacheDataRow> cursor;
        final IndexingQueryCacheFilter filter;

        private H2Cursor(GridCursor<? extends CacheDataRow> cursor, IndexingQueryCacheFilter filter) {
            assert (cursor != null);
            this.cursor = cursor;
            this.filter = filter;
        }

        public Row get() {
            try {
                CacheDataRow dataRow = (CacheDataRow)this.cursor.get();
                return H2PkHashIndex.this.tbl.rowDescriptor().createRow(dataRow);
            }
            catch (IgniteCheckedException e) {
                throw DbException.convert((Throwable)e);
            }
        }

        public SearchRow getSearchRow() {
            return this.get();
        }

        public boolean next() {
            try {
                while (this.cursor.next()) {
                    if (this.filter == null) {
                        return true;
                    }
                    CacheDataRow dataRow = (CacheDataRow)this.cursor.get();
                    if (!this.filter.applyPartition(dataRow.partition())) continue;
                    return true;
                }
                return false;
            }
            catch (IgniteCheckedException e) {
                throw DbException.convert((Throwable)e);
            }
        }

        public boolean previous() {
            throw DbException.getUnsupportedException((String)"previous");
        }
    }
}

