/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.h2;

import java.lang.reflect.Constructor;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.internal.processors.cache.QueryCursorImpl;
import org.apache.ignite.internal.processors.query.GridQueryFieldMetadata;
import org.apache.ignite.internal.processors.query.IgniteSQLException;
import org.apache.ignite.internal.processors.query.QueryUtils;
import org.apache.ignite.internal.processors.query.h2.H2SqlFieldMetadata;
import org.apache.ignite.internal.processors.query.h2.IgniteH2Indexing;
import org.apache.ignite.internal.processors.query.h2.opt.GridH2IndexBase;
import org.apache.ignite.internal.processors.query.h2.opt.GridH2RowDescriptor;
import org.apache.ignite.internal.processors.query.h2.opt.GridH2Table;
import org.apache.ignite.internal.util.GridStringBuilder;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.SB;
import org.h2.engine.Session;
import org.h2.jdbc.JdbcConnection;
import org.h2.table.IndexColumn;
import org.h2.util.JdbcUtils;
import org.h2.util.Utils;
import org.h2.value.Value;
import org.jetbrains.annotations.Nullable;

public class H2Utils {
    public static final int STRING_DEFAULT_PRECISION = Integer.MAX_VALUE;
    public static final int DECIMAL_DEFAULT_PRECISION = 65535;
    public static final int DECIMAL_DEFAULT_SCALE = Short.MAX_VALUE;
    private static final String SPATIAL_IDX_CLS = "org.apache.ignite.internal.processors.query.h2.opt.GridH2SpatialIndex";
    private static final char ESC_CH = '\"';

    public static boolean equals(IndexColumn c1, IndexColumn c2) {
        return c1.column.getColumnId() == c2.column.getColumnId();
    }

    public static boolean containsColumn(List<IndexColumn> cols, IndexColumn col) {
        for (int i = cols.size() - 1; i >= 0; --i) {
            if (!H2Utils.equals(cols.get(i), col)) continue;
            return true;
        }
        return false;
    }

    public static boolean containsKeyColumn(GridH2RowDescriptor desc, List<IndexColumn> cols) {
        for (int i = cols.size() - 1; i >= 0; --i) {
            if (!desc.isKeyColumn(cols.get((int)i).column.getColumnId())) continue;
            return true;
        }
        return false;
    }

    public static String indexCreateSql(String fullTblName, GridH2IndexBase h2Idx, boolean ifNotExists) {
        boolean spatial = F.eq((Object)SPATIAL_IDX_CLS, (Object)((Object)((Object)h2Idx)).getClass().getName());
        GridStringBuilder sb = new SB("CREATE ").a(spatial ? "SPATIAL " : "").a("INDEX ").a(ifNotExists ? "IF NOT EXISTS " : "").a(H2Utils.withQuotes(h2Idx.getName())).a(" ON ").a(fullTblName).a(" (");
        sb.a(H2Utils.indexColumnsSql(h2Idx.getIndexColumns()));
        sb.a(')');
        return sb.toString();
    }

    public static String indexColumnsSql(IndexColumn[] idxCols) {
        SB sb = new SB();
        boolean first = true;
        for (IndexColumn col : idxCols) {
            if (first) {
                first = false;
            } else {
                sb.a(", ");
            }
            sb.a(H2Utils.withQuotes(col.columnName)).a(" ").a(col.sortType == 0 ? "ASC" : "DESC");
        }
        return sb.toString();
    }

    public static String indexDropSql(String schemaName, String idxName, boolean ifExists) {
        return "DROP INDEX " + (ifExists ? "IF EXISTS " : "") + H2Utils.withQuotes(schemaName) + '.' + H2Utils.withQuotes(idxName);
    }

    public static List<IndexColumn> treeIndexColumns(GridH2RowDescriptor desc, List<IndexColumn> cols, IndexColumn keyCol, IndexColumn affCol) {
        assert (keyCol != null);
        if (!H2Utils.containsKeyColumn(desc, cols)) {
            cols.add(keyCol);
        }
        if (affCol != null && !H2Utils.containsColumn(cols, affCol)) {
            cols.add(affCol);
        }
        return cols;
    }

    public static GridH2IndexBase createSpatialIndex(GridH2Table tbl, String idxName, IndexColumn[] cols) {
        try {
            Class<?> cls = Class.forName(SPATIAL_IDX_CLS);
            Constructor<?> ctor = cls.getConstructor(GridH2Table.class, String.class, Integer.TYPE, IndexColumn[].class);
            if (!ctor.isAccessible()) {
                ctor.setAccessible(true);
            }
            int segments = tbl.rowDescriptor().context().config().getQueryParallelism();
            return (GridH2IndexBase)((Object)ctor.newInstance(new Object[]{tbl, idxName, segments, cols}));
        }
        catch (Exception e) {
            throw new IgniteException("Failed to instantiate: org.apache.ignite.internal.processors.query.h2.opt.GridH2SpatialIndex", (Throwable)e);
        }
    }

    public static String withQuotes(String str) {
        return '\"' + str + '\"';
    }

    public static List<GridQueryFieldMetadata> meta(ResultSetMetaData rsMeta) throws SQLException {
        ArrayList<GridQueryFieldMetadata> meta = new ArrayList<GridQueryFieldMetadata>(rsMeta.getColumnCount());
        for (int i = 1; i <= rsMeta.getColumnCount(); ++i) {
            String schemaName = rsMeta.getSchemaName(i);
            String typeName = rsMeta.getTableName(i);
            String name = rsMeta.getColumnLabel(i);
            String type = rsMeta.getColumnClassName(i);
            if (type == null) {
                type = Void.class.getName();
            }
            meta.add(new H2SqlFieldMetadata(schemaName, typeName, name, type));
        }
        return meta;
    }

    public static Session session(Connection c) {
        return (Session)((JdbcConnection)c).getSession();
    }

    public static void setupConnection(Connection conn, boolean distributedJoins, boolean enforceJoinOrder) {
        H2Utils.setupConnection(conn, distributedJoins, enforceJoinOrder, false);
    }

    public static void setupConnection(Connection conn, boolean distributedJoins, boolean enforceJoinOrder, boolean lazy) {
        Session s = H2Utils.session(conn);
        s.setForceJoinOrder(enforceJoinOrder);
        s.setJoinBatchEnabled(distributedJoins);
        s.setLazyQueryExecution(lazy);
    }

    public static Object convert(Object val, GridH2RowDescriptor desc, int type) throws IgniteCheckedException {
        if (val == null) {
            return null;
        }
        int objType = H2Utils.getTypeFromClass(val.getClass());
        if (objType == type) {
            return val;
        }
        Value h2Val = desc.wrap(val, objType);
        return h2Val.convertTo(type).getObject();
    }

    private H2Utils() {
    }

    public static QueryCursorImpl<List<?>> zeroCursor() {
        QueryCursorImpl resCur = new QueryCursorImpl(Collections.singletonList(Collections.singletonList(0L)), null, false);
        resCur.fieldsMeta(IgniteH2Indexing.UPDATE_RESULT_META);
        return resCur;
    }

    public static int getTypeFromClass(Class<?> x) {
        if (x == null || Void.TYPE == x) {
            return 0;
        }
        if (String.class == (x = Utils.getNonPrimitiveClass(x))) {
            return 13;
        }
        if (Integer.class == x) {
            return 4;
        }
        if (Long.class == x) {
            return 5;
        }
        if (Boolean.class == x) {
            return 1;
        }
        if (Double.class == x) {
            return 7;
        }
        if (Byte.class == x) {
            return 2;
        }
        if (Short.class == x) {
            return 3;
        }
        if (Character.class == x) {
            throw new IgniteSQLException("Character type is not supported.", 1002);
        }
        if (Float.class == x) {
            return 8;
        }
        if (byte[].class == x) {
            return 12;
        }
        if (UUID.class == x) {
            return 20;
        }
        if (Void.class == x) {
            return 0;
        }
        if (BigDecimal.class.isAssignableFrom(x)) {
            return 6;
        }
        if (Date.class.isAssignableFrom(x)) {
            return 10;
        }
        if (Time.class.isAssignableFrom(x)) {
            return 9;
        }
        if (Timestamp.class.isAssignableFrom(x)) {
            return 11;
        }
        if (java.util.Date.class.isAssignableFrom(x)) {
            return 11;
        }
        if (Object[].class.isAssignableFrom(x)) {
            return 17;
        }
        if (QueryUtils.isGeometryClass((Class)x)) {
            return 22;
        }
        if (JdbcUtils.customDataTypesHandler != null) {
            return JdbcUtils.customDataTypesHandler.getTypeIdFromClass(x);
        }
        return 19;
    }

    public static void bindParameters(PreparedStatement stmt, @Nullable Collection<Object> params) throws IgniteCheckedException {
        if (!F.isEmpty(params)) {
            int idx = 1;
            for (Object arg : params) {
                H2Utils.bindObject(stmt, idx++, arg);
            }
        }
    }

    public static void bindObject(PreparedStatement stmt, int idx, @Nullable Object obj) throws IgniteCheckedException {
        try {
            if (obj == null) {
                stmt.setNull(idx, 12);
            } else if (obj instanceof BigInteger) {
                stmt.setObject(idx, obj, 2000);
            } else if (obj instanceof BigDecimal) {
                stmt.setObject(idx, obj, 3);
            } else if (obj.getClass() == Instant.class) {
                stmt.setObject(idx, obj, 2000);
            } else {
                stmt.setObject(idx, obj);
            }
        }
        catch (SQLException e) {
            throw new IgniteCheckedException("Failed to bind parameter [idx=" + idx + ", obj=" + obj + ", stmt=" + stmt + ']', (Throwable)e);
        }
    }
}

