/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.h2;

import java.sql.PreparedStatement;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.ignite.cache.query.SqlFieldsQuery;
import org.apache.ignite.internal.processors.cache.query.SqlFieldsQueryEx;
import org.apache.ignite.internal.processors.query.h2.H2CachedStatementKey;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class H2StatementCache {
    private volatile long lastUsage;
    private final LinkedHashMap<H2CachedStatementKey, PreparedStatement> lruStmtCache;

    H2StatementCache(final int size) {
        this.lruStmtCache = new LinkedHashMap<H2CachedStatementKey, PreparedStatement>(size, 0.75f, true){

            @Override
            protected boolean removeEldestEntry(Map.Entry<H2CachedStatementKey, PreparedStatement> eldest) {
                if (this.size() <= size) {
                    return false;
                }
                U.closeQuiet((AutoCloseable)eldest.getValue());
                return true;
            }
        };
    }

    void put(H2CachedStatementKey key, @NotNull PreparedStatement stmt) {
        this.lruStmtCache.put(key, stmt);
    }

    @Nullable
    PreparedStatement get(H2CachedStatementKey key) {
        return this.lruStmtCache.get(key);
    }

    long lastUsage() {
        return this.lastUsage;
    }

    void updateLastUsage() {
        this.lastUsage = U.currentTimeMillis();
    }

    void remove(String schemaName, String sql, byte qryFlags) {
        this.lruStmtCache.remove(new H2CachedStatementKey(schemaName, sql, qryFlags));
    }

    int size() {
        return this.lruStmtCache.size();
    }

    public static byte queryFlags(SqlFieldsQuery qry) {
        return qry == null ? (byte)0 : (byte)((qry.isDistributedJoins() ? 1 : 0) + (qry.isEnforceJoinOrder() ? 2 : 0) + (qry.isLocal() ? 4 : 0) + (qry.getClass() == SqlFieldsQueryEx.class && ((SqlFieldsQueryEx)qry).isSkipReducerOnUpdate() ? 8 : 0));
    }

    public static byte queryFlags(boolean distributedJoins, boolean enforceJoinOrder, boolean distributed) {
        return (byte)((distributedJoins ? 1 : 0) + (enforceJoinOrder ? 2 : 0) + (distributed ? 4 : 0));
    }
}

