/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.h2;

import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.internal.processors.query.h2.H2QueryInfo;
import org.apache.ignite.internal.processors.query.h2.H2ResultSetIterator;
import org.apache.ignite.internal.processors.query.h2.IgniteH2Indexing;
import org.apache.ignite.internal.processors.query.h2.ThreadLocalObjectPool;
import org.apache.ignite.internal.processors.query.h2.opt.GridH2QueryContext;

public class H2FieldsIterator
extends H2ResultSetIterator<List<?>> {
    private static final long serialVersionUID = 0L;
    private ThreadLocalObjectPool.Reusable detachedConn;
    private final boolean lazy;

    public H2FieldsIterator(ResultSet data, ThreadLocalObjectPool.Reusable detachedConn, IgniteLogger log, IgniteH2Indexing h2, H2QueryInfo qryInfo, boolean lazy, int pageSize, GridH2QueryContext qctx) throws IgniteCheckedException {
        super(data, log, h2, qryInfo, lazy, pageSize, qctx);
        this.detachedConn = detachedConn;
        this.lazy = qryInfo.lazy();
    }

    @Override
    protected List<?> createRow() {
        ArrayList res = new ArrayList(this.row.length);
        Collections.addAll(res, this.row);
        return res;
    }

    @Override
    public void onClose() throws IgniteCheckedException {
        try {
            super.onClose();
        }
        finally {
            GridH2QueryContext qctx = GridH2QueryContext.get();
            if (qctx != null) {
                qctx.closeResources();
            }
            if (this.lazy && GridH2QueryContext.get() != null) {
                GridH2QueryContext.clearThreadLocal();
            }
            if (this.detachedConn != null) {
                this.detachedConn.recycle();
                this.detachedConn = null;
            }
        }
    }
}

