/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.h2;

import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.IgniteSystemProperties;
import org.apache.ignite.internal.processors.query.h2.IgniteH2Indexing;
import org.h2.expression.Function;

public class FunctionsManager {
    public static final HashSet<String> DFLT_DISABLED_FUNCS = (HashSet)Arrays.stream(new String[]{"FILE_READ", "FILE_WRITE", "CSVWRITE", "CSVREAD", "MEMORY_FREE", "MEMORY_USED", "LOCK_MODE", "LINK_SCHEMA", "SESSION_ID", "CANCEL_SESSION"}).collect(Collectors.toSet());
    private static HashMap<String, Object> origFuncs;
    private static HashMap<String, Object> funcs;
    private final IgniteLogger log;

    public FunctionsManager(IgniteH2Indexing idx) {
        assert (Objects.nonNull(funcs));
        assert (Objects.nonNull(origFuncs));
        this.log = idx.kernalContext().log(FunctionsManager.class);
        String strDisabledFuncs = IgniteSystemProperties.getString((String)"IGNITE_SQL_DISABLED_FUNCTIONS");
        if (strDisabledFuncs == null) {
            this.updateDisabledFunctions(DFLT_DISABLED_FUNCS);
        } else {
            HashSet funcNames = (HashSet)Arrays.stream(strDisabledFuncs.split("\\W+")).collect(Collectors.toSet());
            this.updateDisabledFunctions(funcNames);
        }
    }

    public void updateDisabledFunctions(HashSet<String> funcsNames) {
        if (funcsNames != null) {
            FunctionsManager.removeFunctions(funcsNames);
        } else {
            FunctionsManager.removeFunctions(DFLT_DISABLED_FUNCS);
        }
    }

    private static void removeFunctions(Set<String> funcNames) {
        funcs.putAll(origFuncs);
        funcs.keySet().removeAll(funcNames);
    }

    static {
        try {
            Field fldFUNCTIONS = Function.class.getDeclaredField("FUNCTIONS");
            fldFUNCTIONS.setAccessible(true);
            funcs = (HashMap)fldFUNCTIONS.get(Class.class);
            origFuncs = new HashMap<String, Object>(funcs);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            e.printStackTrace();
        }
    }
}

