/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.h2;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.processors.cache.GridCacheContext;
import org.apache.ignite.internal.processors.cache.persistence.metastorage.pendingtask.DurableBackgroundTask;
import org.apache.ignite.internal.processors.cache.persistence.tree.BPlusTree;
import org.apache.ignite.internal.processors.query.h2.database.H2Tree;
import org.apache.ignite.internal.util.typedef.internal.CU;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.logger.NullLogger;
import org.h2.table.IndexColumn;
import org.h2.value.Value;

public class DurableBackgroundCleanupIndexTreeTask
implements DurableBackgroundTask {
    private static final long serialVersionUID = 0L;
    private List<Long> rootPages;
    private transient List<H2Tree> trees;
    private String cacheGrpName;
    private String cacheName;
    private String schemaName;
    private String idxName;
    private String id;

    public DurableBackgroundCleanupIndexTreeTask(List<Long> rootPages, List<H2Tree> trees, String cacheGrpName, String cacheName, String schemaName, String idxName) {
        this.rootPages = rootPages;
        this.trees = trees;
        this.cacheGrpName = cacheGrpName;
        this.cacheName = cacheName;
        this.schemaName = schemaName;
        this.idxName = idxName;
        this.id = UUID.randomUUID().toString();
    }

    public String shortName() {
        return "DROP_SQL_INDEX-" + this.schemaName + "." + this.idxName + "-" + this.id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(GridKernalContext ctx) {
        List<H2Tree> trees0 = this.trees;
        if (trees0 == null) {
            trees0 = new ArrayList<H2Tree>(this.rootPages.size());
            GridCacheContext cctx = ctx.cache().context().cacheContext(CU.cacheId((String)this.cacheName));
            for (int i = 0; i < this.rootPages.size(); ++i) {
                Long rootPage = this.rootPages.get(i);
                assert (rootPage != null);
                try {
                    String treeName = "deletedTree_" + i + "_" + this.shortName();
                    H2Tree tree = new H2Tree(cctx, treeName, null, this.cacheName, this.idxName, cctx.offheap().reuseListForIndex(treeName), CU.cacheGroupId((String)this.cacheName, (String)this.cacheGrpName), this.cacheGrpName, cctx.dataRegion().pageMemory(), ctx.cache().context().wal(), (AtomicLong)cctx.offheap().globalRemoveId(), null, rootPage, false, new IndexColumn[0], new ArrayList(), 0, false, false, null, ctx.failure(), (IgniteLogger)new NullLogger()){

                        @Override
                        public int compareValues(Value v1, Value v2) {
                            return 0;
                        }
                    };
                    trees0.add(tree);
                    continue;
                }
                catch (IgniteCheckedException e) {
                    throw new IgniteException((Throwable)e);
                }
            }
        }
        ctx.cache().context().database().checkpointReadLock();
        try {
            for (int i = 0; i < trees0.size(); ++i) {
                BPlusTree tree = trees0.get(i);
                try {
                    tree.destroy(null, true);
                    continue;
                }
                catch (IgniteCheckedException e) {
                    throw new IgniteException((Throwable)e);
                }
            }
        }
        finally {
            ctx.cache().context().database().checkpointReadUnlock();
        }
    }

    public void onCancel() {
        this.trees = null;
    }

    public String toString() {
        return S.toString(DurableBackgroundCleanupIndexTreeTask.class, (Object)this);
    }
}

