/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.h2.twostep;

import java.sql.Connection;
import java.sql.ResultSet;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.cache.CacheException;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.cache.query.QueryCancelledException;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.events.CacheQueryExecutedEvent;
import org.apache.ignite.events.DiscoveryEvent;
import org.apache.ignite.events.Event;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.GridTopic;
import org.apache.ignite.internal.managers.communication.GridMessageListener;
import org.apache.ignite.internal.managers.eventstorage.GridLocalEventListener;
import org.apache.ignite.internal.processors.affinity.AffinityTopologyVersion;
import org.apache.ignite.internal.processors.cache.GridCacheContext;
import org.apache.ignite.internal.processors.cache.GridCacheSharedContext;
import org.apache.ignite.internal.processors.cache.distributed.dht.GridDhtLocalPartition;
import org.apache.ignite.internal.processors.cache.distributed.dht.GridDhtPartitionState;
import org.apache.ignite.internal.processors.cache.distributed.dht.GridDhtPartitionsReservation;
import org.apache.ignite.internal.processors.cache.distributed.dht.GridReservable;
import org.apache.ignite.internal.processors.cache.query.CacheQueryType;
import org.apache.ignite.internal.processors.cache.query.GridCacheQueryMarshallable;
import org.apache.ignite.internal.processors.cache.query.GridCacheSqlQuery;
import org.apache.ignite.internal.processors.query.h2.H2Utils;
import org.apache.ignite.internal.processors.query.h2.IgniteH2Indexing;
import org.apache.ignite.internal.processors.query.h2.opt.DistributedJoinMode;
import org.apache.ignite.internal.processors.query.h2.opt.GridH2QueryContext;
import org.apache.ignite.internal.processors.query.h2.opt.GridH2QueryType;
import org.apache.ignite.internal.processors.query.h2.opt.GridH2RetryException;
import org.apache.ignite.internal.processors.query.h2.twostep.MapNodeResults;
import org.apache.ignite.internal.processors.query.h2.twostep.MapQueryLazyWorker;
import org.apache.ignite.internal.processors.query.h2.twostep.MapQueryLazyWorkerKey;
import org.apache.ignite.internal.processors.query.h2.twostep.MapQueryResult;
import org.apache.ignite.internal.processors.query.h2.twostep.MapQueryResults;
import org.apache.ignite.internal.processors.query.h2.twostep.MapReplicatedReservation;
import org.apache.ignite.internal.processors.query.h2.twostep.MapReservationKey;
import org.apache.ignite.internal.processors.query.h2.twostep.messages.GridQueryCancelRequest;
import org.apache.ignite.internal.processors.query.h2.twostep.messages.GridQueryFailResponse;
import org.apache.ignite.internal.processors.query.h2.twostep.messages.GridQueryNextPageRequest;
import org.apache.ignite.internal.processors.query.h2.twostep.messages.GridQueryNextPageResponse;
import org.apache.ignite.internal.processors.query.h2.twostep.msg.GridH2QueryRequest;
import org.apache.ignite.internal.processors.query.h2.twostep.msg.GridH2ValueMessageFactory;
import org.apache.ignite.internal.util.GridSpinBusyLock;
import org.apache.ignite.internal.util.typedef.CI1;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.X;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.internal.util.worker.GridWorker;
import org.apache.ignite.plugin.extensions.communication.Message;
import org.apache.ignite.thread.IgniteThread;
import org.h2.jdbc.JdbcResultSet;
import org.h2.value.Value;
import org.jetbrains.annotations.Nullable;
import org.jsr166.ConcurrentHashMap8;

public class GridMapQueryExecutor {
    private IgniteLogger log;
    private GridKernalContext ctx;
    private IgniteH2Indexing h2;
    private ConcurrentMap<UUID, MapNodeResults> qryRess = new ConcurrentHashMap8();
    private final GridSpinBusyLock busyLock;
    private final ConcurrentMap<MapReservationKey, GridReservable> reservations = new ConcurrentHashMap8();
    private final ConcurrentHashMap<MapQueryLazyWorkerKey, MapQueryLazyWorker> lazyWorkers = new ConcurrentHashMap();
    private final GridSpinBusyLock lazyWorkerBusyLock = new GridSpinBusyLock();
    private final AtomicBoolean lazyWorkerStopGuard = new AtomicBoolean();

    public GridMapQueryExecutor(GridSpinBusyLock busyLock) {
        this.busyLock = busyLock;
    }

    public void start(final GridKernalContext ctx, IgniteH2Indexing h2) throws IgniteCheckedException {
        this.ctx = ctx;
        this.h2 = h2;
        this.log = ctx.log(GridMapQueryExecutor.class);
        final UUID locNodeId = ctx.localNodeId();
        ctx.event().addLocalEventListener(new GridLocalEventListener(){

            public void onEvent(Event evt) {
                UUID nodeId = ((DiscoveryEvent)evt).eventNode().id();
                GridH2QueryContext.clearAfterDeadNode(locNodeId, nodeId);
                MapNodeResults nodeRess = (MapNodeResults)GridMapQueryExecutor.this.qryRess.remove(nodeId);
                if (nodeRess == null) {
                    return;
                }
                nodeRess.cancelAll();
            }
        }, 12, new int[]{11});
        ctx.io().addMessageListener(GridTopic.TOPIC_QUERY, new GridMessageListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onMessage(UUID nodeId, Object msg, byte plc) {
                if (!GridMapQueryExecutor.this.busyLock.enterBusy()) {
                    return;
                }
                try {
                    if (msg instanceof GridCacheQueryMarshallable) {
                        ((GridCacheQueryMarshallable)msg).unmarshall(ctx.config().getMarshaller(), ctx);
                    }
                    GridMapQueryExecutor.this.onMessage(nodeId, msg);
                }
                finally {
                    GridMapQueryExecutor.this.busyLock.leaveBusy();
                }
            }
        });
    }

    public void cancelLazyWorkers() {
        if (!this.lazyWorkerStopGuard.compareAndSet(false, true)) {
            return;
        }
        this.lazyWorkerBusyLock.block();
        for (MapQueryLazyWorker worker : this.lazyWorkers.values()) {
            worker.stop();
        }
        this.lazyWorkers.clear();
    }

    public void onMessage(UUID nodeId, Object msg) {
        try {
            assert (msg != null);
            ClusterNode node = this.ctx.discovery().node(nodeId);
            if (node == null) {
                return;
            }
            boolean processed = true;
            if (msg instanceof GridH2QueryRequest) {
                this.onQueryRequest(node, (GridH2QueryRequest)msg);
            } else if (msg instanceof GridQueryNextPageRequest) {
                this.onNextPageRequest(node, (GridQueryNextPageRequest)msg);
            } else if (msg instanceof GridQueryCancelRequest) {
                this.onCancel(node, (GridQueryCancelRequest)msg);
            } else {
                processed = false;
            }
            if (processed && this.log.isDebugEnabled()) {
                this.log.debug("Processed request: " + nodeId + "->" + this.ctx.localNodeId() + " " + msg);
            }
        }
        catch (Throwable th) {
            U.error((IgniteLogger)this.log, (Object)("Failed to process message: " + msg), (Throwable)th);
        }
    }

    private void onCancel(ClusterNode node, GridQueryCancelRequest msg) {
        long qryReqId = msg.queryRequestId();
        MapNodeResults nodeRess = this.resultsForNode(node.id());
        boolean clear = GridH2QueryContext.clear(this.ctx.localNodeId(), node.id(), qryReqId, GridH2QueryType.MAP);
        if (!clear) {
            nodeRess.onCancel(qryReqId);
            GridH2QueryContext.clear(this.ctx.localNodeId(), node.id(), qryReqId, GridH2QueryType.MAP);
        }
        nodeRess.cancelRequest(qryReqId);
    }

    private MapNodeResults resultsForNode(UUID nodeId) {
        MapNodeResults old;
        MapNodeResults nodeRess = (MapNodeResults)this.qryRess.get(nodeId);
        if (nodeRess == null && (old = this.qryRess.putIfAbsent(nodeId, nodeRess = new MapNodeResults(nodeId))) != null) {
            nodeRess = old;
        }
        return nodeRess;
    }

    private GridDhtLocalPartition partition(GridCacheContext<?, ?> cctx, int p) {
        return cctx.topology().localPartition(p, AffinityTopologyVersion.NONE, false);
    }

    private boolean reservePartitions(@Nullable List<Integer> cacheIds, AffinityTopologyVersion topVer, int[] explicitParts, List<GridReservable> reserved) throws IgniteCheckedException {
        assert (topVer != null);
        if (F.isEmpty(cacheIds)) {
            return true;
        }
        Set partIds = GridMapQueryExecutor.wrap(explicitParts);
        for (int i = 0; i < cacheIds.size(); ++i) {
            GridDhtPartitionsReservation grp;
            GridCacheContext cctx = this.ctx.cache().context().cacheContext(cacheIds.get(i).intValue());
            if (cctx == null) {
                return false;
            }
            if (cctx.isLocal() || !cctx.rebalanceEnabled()) continue;
            final MapReservationKey grpKey = new MapReservationKey(cctx.name(), cctx.isReplicated() ? null : topVer);
            GridReservable r = (GridReservable)this.reservations.get(grpKey);
            if (explicitParts == null && r != null) {
                if (r == MapReplicatedReservation.INSTANCE) continue;
                if (!r.reserve()) {
                    return false;
                }
                reserved.add(r);
                continue;
            }
            int partsCnt = cctx.affinity().partitions();
            if (cctx.isReplicated()) {
                if (r != null) continue;
                for (int p = 0; p < partsCnt; ++p) {
                    GridDhtLocalPartition part = this.partition(cctx, p);
                    if (part != null && part.state() == GridDhtPartitionState.OWNING) continue;
                    return false;
                }
                this.reservations.putIfAbsent(grpKey, MapReplicatedReservation.INSTANCE);
                continue;
            }
            if (explicitParts == null) {
                partIds = cctx.affinity().primaryPartitions(this.ctx.localNodeId(), topVer);
            }
            for (int partId : partIds) {
                GridDhtLocalPartition part = this.partition(cctx, partId);
                if (part == null || part.state() != GridDhtPartitionState.OWNING || !part.reserve()) {
                    return false;
                }
                reserved.add((GridReservable)part);
                if (part.state() == GridDhtPartitionState.OWNING) continue;
                return false;
            }
            if (explicitParts != null || !(grp = new GridDhtPartitionsReservation(topVer, cctx, (Object)"SQL")).register(reserved.subList(reserved.size() - partIds.size(), reserved.size()))) continue;
            if (this.reservations.putIfAbsent(grpKey, (GridReservable)grp) != null) {
                throw new IllegalStateException("Reservation already exists.");
            }
            grp.onPublish((CI1)new CI1<GridDhtPartitionsReservation>(){

                public void apply(GridDhtPartitionsReservation r) {
                    GridMapQueryExecutor.this.reservations.remove(grpKey, r);
                }
            });
        }
        return true;
    }

    private static Collection<Integer> wrap(final int[] ints) {
        if (ints == null) {
            return null;
        }
        if (ints.length == 0) {
            return Collections.emptySet();
        }
        return new AbstractCollection<Integer>(){

            @Override
            public Iterator<Integer> iterator() {
                return new Iterator<Integer>(){
                    private int i = 0;

                    @Override
                    public boolean hasNext() {
                        return this.i < ints.length;
                    }

                    @Override
                    public Integer next() {
                        return ints[this.i++];
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }

            @Override
            public int size() {
                return ints.length;
            }
        };
    }

    private GridCacheContext<?, ?> findFirstPartitioned(List<Integer> caches) {
        GridCacheSharedContext sctx = this.ctx.cache().context();
        for (int i = 0; i < caches.size(); ++i) {
            GridCacheContext mainCctx = sctx.cacheContext(caches.get(i).intValue());
            if (mainCctx == null) {
                throw new CacheException("Failed to find cache.");
            }
            if (mainCctx.isLocal() || mainCctx.isReplicated()) continue;
            return mainCctx;
        }
        throw new IllegalStateException("Failed to find a partitioned cache.");
    }

    private void onQueryRequest(final ClusterNode node, final GridH2QueryRequest req) throws IgniteCheckedException {
        int[] qryParts = req.queryPartitions();
        final Map<UUID, int[]> partsMap = req.partitions();
        final int[] parts = qryParts == null ? (Object)(partsMap == null ? null : partsMap.get(this.ctx.localNodeId())) : qryParts;
        final DistributedJoinMode joinMode = DistributedJoinMode.distributedJoinMode(req.isFlagSet(4), req.isFlagSet(1));
        final boolean enforceJoinOrder = req.isFlagSet(2);
        boolean explain = req.isFlagSet(8);
        boolean replicated = req.isFlagSet(16);
        boolean lazy = req.isFlagSet(32);
        final List<Integer> cacheIds = req.caches();
        int segments = explain || replicated || F.isEmpty(cacheIds) ? 1 : this.findFirstPartitioned(cacheIds).config().getQueryParallelism();
        final Object[] params = req.parameters();
        for (int i = 1; i < segments; ++i) {
            assert (!F.isEmpty(cacheIds));
            final int segment = i;
            if (lazy) {
                this.onQueryRequest0(node, req.requestId(), segment, req.schemaName(), req.queries(), cacheIds, req.topologyVersion(), partsMap, parts, req.pageSize(), joinMode, enforceJoinOrder, false, req.timeout(), params, true);
                continue;
            }
            this.ctx.closure().callLocal((Callable)new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    GridMapQueryExecutor.this.onQueryRequest0(node, req.requestId(), segment, req.schemaName(), req.queries(), cacheIds, req.topologyVersion(), partsMap, parts, req.pageSize(), joinMode, enforceJoinOrder, false, req.timeout(), params, false);
                    return null;
                }
            }, (byte)10);
        }
        this.onQueryRequest0(node, req.requestId(), 0, req.schemaName(), req.queries(), cacheIds, req.topologyVersion(), partsMap, parts, req.pageSize(), joinMode, enforceJoinOrder, replicated, req.timeout(), params, lazy);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onQueryRequest0(final ClusterNode node, final long reqId, final int segmentId, final String schemaName, final Collection<GridCacheSqlQuery> qrys, final List<Integer> cacheIds, final AffinityTopologyVersion topVer, final Map<UUID, int[]> partsMap, final int[] parts, final int pageSize, final DistributedJoinMode distributedJoinMode, final boolean enforceJoinOrder, final boolean replicated, final int timeout, final Object[] params, boolean lazy) {
        if (lazy && MapQueryLazyWorker.currentWorker() == null) {
            MapQueryLazyWorkerKey key = new MapQueryLazyWorkerKey(node.id(), reqId, segmentId);
            MapQueryLazyWorker worker = new MapQueryLazyWorker(this.ctx.igniteInstanceName(), key, this.log, this);
            worker.submit(new Runnable(){

                @Override
                public void run() {
                    GridMapQueryExecutor.this.onQueryRequest0(node, reqId, segmentId, schemaName, qrys, cacheIds, topVer, partsMap, parts, pageSize, distributedJoinMode, enforceJoinOrder, replicated, timeout, params, true);
                }
            });
            if (this.lazyWorkerBusyLock.enterBusy()) {
                try {
                    MapQueryLazyWorker oldWorker = this.lazyWorkers.put(key, worker);
                    if (oldWorker != null) {
                        oldWorker.stop();
                    }
                    IgniteThread thread = new IgniteThread((GridWorker)worker);
                    thread.start();
                }
                finally {
                    this.lazyWorkerBusyLock.leaveBusy();
                }
            } else {
                this.log.info("Ignored query request (node is stopping) [nodeId=" + node.id() + ", reqId=" + reqId + ']');
            }
            return;
        }
        GridCacheContext mainCctx = !F.isEmpty(cacheIds) ? this.ctx.cache().context().cacheContext(cacheIds.get(0).intValue()) : null;
        MapNodeResults nodeRess = this.resultsForNode(node.id());
        MapQueryResults qr = null;
        ArrayList<GridReservable> reserved = new ArrayList<GridReservable>();
        try {
            if (topVer != null && !this.reservePartitions(cacheIds, topVer, parts, reserved)) {
                if (lazy) {
                    this.stopAndUnregisterCurrentLazyWorker();
                }
                this.sendRetry(node, reqId, segmentId);
                return;
            }
            qr = new MapQueryResults(this.h2, reqId, qrys.size(), mainCctx != null ? mainCctx.name() : null, MapQueryLazyWorker.currentWorker());
            if (nodeRess.put(reqId, segmentId, qr) != null) {
                throw new IllegalStateException();
            }
            GridH2QueryContext qctx = new GridH2QueryContext(this.ctx.localNodeId(), node.id(), reqId, segmentId, replicated ? GridH2QueryType.REPLICATED : GridH2QueryType.MAP).filter(this.h2.backupFilter(topVer, parts)).partitionsMap(partsMap).distributedJoinMode(distributedJoinMode).pageSize(pageSize).topologyVersion(topVer).reservations(reserved);
            Connection conn = this.h2.connectionForSchema(schemaName);
            H2Utils.setupConnection(conn, distributedJoinMode != DistributedJoinMode.OFF, enforceJoinOrder);
            GridH2QueryContext.set(qctx);
            reserved = null;
            try {
                if (nodeRess.cancelled(reqId)) {
                    GridH2QueryContext.clear(this.ctx.localNodeId(), node.id(), reqId, qctx.type());
                    nodeRess.cancelRequest(reqId);
                    throw new QueryCancelledException();
                }
                int qryIdx = 0;
                boolean evt = mainCctx != null && this.ctx.event().isRecordable(96);
                for (GridCacheSqlQuery qry : qrys) {
                    ResultSet rs = null;
                    if (qry.node() == null || segmentId == 0 && qry.node().equals(this.ctx.localNodeId())) {
                        rs = this.h2.executeSqlQueryWithTimer(conn, qry.query(), F.asList((Object[])qry.parameters(params)), true, timeout, qr.queryCancel(qryIdx));
                        if (evt) {
                            this.ctx.event().record((Event)new CacheQueryExecutedEvent(node, "SQL query executed.", 96, CacheQueryType.SQL.name(), mainCctx.name(), null, qry.query(), null, null, params, node.id(), null));
                        }
                        assert (rs instanceof JdbcResultSet) : rs.getClass();
                    }
                    qr.addResult(qryIdx, qry, node.id(), rs, params);
                    if (qr.cancelled()) {
                        qr.result(qryIdx).close();
                        throw new QueryCancelledException();
                    }
                    this.sendNextPage(nodeRess, node, qr, qryIdx, segmentId, pageSize);
                    ++qryIdx;
                }
            }
            finally {
                GridH2QueryContext.clearThreadLocal();
                if (distributedJoinMode == DistributedJoinMode.OFF) {
                    qctx.clearContext(false);
                }
            }
        }
        catch (Throwable e) {
            if (qr != null) {
                nodeRess.remove(reqId, segmentId, qr);
                qr.cancel(false);
            }
            if (lazy) {
                this.stopAndUnregisterCurrentLazyWorker();
            }
            if (X.hasCause((Throwable)e, (Class[])new Class[]{GridH2RetryException.class})) {
                this.sendRetry(node, reqId, segmentId);
            }
            U.error((IgniteLogger)this.log, (Object)"Failed to execute local query.", (Throwable)e);
            this.sendError(node, reqId, e);
            if (e instanceof Error) {
                throw (Error)e;
            }
        }
        finally {
            if (reserved != null) {
                for (int i = 0; i < reserved.size(); ++i) {
                    ((GridReservable)reserved.get(i)).release();
                }
            }
        }
    }

    private void sendError(ClusterNode node, long qryReqId, Throwable err) {
        try {
            GridQueryFailResponse msg = new GridQueryFailResponse(qryReqId, err);
            if (node.isLocal()) {
                U.error((IgniteLogger)this.log, (Object)"Failed to run map query on local node.", (Throwable)err);
                this.h2.reduceQueryExecutor().onMessage(this.ctx.localNodeId(), msg);
            } else {
                this.ctx.io().sendToGridTopic(node, GridTopic.TOPIC_QUERY, (Message)msg, (byte)10);
            }
        }
        catch (Exception e) {
            e.addSuppressed(err);
            U.error((IgniteLogger)this.log, (Object)"Failed to send error message.", (Throwable)e);
        }
    }

    private void onNextPageRequest(final ClusterNode node, final GridQueryNextPageRequest req) {
        final MapNodeResults nodeRess = (MapNodeResults)this.qryRess.get(node.id());
        if (nodeRess == null) {
            this.sendError(node, req.queryRequestId(), (Throwable)new CacheException("No node result found for request: " + req));
            return;
        }
        if (nodeRess.cancelled(req.queryRequestId())) {
            this.sendError(node, req.queryRequestId(), (Throwable)new QueryCancelledException());
            return;
        }
        final MapQueryResults qr = nodeRess.get(req.queryRequestId(), req.segmentId());
        if (qr == null) {
            this.sendError(node, req.queryRequestId(), (Throwable)new CacheException("No query result found for request: " + req));
        } else if (qr.cancelled()) {
            this.sendError(node, req.queryRequestId(), (Throwable)new QueryCancelledException());
        } else {
            MapQueryLazyWorker lazyWorker = qr.lazyWorker();
            if (lazyWorker != null) {
                lazyWorker.submit(new Runnable(){

                    @Override
                    public void run() {
                        GridMapQueryExecutor.this.sendNextPage(nodeRess, node, qr, req.query(), req.segmentId(), req.pageSize());
                    }
                });
            } else {
                this.sendNextPage(nodeRess, node, qr, req.query(), req.segmentId(), req.pageSize());
            }
        }
    }

    private void sendNextPage(MapNodeResults nodeRess, ClusterNode node, MapQueryResults qr, int qry, int segmentId, int pageSize) {
        MapQueryResult res = qr.result(qry);
        assert (res != null);
        if (res.closed()) {
            return;
        }
        int page = res.page();
        ArrayList<Value[]> rows = new ArrayList<Value[]>(Math.min(64, pageSize));
        boolean last = res.fetchNextPage(rows, pageSize);
        if (last) {
            res.close();
            if (qr.isAllClosed()) {
                nodeRess.remove(qr.queryRequestId(), segmentId, qr);
            }
        }
        try {
            boolean loc = node.isLocal();
            GridQueryNextPageResponse msg = new GridQueryNextPageResponse(qr.queryRequestId(), segmentId, qry, page, page == 0 ? res.rowCount() : -1, res.columnCount(), loc ? null : GridH2ValueMessageFactory.toMessages(rows, new ArrayList<Message>(res.columnCount())), loc ? rows : null, last);
            if (loc) {
                this.h2.reduceQueryExecutor().onMessage(this.ctx.localNodeId(), msg);
            } else {
                this.ctx.io().sendToGridTopic(node, GridTopic.TOPIC_QUERY, (Message)msg, (byte)10);
            }
        }
        catch (IgniteCheckedException e) {
            U.error((IgniteLogger)this.log, (Object)"Failed to send message.", (Throwable)e);
            throw new IgniteException((Throwable)e);
        }
    }

    private void sendRetry(ClusterNode node, long reqId, int segmentId) {
        try {
            boolean loc = node.isLocal();
            GridQueryNextPageResponse msg = new GridQueryNextPageResponse(reqId, segmentId, 0, 0, 0, 1, loc ? null : Collections.emptyList(), loc ? Collections.emptyList() : null, false);
            msg.retry(this.h2.readyTopologyVersion());
            if (loc) {
                this.h2.reduceQueryExecutor().onMessage(this.ctx.localNodeId(), msg);
            } else {
                this.ctx.io().sendToGridTopic(node, GridTopic.TOPIC_QUERY, (Message)msg, (byte)10);
            }
        }
        catch (Exception e) {
            U.warn((IgniteLogger)this.log, (Object)("Failed to send retry message: " + e.getMessage()));
        }
    }

    public void onCacheStop(String cacheName) {
        for (MapReservationKey grpKey : this.reservations.keySet()) {
            if (!F.eq((Object)grpKey.cacheName(), (Object)cacheName)) continue;
            this.reservations.remove(grpKey);
        }
    }

    public void stopAndUnregisterCurrentLazyWorker() {
        MapQueryLazyWorker worker = MapQueryLazyWorker.currentWorker();
        if (worker != null) {
            worker.stop();
            this.unregisterLazyWorker(worker);
        }
    }

    public void unregisterLazyWorker(MapQueryLazyWorker worker) {
        this.lazyWorkers.remove(worker.key(), (Object)worker);
    }

    public int registeredLazyWorkers() {
        return this.lazyWorkers.size();
    }
}

