/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.h2.sql;

import java.lang.reflect.Field;
import java.sql.PreparedStatement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import javax.cache.CacheException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.cache.CacheAtomicityMode;
import org.apache.ignite.cache.QueryIndex;
import org.apache.ignite.cache.QueryIndexType;
import org.apache.ignite.internal.processors.query.IgniteSQLException;
import org.apache.ignite.internal.processors.query.h2.sql.GridSqlAggregateFunction;
import org.apache.ignite.internal.processors.query.h2.sql.GridSqlAlias;
import org.apache.ignite.internal.processors.query.h2.sql.GridSqlArray;
import org.apache.ignite.internal.processors.query.h2.sql.GridSqlColumn;
import org.apache.ignite.internal.processors.query.h2.sql.GridSqlConst;
import org.apache.ignite.internal.processors.query.h2.sql.GridSqlCreateIndex;
import org.apache.ignite.internal.processors.query.h2.sql.GridSqlCreateTable;
import org.apache.ignite.internal.processors.query.h2.sql.GridSqlDelete;
import org.apache.ignite.internal.processors.query.h2.sql.GridSqlDropIndex;
import org.apache.ignite.internal.processors.query.h2.sql.GridSqlDropTable;
import org.apache.ignite.internal.processors.query.h2.sql.GridSqlElement;
import org.apache.ignite.internal.processors.query.h2.sql.GridSqlFunction;
import org.apache.ignite.internal.processors.query.h2.sql.GridSqlFunctionType;
import org.apache.ignite.internal.processors.query.h2.sql.GridSqlInsert;
import org.apache.ignite.internal.processors.query.h2.sql.GridSqlJoin;
import org.apache.ignite.internal.processors.query.h2.sql.GridSqlKeyword;
import org.apache.ignite.internal.processors.query.h2.sql.GridSqlMerge;
import org.apache.ignite.internal.processors.query.h2.sql.GridSqlOperation;
import org.apache.ignite.internal.processors.query.h2.sql.GridSqlOperationType;
import org.apache.ignite.internal.processors.query.h2.sql.GridSqlParameter;
import org.apache.ignite.internal.processors.query.h2.sql.GridSqlPlaceholder;
import org.apache.ignite.internal.processors.query.h2.sql.GridSqlQuery;
import org.apache.ignite.internal.processors.query.h2.sql.GridSqlSelect;
import org.apache.ignite.internal.processors.query.h2.sql.GridSqlSortColumn;
import org.apache.ignite.internal.processors.query.h2.sql.GridSqlStatement;
import org.apache.ignite.internal.processors.query.h2.sql.GridSqlSubquery;
import org.apache.ignite.internal.processors.query.h2.sql.GridSqlTable;
import org.apache.ignite.internal.processors.query.h2.sql.GridSqlType;
import org.apache.ignite.internal.processors.query.h2.sql.GridSqlUnion;
import org.apache.ignite.internal.processors.query.h2.sql.GridSqlUpdate;
import org.apache.ignite.internal.util.typedef.F;
import org.h2.command.Command;
import org.h2.command.CommandContainer;
import org.h2.command.Prepared;
import org.h2.command.ddl.AlterTableAddConstraint;
import org.h2.command.ddl.CreateIndex;
import org.h2.command.ddl.CreateTable;
import org.h2.command.ddl.CreateTableData;
import org.h2.command.ddl.DefineCommand;
import org.h2.command.ddl.DropIndex;
import org.h2.command.ddl.DropTable;
import org.h2.command.ddl.SchemaCommand;
import org.h2.command.dml.Delete;
import org.h2.command.dml.Explain;
import org.h2.command.dml.Insert;
import org.h2.command.dml.Merge;
import org.h2.command.dml.Query;
import org.h2.command.dml.Select;
import org.h2.command.dml.SelectUnion;
import org.h2.command.dml.Update;
import org.h2.engine.FunctionAlias;
import org.h2.expression.Aggregate;
import org.h2.expression.Alias;
import org.h2.expression.CompareLike;
import org.h2.expression.Comparison;
import org.h2.expression.ConditionAndOr;
import org.h2.expression.ConditionExists;
import org.h2.expression.ConditionIn;
import org.h2.expression.ConditionInConstantSet;
import org.h2.expression.ConditionInSelect;
import org.h2.expression.ConditionNot;
import org.h2.expression.Expression;
import org.h2.expression.ExpressionColumn;
import org.h2.expression.ExpressionList;
import org.h2.expression.Function;
import org.h2.expression.JavaFunction;
import org.h2.expression.Operation;
import org.h2.expression.Parameter;
import org.h2.expression.Subquery;
import org.h2.expression.TableFunction;
import org.h2.expression.ValueExpression;
import org.h2.index.ViewIndex;
import org.h2.jdbc.JdbcPreparedStatement;
import org.h2.result.SortOrder;
import org.h2.schema.Schema;
import org.h2.table.Column;
import org.h2.table.FunctionTable;
import org.h2.table.IndexColumn;
import org.h2.table.RangeTable;
import org.h2.table.Table;
import org.h2.table.TableBase;
import org.h2.table.TableFilter;
import org.h2.table.TableView;
import org.jetbrains.annotations.Nullable;

public class GridSqlQueryParser {
    private static final GridSqlOperationType[] OPERATION_OP_TYPES = new GridSqlOperationType[]{GridSqlOperationType.CONCAT, GridSqlOperationType.PLUS, GridSqlOperationType.MINUS, GridSqlOperationType.MULTIPLY, GridSqlOperationType.DIVIDE, null, GridSqlOperationType.MODULUS};
    private static final GridSqlOperationType[] COMPARISON_TYPES = new GridSqlOperationType[]{GridSqlOperationType.EQUAL, GridSqlOperationType.BIGGER_EQUAL, GridSqlOperationType.BIGGER, GridSqlOperationType.SMALLER_EQUAL, GridSqlOperationType.SMALLER, GridSqlOperationType.NOT_EQUAL, GridSqlOperationType.IS_NULL, GridSqlOperationType.IS_NOT_NULL, null, null, null, GridSqlOperationType.SPATIAL_INTERSECTS, null, null, null, null, GridSqlOperationType.EQUAL_NULL_SAFE, null, null, null, null, GridSqlOperationType.NOT_EQUAL_NULL_SAFE};
    private static final Getter<Select, Expression> CONDITION = GridSqlQueryParser.getter(Select.class, "condition");
    private static final Getter<Select, int[]> GROUP_INDEXES = GridSqlQueryParser.getter(Select.class, "groupIndex");
    private static final Getter<Operation, Integer> OPERATION_TYPE = GridSqlQueryParser.getter(Operation.class, "opType");
    private static final Getter<Operation, Expression> OPERATION_LEFT = GridSqlQueryParser.getter(Operation.class, "left");
    private static final Getter<Operation, Expression> OPERATION_RIGHT = GridSqlQueryParser.getter(Operation.class, "right");
    private static final Getter<Comparison, Integer> COMPARISON_TYPE = GridSqlQueryParser.getter(Comparison.class, "compareType");
    private static final Getter<Comparison, Expression> COMPARISON_LEFT = GridSqlQueryParser.getter(Comparison.class, "left");
    private static final Getter<Comparison, Expression> COMPARISON_RIGHT = GridSqlQueryParser.getter(Comparison.class, "right");
    private static final Getter<ConditionAndOr, Integer> ANDOR_TYPE = GridSqlQueryParser.getter(ConditionAndOr.class, "andOrType");
    private static final Getter<ConditionAndOr, Expression> ANDOR_LEFT = GridSqlQueryParser.getter(ConditionAndOr.class, "left");
    private static final Getter<ConditionAndOr, Expression> ANDOR_RIGHT = GridSqlQueryParser.getter(ConditionAndOr.class, "right");
    public static final Getter<TableView, Query> VIEW_QUERY = GridSqlQueryParser.getter(TableView.class, "viewQuery");
    private static final Getter<TableFilter, String> ALIAS = GridSqlQueryParser.getter(TableFilter.class, "alias");
    private static final Getter<Select, Integer> HAVING_INDEX = GridSqlQueryParser.getter(Select.class, "havingIndex");
    private static final Getter<ConditionIn, Expression> LEFT_CI = GridSqlQueryParser.getter(ConditionIn.class, "left");
    private static final Getter<ConditionIn, List<Expression>> VALUE_LIST_CI = GridSqlQueryParser.getter(ConditionIn.class, "valueList");
    private static final Getter<ConditionInConstantSet, Expression> LEFT_CICS = GridSqlQueryParser.getter(ConditionInConstantSet.class, "left");
    private static final Getter<ConditionInConstantSet, List<Expression>> VALUE_LIST_CICS = GridSqlQueryParser.getter(ConditionInConstantSet.class, "valueList");
    private static final Getter<ExpressionList, Expression[]> EXPR_LIST = GridSqlQueryParser.getter(ExpressionList.class, "list");
    private static final Getter<ConditionInSelect, Expression> LEFT_CIS = GridSqlQueryParser.getter(ConditionInSelect.class, "left");
    private static final Getter<ConditionInSelect, Boolean> ALL = GridSqlQueryParser.getter(ConditionInSelect.class, "all");
    private static final Getter<ConditionInSelect, Integer> COMPARE_TYPE = GridSqlQueryParser.getter(ConditionInSelect.class, "compareType");
    private static final Getter<ConditionInSelect, Query> QUERY_IN = GridSqlQueryParser.getter(ConditionInSelect.class, "query");
    private static final Getter<ConditionExists, Query> QUERY_EXISTS = GridSqlQueryParser.getter(ConditionExists.class, "query");
    private static final Getter<CompareLike, Expression> LEFT = GridSqlQueryParser.getter(CompareLike.class, "left");
    private static final Getter<CompareLike, Expression> RIGHT = GridSqlQueryParser.getter(CompareLike.class, "right");
    private static final Getter<CompareLike, Expression> ESCAPE = GridSqlQueryParser.getter(CompareLike.class, "escape");
    private static final Getter<CompareLike, Boolean> REGEXP_CL = GridSqlQueryParser.getter(CompareLike.class, "regexp");
    private static final Getter<Aggregate, Boolean> DISTINCT = GridSqlQueryParser.getter(Aggregate.class, "distinct");
    private static final Getter<Aggregate, Integer> TYPE = GridSqlQueryParser.getter(Aggregate.class, "type");
    private static final Getter<Aggregate, Expression> ON = GridSqlQueryParser.getter(Aggregate.class, "on");
    private static final Getter<RangeTable, Expression> RANGE_MIN = GridSqlQueryParser.getter(RangeTable.class, "min");
    private static final Getter<RangeTable, Expression> RANGE_MAX = GridSqlQueryParser.getter(RangeTable.class, "max");
    private static final Getter<FunctionTable, Expression> FUNC_EXPR = GridSqlQueryParser.getter(FunctionTable.class, "functionExpr");
    private static final Getter<TableFunction, Column[]> FUNC_TBL_COLS = GridSqlQueryParser.getter(TableFunction.class, "columnList");
    private static final Getter<JavaFunction, FunctionAlias> FUNC_ALIAS = GridSqlQueryParser.getter(JavaFunction.class, "functionAlias");
    private static final Getter<ExpressionColumn, String> SCHEMA_NAME = GridSqlQueryParser.getter(ExpressionColumn.class, "schemaName");
    private static final Getter<JdbcPreparedStatement, Command> COMMAND = GridSqlQueryParser.getter(JdbcPreparedStatement.class, "command");
    private static final Getter<SelectUnion, SortOrder> UNION_SORT = GridSqlQueryParser.getter(SelectUnion.class, "sort");
    private static final Getter<Explain, Prepared> EXPLAIN_COMMAND = GridSqlQueryParser.getter(Explain.class, "command");
    private static final Getter<Merge, Table> MERGE_TABLE = GridSqlQueryParser.getter(Merge.class, "table");
    private static final Getter<Merge, Column[]> MERGE_COLUMNS = GridSqlQueryParser.getter(Merge.class, "columns");
    private static final Getter<Merge, Column[]> MERGE_KEYS = GridSqlQueryParser.getter(Merge.class, "keys");
    private static final Getter<Merge, List<Expression[]>> MERGE_ROWS = GridSqlQueryParser.getter(Merge.class, "list");
    private static final Getter<Merge, Query> MERGE_QUERY = GridSqlQueryParser.getter(Merge.class, "query");
    private static final Getter<Insert, Table> INSERT_TABLE = GridSqlQueryParser.getter(Insert.class, "table");
    private static final Getter<Insert, Column[]> INSERT_COLUMNS = GridSqlQueryParser.getter(Insert.class, "columns");
    private static final Getter<Insert, List<Expression[]>> INSERT_ROWS = GridSqlQueryParser.getter(Insert.class, "list");
    private static final Getter<Insert, Query> INSERT_QUERY = GridSqlQueryParser.getter(Insert.class, "query");
    private static final Getter<Insert, Boolean> INSERT_DIRECT = GridSqlQueryParser.getter(Insert.class, "insertFromSelect");
    private static final Getter<Insert, Boolean> INSERT_SORTED = GridSqlQueryParser.getter(Insert.class, "sortedInsertMode");
    private static final Getter<Delete, TableFilter> DELETE_FROM = GridSqlQueryParser.getter(Delete.class, "tableFilter");
    private static final Getter<Delete, Expression> DELETE_WHERE = GridSqlQueryParser.getter(Delete.class, "condition");
    private static final Getter<Delete, Expression> DELETE_LIMIT = GridSqlQueryParser.getter(Delete.class, "limitExpr");
    private static final Getter<Update, TableFilter> UPDATE_TARGET = GridSqlQueryParser.getter(Update.class, "tableFilter");
    private static final Getter<Update, ArrayList<Column>> UPDATE_COLUMNS = GridSqlQueryParser.getter(Update.class, "columns");
    private static final Getter<Update, HashMap<Column, Expression>> UPDATE_SET = GridSqlQueryParser.getter(Update.class, "expressionMap");
    private static final Getter<Update, Expression> UPDATE_WHERE = GridSqlQueryParser.getter(Update.class, "condition");
    private static final Getter<Update, Expression> UPDATE_LIMIT = GridSqlQueryParser.getter(Update.class, "limitExpr");
    private static final Getter<Command, Prepared> PREPARED = GridSqlQueryParser.getter(CommandContainer.class, "prepared");
    private static final Getter<CreateIndex, String> CREATE_INDEX_NAME = GridSqlQueryParser.getter(CreateIndex.class, "indexName");
    private static final Getter<CreateIndex, String> CREATE_INDEX_TABLE_NAME = GridSqlQueryParser.getter(CreateIndex.class, "tableName");
    private static final Getter<CreateIndex, IndexColumn[]> CREATE_INDEX_COLUMNS = GridSqlQueryParser.getter(CreateIndex.class, "indexColumns");
    private static final Getter<CreateIndex, Boolean> CREATE_INDEX_SPATIAL = GridSqlQueryParser.getter(CreateIndex.class, "spatial");
    private static final Getter<CreateIndex, Boolean> CREATE_INDEX_PRIMARY_KEY = GridSqlQueryParser.getter(CreateIndex.class, "primaryKey");
    private static final Getter<CreateIndex, Boolean> CREATE_INDEX_UNIQUE = GridSqlQueryParser.getter(CreateIndex.class, "unique");
    private static final Getter<CreateIndex, Boolean> CREATE_INDEX_HASH = GridSqlQueryParser.getter(CreateIndex.class, "hash");
    private static final Getter<CreateIndex, Boolean> CREATE_INDEX_IF_NOT_EXISTS = GridSqlQueryParser.getter(CreateIndex.class, "ifNotExists");
    private static final Getter<IndexColumn, String> INDEX_COLUMN_NAME = GridSqlQueryParser.getter(IndexColumn.class, "columnName");
    private static final Getter<IndexColumn, Integer> INDEX_COLUMN_SORT_TYPE = GridSqlQueryParser.getter(IndexColumn.class, "sortType");
    private static final Getter<DropIndex, String> DROP_INDEX_NAME = GridSqlQueryParser.getter(DropIndex.class, "indexName");
    private static final Getter<DropIndex, Boolean> DROP_INDEX_IF_EXISTS = GridSqlQueryParser.getter(DropIndex.class, "ifExists");
    private static final Getter<SchemaCommand, Schema> SCHEMA_COMMAND_SCHEMA = GridSqlQueryParser.getter(SchemaCommand.class, "schema");
    private static final Getter<CreateTable, CreateTableData> CREATE_TABLE_DATA = GridSqlQueryParser.getter(CreateTable.class, "data");
    private static final Getter<CreateTable, ArrayList<DefineCommand>> CREATE_TABLE_CONSTRAINTS = GridSqlQueryParser.getter(CreateTable.class, "constraintCommands");
    private static final Getter<CreateTable, IndexColumn[]> CREATE_TABLE_PK = GridSqlQueryParser.getter(CreateTable.class, "pkColumns");
    private static final Getter<CreateTable, Boolean> CREATE_TABLE_IF_NOT_EXISTS = GridSqlQueryParser.getter(CreateTable.class, "ifNotExists");
    private static final Getter<CreateTable, Query> CREATE_TABLE_QUERY = GridSqlQueryParser.getter(CreateTable.class, "asQuery");
    private static final Getter<DropTable, Boolean> DROP_TABLE_IF_EXISTS = GridSqlQueryParser.getter(DropTable.class, "ifExists");
    private static final Getter<DropTable, String> DROP_TABLE_NAME = GridSqlQueryParser.getter(DropTable.class, "tableName");
    private static final Getter<Column, Boolean> COLUMN_IS_COMPUTED = GridSqlQueryParser.getter(Column.class, "isComputed");
    private static final Getter<Column, Expression> COLUMN_CHECK_CONSTRAINT = GridSqlQueryParser.getter(Column.class, "checkConstraint");
    private static final String PARAM_NAME_VALUE_SEPARATOR = "=";
    private static final String PARAM_TEMPLATE = "TEMPLATE";
    private static final String PARAM_BACKUPS = "BACKUPS";
    private static final String PARAM_ATOMICITY = "ATOMICITY";
    private static final String PARAM_CACHE_GROUP = "CACHEGROUP";
    private static final String PARAM_AFFINITY_KEY = "AFFINITYKEY";
    private final IdentityHashMap<Object, Object> h2ObjToGridObj = new IdentityHashMap();
    private final Map<String, Integer> optimizedTableFilterOrder;
    private int parsingSubQryExpression;

    public GridSqlQueryParser(boolean useOptimizedSubqry) {
        this.optimizedTableFilterOrder = useOptimizedSubqry ? new HashMap() : null;
    }

    public static Prepared prepared(PreparedStatement stmt) {
        Command cmd = COMMAND.get((JdbcPreparedStatement)stmt);
        assert (cmd instanceof CommandContainer);
        return PREPARED.get(cmd);
    }

    private GridSqlSubquery parseQueryExpression(Query qry) {
        ++this.parsingSubQryExpression;
        GridSqlQuery subQry = this.parseQuery(qry);
        --this.parsingSubQryExpression;
        return new GridSqlSubquery(subQry);
    }

    private GridSqlElement parseTableFilter(TableFilter filter) {
        GridSqlElement res = (GridSqlElement)this.h2ObjToGridObj.get(filter);
        if (res == null) {
            String alias;
            res = this.parseTable(filter.getTable());
            if (res instanceof GridSqlTable && filter.getIndexHints() != null) {
                ((GridSqlTable)res).useIndexes(new ArrayList<String>(filter.getIndexHints().getAllowedIndexes()));
            }
            if ((alias = ALIAS.get(filter)) != null) {
                res = new GridSqlAlias(alias, res, false);
            }
            this.h2ObjToGridObj.put(filter, res);
        }
        return res;
    }

    private GridSqlElement parseTable(Table tbl) {
        GridSqlElement res = (GridSqlElement)this.h2ObjToGridObj.get(tbl);
        if (res == null) {
            if (tbl instanceof TableBase) {
                return new GridSqlTable(tbl);
            }
            if (tbl instanceof TableView) {
                Query qry = VIEW_QUERY.get((TableView)tbl);
                res = new GridSqlSubquery(this.parseQuery(qry));
            } else if (tbl instanceof FunctionTable) {
                res = this.parseExpression(FUNC_EXPR.get((FunctionTable)tbl), false);
            } else if (tbl instanceof RangeTable) {
                res = new GridSqlFunction(GridSqlFunctionType.SYSTEM_RANGE);
                res.addChild(this.parseExpression(RANGE_MIN.get((RangeTable)tbl), false));
                res.addChild(this.parseExpression(RANGE_MAX.get((RangeTable)tbl), false));
            } else {
                GridSqlQueryParser.assert0(false, "Unexpected Table implementation [cls=" + tbl.getClass().getSimpleName() + ']');
            }
            this.h2ObjToGridObj.put(tbl, res);
        }
        return res;
    }

    private GridSqlSelect parseSelect(Select select) {
        int havingIdx;
        GridSqlSelect res = (GridSqlSelect)this.h2ObjToGridObj.get(select);
        if (res != null) {
            return res;
        }
        res = new GridSqlSelect();
        this.h2ObjToGridObj.put(select, res);
        res.distinct(select.isDistinct());
        Expression where = CONDITION.get(select);
        res.where(this.parseExpression(where, true));
        ArrayList<TableFilter> tableFilters = new ArrayList<TableFilter>();
        TableFilter filter = select.getTopTableFilter();
        do {
            GridSqlQueryParser.assert0(filter != null, select);
            GridSqlQueryParser.assert0(filter.getNestedJoin() == null, select);
            if (this.parsingSubQryExpression == 0 && this.optimizedTableFilterOrder != null) {
                String tblAlias = filter.getTableAlias();
                int idx = this.optimizedTableFilterOrder.get(tblAlias);
                GridSqlQueryParser.setElementAt(tableFilters, idx, filter);
                continue;
            }
            tableFilters.add(filter);
        } while ((filter = filter.getJoin()) != null);
        GridSqlElement from = null;
        for (int i = 0; i < tableFilters.size(); ++i) {
            TableFilter f = (TableFilter)tableFilters.get(i);
            GridSqlElement gridFilter = this.parseTableFilter(f);
            from = from == null ? gridFilter : new GridSqlJoin(from, gridFilter, f.isJoinOuter(), this.parseExpression(f.getJoinCondition(), true));
        }
        res.from(from);
        ArrayList expressions = select.getExpressions();
        for (int i = 0; i < expressions.size(); ++i) {
            res.addColumn(this.parseExpression((Expression)expressions.get(i), true), i < select.getColumnCount());
        }
        int[] grpIdx = GROUP_INDEXES.get(select);
        if (grpIdx != null) {
            res.groupColumns(grpIdx);
        }
        if ((havingIdx = HAVING_INDEX.get(select).intValue()) >= 0) {
            res.havingColumn(havingIdx);
        }
        this.processSortOrder(select.getSortOrder(), res);
        res.limit(this.parseExpression(select.getLimit(), false));
        res.offset(this.parseExpression(select.getOffset(), false));
        return res;
    }

    private static <Z> void setElementAt(List<Z> list, int idx, Z x) {
        while (list.size() <= idx) {
            list.add(null);
        }
        GridSqlQueryParser.assert0(list.get(idx) == null, "Element already set: " + idx);
        list.set(idx, x);
    }

    private GridSqlMerge parseMerge(Merge merge) {
        GridSqlMerge res = (GridSqlMerge)this.h2ObjToGridObj.get(merge);
        if (res != null) {
            return res;
        }
        res = new GridSqlMerge();
        this.h2ObjToGridObj.put(merge, res);
        Table srcTbl = MERGE_TABLE.get(merge);
        GridSqlElement tbl = this.parseTable(srcTbl);
        res.into(tbl);
        Column[] srcCols = MERGE_COLUMNS.get(merge);
        GridSqlColumn[] cols = new GridSqlColumn[srcCols.length];
        for (int i = 0; i < srcCols.length; ++i) {
            cols[i] = new GridSqlColumn(srcCols[i], tbl, null, null, srcCols[i].getName());
            cols[i].resultType(GridSqlType.fromColumn(srcCols[i]));
        }
        res.columns(cols);
        Column[] srcKeys = MERGE_KEYS.get(merge);
        GridSqlColumn[] keys = new GridSqlColumn[srcKeys.length];
        for (int i = 0; i < srcKeys.length; ++i) {
            keys[i] = new GridSqlColumn(srcKeys[i], tbl, null, null, srcKeys[i].getName());
        }
        res.keys(keys);
        List<Expression[]> srcRows = MERGE_ROWS.get(merge);
        if (!srcRows.isEmpty()) {
            ArrayList<GridSqlElement[]> rows = new ArrayList<GridSqlElement[]>(srcRows.size());
            for (Expression[] srcRow : srcRows) {
                GridSqlElement[] row = new GridSqlElement[srcRow.length];
                for (int i = 0; i < srcRow.length; ++i) {
                    row[i] = this.parseExpression(srcRow[i], false);
                }
                rows.add(row);
            }
            res.rows(rows);
        } else {
            res.rows(Collections.emptyList());
            res.query(this.parseQuery(MERGE_QUERY.get(merge)));
        }
        return res;
    }

    private GridSqlInsert parseInsert(Insert insert) {
        GridSqlInsert res = (GridSqlInsert)this.h2ObjToGridObj.get(insert);
        if (res != null) {
            return res;
        }
        res = new GridSqlInsert();
        this.h2ObjToGridObj.put(insert, res);
        Table srcTbl = INSERT_TABLE.get(insert);
        GridSqlElement tbl = this.parseTable(srcTbl);
        res.into(tbl).direct(INSERT_DIRECT.get(insert)).sorted(INSERT_SORTED.get(insert));
        Column[] srcCols = INSERT_COLUMNS.get(insert);
        GridSqlColumn[] cols = new GridSqlColumn[srcCols.length];
        for (int i = 0; i < srcCols.length; ++i) {
            cols[i] = new GridSqlColumn(srcCols[i], tbl, null, null, srcCols[i].getName());
            cols[i].resultType(GridSqlType.fromColumn(srcCols[i]));
        }
        res.columns(cols);
        List<Expression[]> srcRows = INSERT_ROWS.get(insert);
        if (!srcRows.isEmpty()) {
            ArrayList<GridSqlElement[]> rows = new ArrayList<GridSqlElement[]>(srcRows.size());
            for (Expression[] srcRow : srcRows) {
                GridSqlElement[] row = new GridSqlElement[srcRow.length];
                for (int i = 0; i < srcRow.length; ++i) {
                    row[i] = this.parseExpression(srcRow[i], false);
                }
                rows.add(row);
            }
            res.rows(rows);
        } else {
            res.rows(Collections.emptyList());
            res.query(this.parseQuery(INSERT_QUERY.get(insert)));
        }
        return res;
    }

    private GridSqlDelete parseDelete(Delete del) {
        GridSqlDelete res = (GridSqlDelete)this.h2ObjToGridObj.get(del);
        if (res != null) {
            return res;
        }
        res = new GridSqlDelete();
        this.h2ObjToGridObj.put(del, res);
        GridSqlElement tbl = this.parseTableFilter(DELETE_FROM.get(del));
        GridSqlElement where = this.parseExpression(DELETE_WHERE.get(del), true);
        GridSqlElement limit = this.parseExpression(DELETE_LIMIT.get(del), true);
        res.from(tbl).where(where).limit(limit);
        return res;
    }

    private GridSqlUpdate parseUpdate(Update update) {
        GridSqlUpdate res = (GridSqlUpdate)this.h2ObjToGridObj.get(update);
        if (res != null) {
            return res;
        }
        res = new GridSqlUpdate();
        this.h2ObjToGridObj.put(update, res);
        GridSqlElement tbl = this.parseTableFilter(UPDATE_TARGET.get(update));
        List srcCols = UPDATE_COLUMNS.get(update);
        Map srcSet = UPDATE_SET.get(update);
        ArrayList<GridSqlColumn> cols = new ArrayList<GridSqlColumn>(srcCols.size());
        LinkedHashMap<String, GridSqlElement> set = new LinkedHashMap<String, GridSqlElement>(srcSet.size());
        for (Column c : srcCols) {
            GridSqlColumn col = new GridSqlColumn(c, tbl, null, null, c.getName());
            col.resultType(GridSqlType.fromColumn(c));
            cols.add(col);
            set.put(col.columnName(), this.parseExpression((Expression)srcSet.get(c), true));
        }
        GridSqlElement where = this.parseExpression(UPDATE_WHERE.get(update), true);
        GridSqlElement limit = this.parseExpression(UPDATE_LIMIT.get(update), true);
        res.target(tbl).cols(cols).set(set).where(where).limit(limit);
        return res;
    }

    private GridSqlDropIndex parseDropIndex(DropIndex dropIdx) {
        GridSqlDropIndex res = new GridSqlDropIndex();
        res.indexName(DROP_INDEX_NAME.get(dropIdx));
        res.schemaName(SCHEMA_COMMAND_SCHEMA.get((SchemaCommand)dropIdx).getName());
        res.ifExists(DROP_INDEX_IF_EXISTS.get(dropIdx));
        return res;
    }

    private GridSqlCreateIndex parseCreateIndex(CreateIndex createIdx) {
        if (CREATE_INDEX_HASH.get(createIdx).booleanValue() || CREATE_INDEX_PRIMARY_KEY.get(createIdx).booleanValue() || CREATE_INDEX_UNIQUE.get(createIdx).booleanValue()) {
            throw new IgniteSQLException("Only SPATIAL modifier is supported for CREATE INDEX", 1002);
        }
        GridSqlCreateIndex res = new GridSqlCreateIndex();
        Schema schema = SCHEMA_COMMAND_SCHEMA.get((SchemaCommand)createIdx);
        String tblName = CREATE_INDEX_TABLE_NAME.get(createIdx);
        res.schemaName(schema.getName());
        res.tableName(tblName);
        res.ifNotExists(CREATE_INDEX_IF_NOT_EXISTS.get(createIdx));
        QueryIndex idx = new QueryIndex();
        idx.setName(CREATE_INDEX_NAME.get(createIdx));
        idx.setIndexType(CREATE_INDEX_SPATIAL.get(createIdx) != false ? QueryIndexType.GEOSPATIAL : QueryIndexType.SORTED);
        IndexColumn[] cols = CREATE_INDEX_COLUMNS.get(createIdx);
        LinkedHashMap<String, Boolean> flds = new LinkedHashMap<String, Boolean>(cols.length);
        for (IndexColumn col : CREATE_INDEX_COLUMNS.get(createIdx)) {
            int sortType = INDEX_COLUMN_SORT_TYPE.get(col);
            if ((sortType & 2) != 0 || (sortType & 4) != 0) {
                throw new IgniteSQLException("NULLS FIRST and NULLS LAST modifiers are not supported for index columns", 1002);
            }
            flds.put(INDEX_COLUMN_NAME.get(col), (sortType & 1) == 0);
        }
        idx.setFields(flds);
        res.index(idx);
        return res;
    }

    private GridSqlCreateTable parseCreateTable(CreateTable createTbl) {
        ArrayList<String> extraParams;
        GridSqlCreateTable res = new GridSqlCreateTable();
        res.templateName("PARTITIONED");
        Query qry = CREATE_TABLE_QUERY.get(createTbl);
        if (qry != null) {
            throw new IgniteSQLException("CREATE TABLE ... AS ... syntax is not supported", 1002);
        }
        List constraints = CREATE_TABLE_CONSTRAINTS.get(createTbl);
        if (constraints.size() == 0) {
            throw new IgniteSQLException("No PRIMARY KEY defined for CREATE TABLE", 1001);
        }
        if (constraints.size() > 1) {
            throw new IgniteSQLException("Too many constraints - only PRIMARY KEY is supported for CREATE TABLE", 1002);
        }
        DefineCommand constraint = (DefineCommand)constraints.get(0);
        if (!(constraint instanceof AlterTableAddConstraint)) {
            throw new IgniteSQLException("Unsupported type of constraint for CREATE TABLE - only PRIMARY KEY is supported", 1002);
        }
        AlterTableAddConstraint alterTbl = (AlterTableAddConstraint)constraint;
        if (alterTbl.getType() != 6) {
            throw new IgniteSQLException("Unsupported type of constraint for CREATE TABLE - only PRIMARY KEY is supported", 1002);
        }
        Schema schema = SCHEMA_COMMAND_SCHEMA.get((SchemaCommand)createTbl);
        res.schemaName(schema.getName());
        CreateTableData data = CREATE_TABLE_DATA.get(createTbl);
        LinkedHashMap<String, GridSqlColumn> cols = new LinkedHashMap<String, GridSqlColumn>(data.columns.size());
        for (Column col : data.columns) {
            if (col.isAutoIncrement()) {
                throw new IgniteSQLException("AUTO_INCREMENT columns are not supported [colName=" + col.getName() + ']', 1002);
            }
            if (!col.isNullable()) {
                throw new IgniteSQLException("Non nullable columns are forbidden [colName=" + col.getName() + ']', 1001);
            }
            if (COLUMN_IS_COMPUTED.get(col).booleanValue()) {
                throw new IgniteSQLException("Computed columns are not supported [colName=" + col.getName() + ']', 1002);
            }
            if (col.getDefaultExpression() != null) {
                throw new IgniteSQLException("DEFAULT expressions are not supported [colName=" + col.getName() + ']', 1002);
            }
            if (col.getSequence() != null) {
                throw new IgniteSQLException("SEQUENCE columns are not supported [colName=" + col.getName() + ']', 1002);
            }
            if (col.getSelectivity() != 50) {
                throw new IgniteSQLException("SELECTIVITY column attr is not supported [colName=" + col.getName() + ']', 1002);
            }
            if (COLUMN_CHECK_CONSTRAINT.get(col) != null) {
                throw new IgniteSQLException("Column CHECK constraints are not supported [colName=" + col.getName() + ']', 1002);
            }
            GridSqlColumn gridCol = new GridSqlColumn(col, null, col.getName());
            gridCol.resultType(GridSqlType.fromColumn(col));
            cols.put(col.getName(), gridCol);
        }
        if (cols.containsKey("_KEY".toUpperCase()) || cols.containsKey("_VAL".toUpperCase())) {
            throw new IgniteSQLException("Direct specification of _KEY and _VAL columns is forbidden", 1001);
        }
        Object[] pkIdxCols = CREATE_TABLE_PK.get(createTbl);
        if (F.isEmpty((Object[])pkIdxCols)) {
            throw new AssertionError((Object)"No PRIMARY KEY columns specified");
        }
        LinkedHashSet<String> pkCols = new LinkedHashSet<String>();
        for (Object pkIdxCol : pkIdxCols) {
            GridSqlColumn gridSqlColumn = (GridSqlColumn)cols.get(((IndexColumn)pkIdxCol).columnName);
            assert (gridSqlColumn != null);
            pkCols.add(gridSqlColumn.columnName());
        }
        int valColsNum = cols.size() - pkCols.size();
        if (valColsNum == 0) {
            throw new IgniteSQLException("No cache value related columns found");
        }
        res.columns(cols);
        res.primaryKeyColumns(pkCols);
        res.tableName(data.tableName);
        res.ifNotExists(CREATE_TABLE_IF_NOT_EXISTS.get(createTbl));
        ArrayList<String> arrayList = extraParams = data.tableEngineParams != null ? new ArrayList<String>() : null;
        if (data.tableEngineParams != null) {
            for (String s : data.tableEngineParams) {
                extraParams.addAll(F.asList((Object[])s.split(",")));
            }
        }
        res.params(extraParams);
        if (!F.isEmpty(extraParams)) {
            HashMap<String, String> params = new HashMap<String, String>();
            for (String string : extraParams) {
                String val;
                String[] parts = string.split(PARAM_NAME_VALUE_SEPARATOR);
                if (parts.length > 2) {
                    throw new IgniteSQLException("Invalid parameter (key[=value] expected): " + string, 1001);
                }
                String name = parts[0].trim().toUpperCase();
                String string2 = val = parts.length > 1 ? parts[1].trim() : null;
                if (F.isEmpty((String)name)) {
                    throw new IgniteSQLException("Invalid parameter (key[=value] expected): " + string, 1001);
                }
                if (params.put(name, val) == null) continue;
                throw new IgniteSQLException("Duplicate parameter: " + string, 1001);
            }
            for (Map.Entry entry : params.entrySet()) {
                GridSqlQueryParser.processExtraParam((String)entry.getKey(), (String)entry.getValue(), res);
            }
        }
        return res;
    }

    private GridSqlDropTable parseDropTable(DropTable dropTbl) {
        GridSqlDropTable res = new GridSqlDropTable();
        Schema schema = SCHEMA_COMMAND_SCHEMA.get((SchemaCommand)dropTbl);
        res.schemaName(schema.getName());
        res.ifExists(DROP_TABLE_IF_EXISTS.get(dropTbl));
        res.tableName(DROP_TABLE_NAME.get(dropTbl));
        return res;
    }

    private static void processExtraParam(String name, String val, GridSqlCreateTable res) {
        assert (!F.isEmpty((String)name));
        switch (name) {
            case "TEMPLATE": {
                GridSqlQueryParser.ensureNotEmpty(name, val);
                res.templateName(val);
                break;
            }
            case "BACKUPS": {
                GridSqlQueryParser.ensureNotEmpty(name, val);
                int backups = GridSqlQueryParser.parseIntParam(PARAM_BACKUPS, val);
                if (backups < 0) {
                    throw new IgniteSQLException("\"BACKUPS\" cannot be negative: " + backups, 1001);
                }
                res.backups(backups);
                break;
            }
            case "ATOMICITY": {
                CacheAtomicityMode mode;
                GridSqlQueryParser.ensureNotEmpty(name, val);
                if (CacheAtomicityMode.TRANSACTIONAL.name().equalsIgnoreCase(val)) {
                    mode = CacheAtomicityMode.TRANSACTIONAL;
                } else if (CacheAtomicityMode.ATOMIC.name().equalsIgnoreCase(val)) {
                    mode = CacheAtomicityMode.ATOMIC;
                } else {
                    throw new IgniteSQLException("Invalid value of \"ATOMICITY\" parameter (should be either TRANSACTIONAL or ATOMIC): " + val, 1001);
                }
                res.atomicityMode(mode);
                break;
            }
            case "CACHEGROUP": {
                GridSqlQueryParser.ensureNotEmpty(name, val);
                res.cacheGroup(val);
                break;
            }
            case "AFFINITYKEY": {
                GridSqlQueryParser.ensureNotEmpty(name, val);
                String affColName = null;
                if (val.startsWith("'")) {
                    if (val.length() == 1 || !val.endsWith("'")) {
                        throw new IgniteSQLException("Affinity key column name does not have trailing quote: " + val, 1001);
                    }
                    val = val.substring(1, val.length() - 1);
                    GridSqlQueryParser.ensureNotEmpty(name, val);
                    affColName = val;
                } else {
                    for (String colName : res.columns().keySet()) {
                        if (!val.equalsIgnoreCase(colName)) continue;
                        if (affColName != null) {
                            throw new IgniteSQLException("Ambiguous affinity column name, use single quotes for case sensitivity: " + val, 1001);
                        }
                        affColName = colName;
                    }
                }
                if (affColName == null || !res.columns().containsKey(affColName)) {
                    throw new IgniteSQLException("Affinity key column with given name not found: " + val, 1001);
                }
                if (!res.primaryKeyColumns().contains(affColName)) {
                    throw new IgniteSQLException("Affinity key column must be one of key columns: " + affColName, 1001);
                }
                res.affinityKey(affColName);
                break;
            }
            default: {
                throw new IgniteSQLException("Unsupported parameter: " + name, 1001);
            }
        }
    }

    private static void ensureNotEmpty(String name, String val) {
        if (F.isEmpty((String)val)) {
            throw new IgniteSQLException("Parameter value cannot be empty: " + name, 1001);
        }
    }

    private static int parseIntParam(String name, String val) {
        try {
            return Integer.parseInt(val);
        }
        catch (NumberFormatException e) {
            throw new IgniteSQLException("Parameter value must be an integer [name=" + name + ", value=" + val + ']', 1001);
        }
    }

    private void processSortOrder(SortOrder sortOrder, GridSqlQuery qry) {
        if (sortOrder == null) {
            return;
        }
        int[] indexes = sortOrder.getQueryColumnIndexes();
        int[] sortTypes = sortOrder.getSortTypes();
        for (int i = 0; i < indexes.length; ++i) {
            int colIdx = indexes[i];
            int type = sortTypes[i];
            qry.addSort(new GridSqlSortColumn(colIdx, (type & 1) == 0, (type & 2) != 0, (type & 4) != 0));
        }
    }

    public static Query query(Prepared qry) {
        if (qry instanceof Query) {
            return (Query)qry;
        }
        if (qry instanceof Explain) {
            return GridSqlQueryParser.query(EXPLAIN_COMMAND.get((Explain)qry));
        }
        throw new CacheException("Unsupported query: " + qry);
    }

    public final GridSqlStatement parse(Prepared stmt) {
        if (stmt instanceof Query) {
            if (this.optimizedTableFilterOrder != null) {
                this.collectOptimizedTableFiltersOrder((Query)stmt);
            }
            return this.parseQuery((Query)stmt);
        }
        if (stmt instanceof Merge) {
            return this.parseMerge((Merge)stmt);
        }
        if (stmt instanceof Insert) {
            return this.parseInsert((Insert)stmt);
        }
        if (stmt instanceof Delete) {
            return this.parseDelete((Delete)stmt);
        }
        if (stmt instanceof Update) {
            return this.parseUpdate((Update)stmt);
        }
        if (stmt instanceof Explain) {
            return this.parse(EXPLAIN_COMMAND.get((Explain)stmt)).explain(true);
        }
        if (stmt instanceof CreateIndex) {
            return this.parseCreateIndex((CreateIndex)stmt);
        }
        if (stmt instanceof DropIndex) {
            return this.parseDropIndex((DropIndex)stmt);
        }
        if (stmt instanceof CreateTable) {
            return this.parseCreateTable((CreateTable)stmt);
        }
        if (stmt instanceof DropTable) {
            return this.parseDropTable((DropTable)stmt);
        }
        throw new CacheException("Unsupported SQL statement: " + stmt);
    }

    private GridSqlQuery parseQuery(Query qry) {
        if (qry instanceof Select) {
            return this.parseSelect((Select)qry);
        }
        if (qry instanceof SelectUnion) {
            return this.parseUnion((SelectUnion)qry);
        }
        throw new UnsupportedOperationException("Unknown query type: " + qry);
    }

    private GridSqlUnion parseUnion(SelectUnion union) {
        GridSqlUnion res = (GridSqlUnion)this.h2ObjToGridObj.get(union);
        if (res != null) {
            return res;
        }
        res = new GridSqlUnion();
        res.right(this.parseQuery(union.getRight()));
        res.left(this.parseQuery(union.getLeft()));
        res.unionType(union.getUnionType());
        res.limit(this.parseExpression(union.getLimit(), false));
        res.offset(this.parseExpression(union.getOffset(), false));
        this.processSortOrder(UNION_SORT.get(union), res);
        this.h2ObjToGridObj.put(union, res);
        return res;
    }

    private GridSqlElement parseExpression(@Nullable Expression expression, boolean calcTypes) {
        if (expression == null) {
            return null;
        }
        GridSqlElement res = (GridSqlElement)this.h2ObjToGridObj.get(expression);
        if (res == null) {
            res = this.parseExpression0(expression, calcTypes);
            if (calcTypes) {
                res.resultType(GridSqlType.fromExpression(expression));
            }
            this.h2ObjToGridObj.put(expression, res);
        }
        return res;
    }

    private void collectOptimizedTableFiltersOrder(Query qry) {
        if (qry instanceof SelectUnion) {
            this.collectOptimizedTableFiltersOrder(((SelectUnion)qry).getLeft());
            this.collectOptimizedTableFiltersOrder(((SelectUnion)qry).getRight());
        } else {
            Select select = (Select)qry;
            TableFilter filter = select.getTopTableFilter();
            int i = 0;
            do {
                GridSqlQueryParser.assert0(filter != null, select);
                GridSqlQueryParser.assert0(filter.getNestedJoin() == null, select);
                this.optimizedTableFilterOrder.put(filter.getTableAlias(), i++);
                Table tbl = filter.getTable();
                if (!(tbl instanceof TableView)) continue;
                ViewIndex viewIdx = (ViewIndex)filter.getIndex();
                this.collectOptimizedTableFiltersOrder(viewIdx.getQuery());
            } while ((filter = filter.getJoin()) != null);
        }
    }

    private GridSqlElement parseExpression0(Expression expression, boolean calcTypes) {
        int typeId;
        if (expression instanceof ExpressionColumn) {
            ExpressionColumn expCol = (ExpressionColumn)expression;
            return new GridSqlColumn(expCol.getColumn(), this.parseTableFilter(expCol.getTableFilter()), SCHEMA_NAME.get(expCol), expCol.getOriginalTableAliasName(), expCol.getColumnName());
        }
        if (expression instanceof Alias) {
            return new GridSqlAlias(expression.getAlias(), this.parseExpression(expression.getNonAliasExpression(), calcTypes), true);
        }
        if (expression instanceof ValueExpression) {
            return expression == ValueExpression.getDefault() ? GridSqlKeyword.DEFAULT : new GridSqlConst(expression.getValue(null));
        }
        if (expression instanceof Operation) {
            Operation operation = (Operation)expression;
            Integer type = OPERATION_TYPE.get(operation);
            if (type == 5) {
                assert (OPERATION_RIGHT.get(operation) == null);
                return new GridSqlOperation(GridSqlOperationType.NEGATE, this.parseExpression(OPERATION_LEFT.get(operation), calcTypes));
            }
            return new GridSqlOperation(OPERATION_OP_TYPES[type], this.parseExpression(OPERATION_LEFT.get(operation), calcTypes), this.parseExpression(OPERATION_RIGHT.get(operation), calcTypes));
        }
        if (expression instanceof Comparison) {
            Comparison cmp = (Comparison)expression;
            GridSqlOperationType opType = COMPARISON_TYPES[COMPARISON_TYPE.get(cmp)];
            assert (opType != null) : COMPARISON_TYPE.get(cmp);
            Expression leftExp = COMPARISON_LEFT.get(cmp);
            GridSqlElement left = this.parseExpression(leftExp, calcTypes);
            if (opType.childrenCount() == 1) {
                return new GridSqlOperation(opType, left);
            }
            Expression rightExp = COMPARISON_RIGHT.get(cmp);
            GridSqlElement right = this.parseExpression(rightExp, calcTypes);
            return new GridSqlOperation(opType, left, right);
        }
        if (expression instanceof ConditionNot) {
            return new GridSqlOperation(GridSqlOperationType.NOT, this.parseExpression(expression.getNotIfPossible(null), calcTypes));
        }
        if (expression instanceof ConditionAndOr) {
            ConditionAndOr andOr = (ConditionAndOr)expression;
            int type = ANDOR_TYPE.get(andOr);
            assert (type == 0 || type == 1);
            return new GridSqlOperation(type == 0 ? GridSqlOperationType.AND : GridSqlOperationType.OR, this.parseExpression(ANDOR_LEFT.get(andOr), calcTypes), this.parseExpression(ANDOR_RIGHT.get(andOr), calcTypes));
        }
        if (expression instanceof Subquery) {
            Query qry = ((Subquery)expression).getQuery();
            return this.parseQueryExpression(qry);
        }
        if (expression instanceof ConditionIn) {
            GridSqlOperation res = new GridSqlOperation(GridSqlOperationType.IN);
            res.addChild(this.parseExpression(LEFT_CI.get((ConditionIn)expression), calcTypes));
            List<Expression> vals = VALUE_LIST_CI.get((ConditionIn)expression);
            for (Expression val : vals) {
                res.addChild(this.parseExpression(val, calcTypes));
            }
            return res;
        }
        if (expression instanceof ConditionInConstantSet) {
            GridSqlOperation res = new GridSqlOperation(GridSqlOperationType.IN);
            res.addChild(this.parseExpression(LEFT_CICS.get((ConditionInConstantSet)expression), calcTypes));
            List<Expression> vals = VALUE_LIST_CICS.get((ConditionInConstantSet)expression);
            for (Expression val : vals) {
                res.addChild(this.parseExpression(val, calcTypes));
            }
            return res;
        }
        if (expression instanceof ConditionInSelect) {
            GridSqlOperation res = new GridSqlOperation(GridSqlOperationType.IN);
            boolean all = ALL.get((ConditionInSelect)expression);
            int compareType = COMPARE_TYPE.get((ConditionInSelect)expression);
            GridSqlQueryParser.assert0(!all, expression);
            GridSqlQueryParser.assert0(compareType == 0, expression);
            res.addChild(this.parseExpression(LEFT_CIS.get((ConditionInSelect)expression), calcTypes));
            Query qry = QUERY_IN.get((ConditionInSelect)expression);
            res.addChild(this.parseQueryExpression(qry));
            return res;
        }
        if (expression instanceof CompareLike) {
            GridSqlQueryParser.assert0(ESCAPE.get((CompareLike)expression) == null, expression);
            boolean regexp = REGEXP_CL.get((CompareLike)expression);
            return new GridSqlOperation(regexp ? GridSqlOperationType.REGEXP : GridSqlOperationType.LIKE, this.parseExpression(LEFT.get((CompareLike)expression), calcTypes), this.parseExpression(RIGHT.get((CompareLike)expression), calcTypes));
        }
        if (expression instanceof Function) {
            Function f = (Function)expression;
            GridSqlFunction res = new GridSqlFunction(null, f.getName());
            if (f.getArgs() != null) {
                if (f.getFunctionType() == 223 || f.getFunctionType() == 224) {
                    Column[] cols = FUNC_TBL_COLS.get((TableFunction)f);
                    Expression[] args = f.getArgs();
                    assert (cols.length == args.length);
                    for (int i = 0; i < cols.length; ++i) {
                        GridSqlElement arg = this.parseExpression(args[i], calcTypes);
                        GridSqlAlias alias = new GridSqlAlias(cols[i].getName(), arg, false);
                        alias.resultType(GridSqlType.fromColumn(cols[i]));
                        res.addChild(alias);
                    }
                } else {
                    for (Expression arg : f.getArgs()) {
                        if (arg == null) {
                            if (f.getFunctionType() != 206) {
                                throw new IllegalStateException("Function type with null arg: " + f.getFunctionType());
                            }
                            res.addChild(GridSqlPlaceholder.EMPTY);
                            continue;
                        }
                        res.addChild(this.parseExpression(arg, calcTypes));
                    }
                }
            }
            if (f.getFunctionType() == 203 || f.getFunctionType() == 202) {
                res.resultType(GridSqlType.fromExpression((Expression)f));
            }
            return res;
        }
        if (expression instanceof JavaFunction) {
            JavaFunction f = (JavaFunction)expression;
            FunctionAlias alias = FUNC_ALIAS.get(f);
            GridSqlFunction res = new GridSqlFunction(alias.getSchema().getName(), f.getName());
            if (f.getArgs() != null) {
                for (Expression arg : f.getArgs()) {
                    res.addChild(this.parseExpression(arg, calcTypes));
                }
            }
            return res;
        }
        if (expression instanceof Parameter) {
            return new GridSqlParameter(((Parameter)expression).getIndex());
        }
        if (expression instanceof Aggregate && GridSqlAggregateFunction.isValidType(typeId = TYPE.get((Aggregate)expression).intValue())) {
            GridSqlAggregateFunction res = new GridSqlAggregateFunction((boolean)DISTINCT.get((Aggregate)expression), typeId);
            Expression on = ON.get((Aggregate)expression);
            if (on != null) {
                res.addChild(this.parseExpression(on, calcTypes));
            }
            return res;
        }
        if (expression instanceof ExpressionList) {
            Expression[] exprs = EXPR_LIST.get((ExpressionList)expression);
            GridSqlArray res = new GridSqlArray(exprs.length);
            for (Expression expr : exprs) {
                res.addChild(this.parseExpression(expr, calcTypes));
            }
            return res;
        }
        if (expression instanceof ConditionExists) {
            Query qry = QUERY_EXISTS.get((ConditionExists)expression);
            GridSqlOperation res = new GridSqlOperation(GridSqlOperationType.EXISTS);
            res.addChild(this.parseQueryExpression(qry));
            return res;
        }
        throw new IgniteException("Unsupported expression: " + expression + " [type=" + expression.getClass().getSimpleName() + ']');
    }

    private static void assert0(boolean cond, Object o) {
        if (!cond) {
            throw new IgniteException("Unsupported query: " + o);
        }
    }

    private static <T, R> Getter<T, R> getter(Class<? extends T> cls, String fldName) {
        Field field;
        try {
            field = cls.getDeclaredField(fldName);
        }
        catch (NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
        field.setAccessible(true);
        return new Getter(field);
    }

    public static class Getter<T, R> {
        private final Field fld;

        private Getter(Field fld) {
            this.fld = fld;
        }

        public R get(T obj) {
            try {
                return (R)this.fld.get(obj);
            }
            catch (IllegalAccessException e) {
                throw new IgniteException((Throwable)e);
            }
        }
    }
}

