/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.h2.opt;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteInterruptedException;
import org.apache.ignite.cache.CacheMode;
import org.apache.ignite.internal.processors.cache.CacheObject;
import org.apache.ignite.internal.processors.cache.GridCacheContext;
import org.apache.ignite.internal.processors.cache.KeyCacheObject;
import org.apache.ignite.internal.processors.cache.query.QueryTable;
import org.apache.ignite.internal.processors.cache.version.GridCacheVersion;
import org.apache.ignite.internal.processors.query.h2.database.H2RowFactory;
import org.apache.ignite.internal.processors.query.h2.database.H2TreeIndex;
import org.apache.ignite.internal.processors.query.h2.opt.GridH2AbstractKeyValueRow;
import org.apache.ignite.internal.processors.query.h2.opt.GridH2IndexBase;
import org.apache.ignite.internal.processors.query.h2.opt.GridH2PrimaryScanIndex;
import org.apache.ignite.internal.processors.query.h2.opt.GridH2ProxyIndex;
import org.apache.ignite.internal.processors.query.h2.opt.GridH2ProxySpatialIndex;
import org.apache.ignite.internal.processors.query.h2.opt.GridH2Row;
import org.apache.ignite.internal.processors.query.h2.opt.GridH2RowDescriptor;
import org.apache.ignite.internal.processors.query.h2.opt.GridH2SystemIndexFactory;
import org.apache.ignite.internal.util.offheap.unsafe.GridUnsafeMemory;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.lang.IgniteBiTuple;
import org.h2.command.ddl.CreateTableData;
import org.h2.engine.Session;
import org.h2.engine.SysProperties;
import org.h2.index.Index;
import org.h2.index.IndexType;
import org.h2.index.SpatialIndex;
import org.h2.message.DbException;
import org.h2.result.Row;
import org.h2.result.SearchRow;
import org.h2.schema.SchemaObject;
import org.h2.table.IndexColumn;
import org.h2.table.Table;
import org.h2.table.TableBase;
import org.h2.table.TableType;
import org.h2.value.Value;
import org.jetbrains.annotations.Nullable;
import org.jsr166.ConcurrentHashMap8;
import org.jsr166.LongAdder8;

public class GridH2Table
extends TableBase {
    private final GridCacheContext cctx;
    private final GridH2RowDescriptor desc;
    private volatile ArrayList<Index> idxs;
    private final int pkIndexPos;
    private final int sysIdxsCnt;
    private final Map<String, GridH2IndexBase> tmpIdxs = new HashMap<String, GridH2IndexBase>();
    private final ReadWriteLock lock;
    private boolean destroyed;
    private final ConcurrentMap<Session, Boolean> sessions = new ConcurrentHashMap8();
    private IndexColumn affKeyCol;
    private final LongAdder8 size = new LongAdder8();
    private final H2RowFactory rowFactory;
    private volatile boolean rebuildFromHashInProgress;
    private final QueryTable identifier;
    private final String identifierStr;
    private volatile boolean rmIndex;

    public GridH2Table(CreateTableData createTblData, GridH2RowDescriptor desc, H2RowFactory rowFactory, GridH2SystemIndexFactory idxsFactory, GridCacheContext cctx) {
        super(createTblData);
        boolean hasHashIndex;
        assert (idxsFactory != null);
        this.desc = desc;
        this.cctx = cctx;
        if (desc.context() != null && !desc.context().customAffinityMapper()) {
            boolean affinityColExists = true;
            String affKey = desc.type().affinityKey();
            int affKeyColId = -1;
            if (affKey != null) {
                if (this.doesColumnExist(affKey)) {
                    affKeyColId = this.getColumn(affKey).getColumnId();
                } else {
                    affinityColExists = false;
                }
            } else {
                affKeyColId = 0;
            }
            if (affinityColExists) {
                this.affKeyCol = this.indexColumn(affKeyColId, 0);
                assert (this.affKeyCol != null);
            }
        }
        this.rowFactory = rowFactory;
        this.identifier = new QueryTable(this.getSchema().getName(), this.getName());
        this.identifierStr = this.identifier.schema() + "." + this.identifier.table();
        this.idxs = idxsFactory.createSystemIndexes(this);
        assert (this.idxs != null);
        ArrayList<Index> clones = new ArrayList<Index>(this.idxs.size());
        for (Index index : this.idxs) {
            Index clone = this.createDuplicateIndexIfNeeded(index);
            if (clone == null) continue;
            clones.add(clone);
        }
        this.idxs.addAll(clones);
        boolean bl = hasHashIndex = this.idxs.size() >= 2 && this.index(0).getIndexType().isHash();
        if (hasHashIndex) {
            this.idxs.add(0, (Index)new GridH2PrimaryScanIndex(this, this.index(1), this.index(0)));
        } else {
            this.idxs.add(0, (Index)new GridH2PrimaryScanIndex(this, this.index(0), null));
        }
        this.pkIndexPos = hasHashIndex ? 2 : 1;
        this.sysIdxsCnt = this.idxs.size();
        this.lock = new ReentrantReadWriteLock();
    }

    public boolean isPartitioned() {
        return this.desc != null && this.desc.context().config().getCacheMode() == CacheMode.PARTITIONED;
    }

    @Nullable
    public IndexColumn getAffinityKeyColumn() {
        return this.affKeyCol;
    }

    public long getDiskSpaceUsed() {
        return 0L;
    }

    public GridH2RowDescriptor rowDescriptor() {
        return this.desc;
    }

    public String cacheName() {
        return this.cctx.name();
    }

    public GridCacheContext cache() {
        return this.cctx;
    }

    public boolean lock(Session ses, boolean exclusive, boolean force) {
        Boolean putRes = this.sessions.putIfAbsent(ses, exclusive);
        if (putRes != null) {
            return putRes;
        }
        ses.addLock((Table)this);
        this.lock(exclusive);
        if (this.destroyed) {
            this.unlock(exclusive);
            throw new IllegalStateException("Table " + this.identifierString() + " already destroyed.");
        }
        return false;
    }

    public QueryTable identifier() {
        return this.identifier;
    }

    public String identifierString() {
        return this.identifierStr;
    }

    private void lock(boolean exclusive) {
        Lock l = exclusive ? this.lock.writeLock() : this.lock.readLock();
        try {
            l.lockInterruptibly();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new IgniteInterruptedException("Thread got interrupted while trying to acquire table lock.", e);
        }
    }

    private void unlock(boolean exclusive) {
        Lock l = exclusive ? this.lock.writeLock() : this.lock.readLock();
        l.unlock();
    }

    private void ensureNotDestroyed() {
        if (this.destroyed) {
            throw new IllegalStateException("Table " + this.identifierString() + " already destroyed.");
        }
    }

    public void close(Session ses) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeChildrenAndResources(Session ses) {
        this.lock(true);
        try {
            super.removeChildrenAndResources(ses);
            while (this.idxs.size() > this.sysIdxsCnt) {
                Index idx = this.idxs.get(this.sysIdxsCnt);
                if (idx.getName() == null || idx.getSchema().findIndex(ses, idx.getName()) != idx) continue;
                this.database.removeSchemaObject(ses, (SchemaObject)idx);
                if (!(idx instanceof GridH2IndexBase)) continue;
                ((GridH2IndexBase)idx).destroy(this.rmIndex);
            }
            if (SysProperties.CHECK) {
                for (SchemaObject obj : this.database.getAllSchemaObjects(1)) {
                    Index idx = (Index)obj;
                    if (idx.getTable() != this) continue;
                    DbException.throwInternalError((String)("index not dropped: " + idx.getName()));
                }
            }
            this.database.removeMeta(ses, this.getId());
            this.invalidate();
        }
        finally {
            this.unlock(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        this.lock(true);
        try {
            this.ensureNotDestroyed();
            assert (this.sessions.isEmpty()) : this.sessions;
            this.destroyed = true;
            int len = this.idxs.size();
            for (int i = 1; i < len; ++i) {
                if (!(this.idxs.get(i) instanceof GridH2IndexBase)) continue;
                this.index(i).destroy(this.rmIndex);
            }
        }
        finally {
            this.unlock(true);
        }
    }

    public void setRemoveIndexOnDestroy(boolean rmIndex) {
        this.rmIndex = rmIndex;
    }

    public void unlock(Session ses) {
        Boolean exclusive = (Boolean)this.sessions.remove(ses);
        if (exclusive == null) {
            return;
        }
        this.unlock(exclusive);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean update(KeyCacheObject key, int partId, CacheObject val, GridCacheVersion ver, long expirationTime, boolean rmv, long link) throws IgniteCheckedException {
        assert (this.desc != null);
        GridH2Row row = this.desc.createRow(key, partId, val, ver, expirationTime);
        row.link = link;
        if (!rmv) {
            ((GridH2AbstractKeyValueRow)row).valuesCache(new Value[this.getColumns().length]);
        }
        try {
            boolean bl = this.doUpdate(row, rmv);
            return bl;
        }
        finally {
            if (!rmv) {
                ((GridH2AbstractKeyValueRow)row).valuesCache(null);
            }
        }
    }

    public IgniteBiTuple<CacheObject, GridCacheVersion> read(GridCacheContext cctx, KeyCacheObject key, int partId) throws IgniteCheckedException {
        assert (this.desc != null);
        GridH2Row row = this.desc.createRow(key, partId, null, null, 0L);
        GridH2IndexBase primaryIdx = this.pk();
        GridH2Row res = primaryIdx.findOne(row);
        return res != null ? F.t((Object)res.val, (Object)res.ver) : null;
    }

    private GridH2IndexBase index(int idx) {
        return (GridH2IndexBase)this.idxs.get(idx);
    }

    private GridH2IndexBase pk() {
        return (GridH2IndexBase)this.idxs.get(2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean doUpdate(GridH2Row row, boolean del) throws IgniteCheckedException {
        GridUnsafeMemory mem = this.desc == null ? null : this.desc.memory();
        this.lock(false);
        if (mem != null) {
            this.desc.guard().begin();
        }
        try {
            GridH2Row old;
            this.ensureNotDestroyed();
            GridH2IndexBase pk = this.pk();
            if (!del) {
                assert (this.rowFactory == null || row.link != 0L) : row;
                old = pk.put(row);
                if (old == null) {
                    this.size.increment();
                }
                int len = this.idxs.size();
                int i = this.pkIndexPos;
                while (++i < len) {
                    if (!(this.idxs.get(i) instanceof GridH2IndexBase)) continue;
                    GridH2IndexBase idx = this.index(i);
                    this.addToIndex(idx, (Index)pk, row, old, false);
                }
                for (GridH2IndexBase idx : this.tmpIdxs.values()) {
                    this.addToIndex(idx, (Index)pk, row, old, true);
                }
            } else {
                old = pk.remove(row);
                if (old != null) {
                    int len = this.idxs.size();
                    for (int i = this.pkIndexPos + 1; i < len; ++i) {
                        if (!(this.idxs.get(i) instanceof GridH2IndexBase)) continue;
                        GridH2Row res = this.index(i).remove(old);
                        assert (GridH2Table.eq((Index)pk, res, old)) : "\n" + old + "\n" + res + "\n" + i + " -> " + this.index(i).getName();
                    }
                    for (GridH2IndexBase idx : this.tmpIdxs.values()) {
                        idx.remove(old);
                    }
                    this.size.decrement();
                } else {
                    boolean bl = false;
                    return bl;
                }
            }
            boolean bl = true;
            return bl;
        }
        finally {
            this.unlock(false);
            if (mem != null) {
                this.desc.guard().end();
            }
        }
    }

    private void addToIndex(GridH2IndexBase idx, Index pk, GridH2Row row, GridH2Row old, boolean tmp) {
        assert (!idx.getIndexType().isUnique()) : "Unique indexes are not supported: " + (Object)((Object)idx);
        GridH2Row old2 = idx.put(row);
        if (old2 != null) {
            if (!tmp && !GridH2Table.eq(pk, old2, old)) {
                throw new IllegalStateException("Row conflict should never happen, unique indexes are not supported [idx=" + (Object)((Object)idx) + ", old=" + old + ", old2=" + old2 + ']');
            }
        } else if (old != null) {
            idx.removex(old);
        }
    }

    private static boolean eq(Index pk, SearchRow r1, SearchRow r2) {
        return r1 == r2 || r1 != null && r2 != null && pk.compareRows(r1, r2) == 0;
    }

    ArrayList<GridH2IndexBase> indexes() {
        ArrayList<GridH2IndexBase> res = new ArrayList<GridH2IndexBase>(this.idxs.size() - 2);
        int len = this.idxs.size();
        for (int i = this.pkIndexPos; i < len; ++i) {
            if (!(this.idxs.get(i) instanceof GridH2IndexBase)) continue;
            res.add(this.index(i));
        }
        return res;
    }

    public void markRebuildFromHashInProgress(boolean value) {
        assert (!value || this.idxs.size() >= 2 && this.index(1).getIndexType().isHash()) : "Table has no hash index.";
        this.rebuildFromHashInProgress = value;
    }

    public boolean rebuildFromHashInProgress() {
        return this.rebuildFromHashInProgress;
    }

    public Index addIndex(Session ses, String idxName, int idxId, IndexColumn[] cols, IndexType idxType, boolean create, String idxComment) {
        return this.commitUserIndex(ses, idxName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void proposeUserIndex(Index idx) throws IgniteCheckedException {
        assert (idx instanceof GridH2IndexBase);
        this.lock(true);
        try {
            this.ensureNotDestroyed();
            for (Index oldIdx : this.idxs) {
                if (!F.eq((Object)oldIdx.getName(), (Object)idx.getName())) continue;
                throw new IgniteCheckedException("Index already exists: " + idx.getName());
            }
            Index oldTmpIdx = (Index)this.tmpIdxs.put(idx.getName(), (GridH2IndexBase)idx);
            assert (oldTmpIdx == null);
        }
        finally {
            this.unlock(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Index commitUserIndex(Session ses, String idxName) {
        this.lock(true);
        try {
            this.ensureNotDestroyed();
            Index idx = (Index)this.tmpIdxs.remove(idxName);
            assert (idx != null);
            Index cloneIdx = this.createDuplicateIndexIfNeeded(idx);
            ArrayList<Index> newIdxs = new ArrayList<Index>(this.idxs.size() + (cloneIdx == null ? 1 : 2));
            newIdxs.addAll(this.idxs);
            newIdxs.add(idx);
            if (cloneIdx != null) {
                newIdxs.add(cloneIdx);
            }
            this.idxs = newIdxs;
            this.database.addSchemaObject(ses, (SchemaObject)idx);
            if (cloneIdx != null) {
                this.database.addSchemaObject(ses, (SchemaObject)cloneIdx);
            }
            this.setModified();
            Index index = idx;
            return index;
        }
        finally {
            this.unlock(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rollbackUserIndex(String idxName) {
        this.lock(true);
        try {
            this.ensureNotDestroyed();
            GridH2IndexBase rmvIdx = this.tmpIdxs.remove(idxName);
            assert (rmvIdx != null);
        }
        finally {
            this.unlock(true);
        }
    }

    public boolean containsUserIndex(String idxName) {
        for (int i = 2; i < this.idxs.size(); ++i) {
            Index idx = this.idxs.get(i);
            if (!idx.getName().equalsIgnoreCase(idxName)) continue;
            return true;
        }
        return false;
    }

    public void removeIndex(Index h2Idx) {
        throw DbException.getUnsupportedException((String)"must use removeIndex(session, idx)");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeIndex(Session session, Index h2Idx) {
        this.lock(true);
        try {
            ArrayList<Index> idxs = new ArrayList<Index>(this.idxs);
            Index targetIdx = h2Idx instanceof GridH2ProxyIndex ? ((GridH2ProxyIndex)h2Idx).underlyingIndex() : h2Idx;
            int i = this.pkIndexPos;
            while (i < idxs.size()) {
                Index idx = idxs.get(i);
                if (idx == targetIdx || idx instanceof GridH2ProxyIndex && ((GridH2ProxyIndex)idx).underlyingIndex() == targetIdx) {
                    idxs.remove(i);
                    if (!(idx instanceof GridH2ProxyIndex) || idx.getSchema().findIndex(session, idx.getName()) == null) continue;
                    this.database.removeSchemaObject(session, (SchemaObject)idx);
                    continue;
                }
                ++i;
            }
            this.idxs = idxs;
        }
        finally {
            this.unlock(true);
        }
    }

    public void removeRow(Session ses, Row row) {
        throw DbException.getUnsupportedException((String)"removeRow");
    }

    public void truncate(Session ses) {
        throw DbException.getUnsupportedException((String)"truncate");
    }

    public void addRow(Session ses, Row row) {
        throw DbException.getUnsupportedException((String)"addRow");
    }

    public void checkSupportAlter() {
        throw DbException.getUnsupportedException((String)"alter");
    }

    public TableType getTableType() {
        return TableType.EXTERNAL_TABLE_ENGINE;
    }

    public Index getScanIndex(Session ses) {
        return this.getIndexes().get(0);
    }

    public Index getUniqueIndex() {
        if (this.rebuildFromHashInProgress) {
            return this.index(1);
        }
        return this.index(2);
    }

    public ArrayList<Index> getIndexes() {
        if (!this.rebuildFromHashInProgress) {
            return this.idxs;
        }
        ArrayList<Index> idxs = new ArrayList<Index>(2);
        idxs.add(this.idxs.get(0));
        idxs.add(this.idxs.get(1));
        return idxs;
    }

    public ArrayList<Index> getAllIndexes() {
        return this.idxs;
    }

    public boolean isLockedExclusively() {
        return false;
    }

    public boolean isLockedExclusivelyBy(Session ses) {
        return false;
    }

    public long getMaxDataModificationId() {
        return 0L;
    }

    public boolean isDeterministic() {
        return true;
    }

    public boolean canGetRowCount() {
        return true;
    }

    public boolean canDrop() {
        return true;
    }

    public long getRowCount(@Nullable Session ses) {
        return this.getUniqueIndex().getRowCount(ses);
    }

    public long getRowCountApproximation() {
        return this.size.longValue();
    }

    public void checkRename() {
        throw DbException.getUnsupportedException((String)"rename");
    }

    public IndexColumn indexColumn(int col, int sorting) {
        IndexColumn res = new IndexColumn();
        res.column = this.getColumn(col);
        res.columnName = res.column.getName();
        res.sortType = sorting;
        return res;
    }

    public H2RowFactory rowFactory() {
        return this.rowFactory;
    }

    public Index createDuplicateIndexIfNeeded(Index target) {
        if (!(target instanceof H2TreeIndex) && !(target instanceof SpatialIndex)) {
            return null;
        }
        IndexColumn[] cols = target.getIndexColumns();
        ArrayList<IndexColumn> proxyCols = new ArrayList<IndexColumn>(cols.length);
        boolean modified = false;
        for (IndexColumn col : cols) {
            IndexColumn proxyCol = new IndexColumn();
            proxyCol.columnName = col.columnName;
            proxyCol.column = col.column;
            proxyCol.sortType = col.sortType;
            int altColId = this.desc.getAlternativeColumnId(proxyCol.column.getColumnId());
            if (altColId != proxyCol.column.getColumnId()) {
                proxyCol.column = this.getColumn(altColId);
                proxyCol.columnName = proxyCol.column.getName();
                modified = true;
            }
            proxyCols.add(proxyCol);
        }
        if (modified) {
            String proxyName = target.getName() + "_proxy";
            if (target.getIndexType().isSpatial()) {
                return new GridH2ProxySpatialIndex(this, proxyName, proxyCols, target);
            }
            return new GridH2ProxyIndex(this, proxyName, proxyCols, target);
        }
        return null;
    }
}

