/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.h2.ddl;

import java.sql.PreparedStatement;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.cache.QueryEntity;
import org.apache.ignite.cache.QueryIndex;
import org.apache.ignite.cache.query.FieldsQueryCursor;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.processors.cache.QueryCursorImpl;
import org.apache.ignite.internal.processors.query.GridQueryProperty;
import org.apache.ignite.internal.processors.query.GridQueryTypeDescriptor;
import org.apache.ignite.internal.processors.query.IgniteSQLException;
import org.apache.ignite.internal.processors.query.QueryUtils;
import org.apache.ignite.internal.processors.query.h2.IgniteH2Indexing;
import org.apache.ignite.internal.processors.query.h2.opt.GridH2Table;
import org.apache.ignite.internal.processors.query.h2.sql.GridSqlColumn;
import org.apache.ignite.internal.processors.query.h2.sql.GridSqlCreateIndex;
import org.apache.ignite.internal.processors.query.h2.sql.GridSqlCreateTable;
import org.apache.ignite.internal.processors.query.h2.sql.GridSqlDropIndex;
import org.apache.ignite.internal.processors.query.h2.sql.GridSqlDropTable;
import org.apache.ignite.internal.processors.query.h2.sql.GridSqlQueryParser;
import org.apache.ignite.internal.processors.query.h2.sql.GridSqlStatement;
import org.apache.ignite.internal.processors.query.schema.SchemaOperationException;
import org.apache.ignite.internal.util.future.GridFinishedFuture;
import org.apache.ignite.internal.util.typedef.F;
import org.h2.command.Prepared;
import org.h2.command.ddl.CreateIndex;
import org.h2.command.ddl.CreateTable;
import org.h2.command.ddl.DropIndex;
import org.h2.command.ddl.DropTable;
import org.h2.jdbc.JdbcPreparedStatement;
import org.h2.table.Column;
import org.h2.value.DataType;

public class DdlStatementsProcessor {
    GridKernalContext ctx;
    IgniteH2Indexing idx;

    public void start(GridKernalContext ctx, IgniteH2Indexing idx) {
        this.ctx = ctx;
        this.idx = idx;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public FieldsQueryCursor<List<?>> runDdlStatement(String sql, PreparedStatement stmt) throws IgniteCheckedException {
        assert (stmt instanceof JdbcPreparedStatement);
        GridFinishedFuture fut = null;
        try {
            GridSqlStatement cmd;
            GridSqlStatement stmt0 = new GridSqlQueryParser(false).parse(GridSqlQueryParser.prepared(stmt));
            if (stmt0 instanceof GridSqlCreateIndex) {
                cmd = (GridSqlCreateIndex)stmt0;
                GridH2Table tbl = this.idx.dataTable(((GridSqlCreateIndex)cmd).schemaName(), ((GridSqlCreateIndex)cmd).tableName());
                if (tbl == null) {
                    throw new SchemaOperationException(2, ((GridSqlCreateIndex)cmd).tableName());
                }
                assert (tbl.rowDescriptor() != null);
                QueryIndex newIdx = new QueryIndex();
                newIdx.setName(((GridSqlCreateIndex)cmd).index().getName());
                newIdx.setIndexType(((GridSqlCreateIndex)cmd).index().getIndexType());
                LinkedHashMap flds = new LinkedHashMap();
                GridQueryTypeDescriptor typeDesc = tbl.rowDescriptor().type();
                for (Map.Entry e : ((GridSqlCreateIndex)cmd).index().getFields().entrySet()) {
                    GridQueryProperty prop = typeDesc.property((String)e.getKey());
                    if (prop == null) {
                        throw new SchemaOperationException(4, (String)e.getKey());
                    }
                    flds.put(prop.name(), e.getValue());
                }
                newIdx.setFields(flds);
                fut = this.ctx.query().dynamicIndexCreate(tbl.cacheName(), ((GridSqlCreateIndex)cmd).schemaName(), typeDesc.tableName(), newIdx, ((GridSqlCreateIndex)cmd).ifNotExists());
            } else if (stmt0 instanceof GridSqlDropIndex) {
                cmd = (GridSqlDropIndex)stmt0;
                GridH2Table tbl = this.idx.dataTableForIndex(((GridSqlDropIndex)cmd).schemaName(), ((GridSqlDropIndex)cmd).indexName());
                if (tbl != null) {
                    fut = this.ctx.query().dynamicIndexDrop(tbl.cacheName(), ((GridSqlDropIndex)cmd).schemaName(), ((GridSqlDropIndex)cmd).indexName(), ((GridSqlDropIndex)cmd).ifExists());
                } else {
                    if (!((GridSqlDropIndex)cmd).ifExists()) throw new SchemaOperationException(6, ((GridSqlDropIndex)cmd).indexName());
                    fut = new GridFinishedFuture();
                }
            } else if (stmt0 instanceof GridSqlCreateTable) {
                cmd = (GridSqlCreateTable)stmt0;
                if (!F.eq((Object)"PUBLIC", (Object)((GridSqlCreateTable)cmd).schemaName())) {
                    throw new SchemaOperationException("CREATE TABLE can only be executed on PUBLIC schema.");
                }
                GridH2Table tbl = this.idx.dataTable(((GridSqlCreateTable)cmd).schemaName(), ((GridSqlCreateTable)cmd).tableName());
                if (tbl != null) {
                    if (!((GridSqlCreateTable)cmd).ifNotExists()) {
                        throw new SchemaOperationException(3, ((GridSqlCreateTable)cmd).tableName());
                    }
                } else {
                    QueryEntity e = DdlStatementsProcessor.toQueryEntity((GridSqlCreateTable)cmd);
                    CacheConfiguration ccfg = new CacheConfiguration(((GridSqlCreateTable)cmd).tableName());
                    ccfg.setQueryEntities(Collections.singleton(e));
                    ccfg.setSqlSchema(((GridSqlCreateTable)cmd).schemaName());
                    SchemaOperationException err = QueryUtils.checkQueryEntityConflicts((CacheConfiguration)ccfg, this.ctx.cache().cacheDescriptors().values());
                    if (err != null) {
                        throw err;
                    }
                    this.ctx.query().dynamicTableCreate(((GridSqlCreateTable)cmd).schemaName(), e, ((GridSqlCreateTable)cmd).templateName(), ((GridSqlCreateTable)cmd).cacheGroup(), ((GridSqlCreateTable)cmd).affinityKey(), ((GridSqlCreateTable)cmd).atomicityMode(), ((GridSqlCreateTable)cmd).backups(), ((GridSqlCreateTable)cmd).ifNotExists());
                }
            } else {
                if (!(stmt0 instanceof GridSqlDropTable)) throw new IgniteSQLException("Unsupported DDL operation: " + sql, 1002);
                cmd = (GridSqlDropTable)stmt0;
                if (!F.eq((Object)"PUBLIC", (Object)((GridSqlDropTable)cmd).schemaName())) {
                    throw new SchemaOperationException("DROP TABLE can only be executed on PUBLIC schema.");
                }
                GridH2Table tbl = this.idx.dataTable(((GridSqlDropTable)cmd).schemaName(), ((GridSqlDropTable)cmd).tableName());
                if (tbl == null && ((GridSqlDropTable)cmd).ifExists()) {
                    this.ctx.cache().createMissingQueryCaches();
                    tbl = this.idx.dataTable(((GridSqlDropTable)cmd).schemaName(), ((GridSqlDropTable)cmd).tableName());
                }
                if (tbl == null) {
                    if (!((GridSqlDropTable)cmd).ifExists()) {
                        throw new SchemaOperationException(2, ((GridSqlDropTable)cmd).tableName());
                    }
                } else {
                    this.ctx.query().dynamicTableDrop(tbl.cacheName(), ((GridSqlDropTable)cmd).tableName(), ((GridSqlDropTable)cmd).ifExists());
                }
            }
            if (fut != null) {
                fut.get();
            }
            QueryCursorImpl resCur = new QueryCursorImpl(Collections.singletonList(Collections.singletonList(0L)), null, false);
            resCur.fieldsMeta(IgniteH2Indexing.UPDATE_RESULT_META);
            return resCur;
        }
        catch (SchemaOperationException e) {
            throw this.convert(e);
        }
        catch (IgniteSQLException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IgniteSQLException("Unexpected DLL operation failure: " + e.getMessage(), (Throwable)e);
        }
    }

    private IgniteSQLException convert(SchemaOperationException e) {
        int sqlCode;
        switch (e.code()) {
            case 1: {
                sqlCode = 4006;
                break;
            }
            case 2: {
                sqlCode = 3001;
                break;
            }
            case 3: {
                sqlCode = 3007;
                break;
            }
            case 4: {
                sqlCode = 3008;
                break;
            }
            case 5: {
                sqlCode = 3009;
                break;
            }
            case 6: {
                sqlCode = 3006;
                break;
            }
            case 7: {
                sqlCode = 3005;
                break;
            }
            default: {
                sqlCode = 1;
            }
        }
        return new IgniteSQLException(e.getMessage(), sqlCode);
    }

    private static QueryEntity toQueryEntity(GridSqlCreateTable createTbl) {
        QueryEntity res = new QueryEntity();
        res.setTableName(createTbl.tableName());
        for (Map.Entry<String, GridSqlColumn> e : createTbl.columns().entrySet()) {
            GridSqlColumn gridCol = e.getValue();
            Column col = gridCol.column();
            res.addQueryField(e.getKey(), DataType.getTypeClassName((int)col.getType()), null);
        }
        String valTypeName = QueryUtils.createTableValueTypeName((String)createTbl.schemaName(), (String)createTbl.tableName());
        String keyTypeName = QueryUtils.createTableKeyTypeName((String)valTypeName);
        res.setValueType(valTypeName);
        res.setKeyType(keyTypeName);
        res.setKeyFields(createTbl.primaryKeyColumns());
        return res;
    }

    public static boolean isDdlStatement(Prepared cmd) {
        return cmd instanceof CreateIndex || cmd instanceof DropIndex || cmd instanceof CreateTable || cmd instanceof DropTable;
    }
}

