/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.h2.database;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import org.apache.ignite.internal.pagemem.PageUtils;
import org.h2.value.Value;
import org.h2.value.ValueBoolean;
import org.h2.value.ValueByte;
import org.h2.value.ValueBytes;
import org.h2.value.ValueDate;
import org.h2.value.ValueDouble;
import org.h2.value.ValueFloat;
import org.h2.value.ValueInt;
import org.h2.value.ValueLong;
import org.h2.value.ValueNull;
import org.h2.value.ValueShort;
import org.h2.value.ValueString;
import org.h2.value.ValueStringFixed;
import org.h2.value.ValueStringIgnoreCase;
import org.h2.value.ValueTime;
import org.h2.value.ValueTimestamp;
import org.h2.value.ValueUuid;

public class InlineIndexHelper {
    private static final Charset CHARSET = StandardCharsets.UTF_8;
    private static final ThreadLocal<List<InlineIndexHelper>> currentIndex = new ThreadLocal();
    public static final List<Integer> AVAILABLE_TYPES = Arrays.asList(1, 2, 3, 4, 5, 5, 8, 7, 10, 9, 11, 20, 13, 21, 14, 12);
    private final int type;
    private final int colIdx;
    private final int sortType;
    private final short size;

    public InlineIndexHelper(int type, int colIdx, int sortType) {
        this.type = type;
        this.colIdx = colIdx;
        this.sortType = sortType;
        switch (type) {
            case 1: 
            case 2: {
                this.size = 1;
                break;
            }
            case 3: {
                this.size = (short)2;
                break;
            }
            case 4: {
                this.size = (short)4;
                break;
            }
            case 5: {
                this.size = (short)8;
                break;
            }
            case 8: {
                this.size = (short)4;
                break;
            }
            case 7: {
                this.size = (short)8;
                break;
            }
            case 10: {
                this.size = (short)8;
                break;
            }
            case 9: {
                this.size = (short)8;
                break;
            }
            case 11: {
                this.size = (short)16;
                break;
            }
            case 20: {
                this.size = (short)16;
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 21: {
                this.size = (short)-1;
                break;
            }
            default: {
                throw new UnsupportedOperationException("no get operation for fast index type " + type);
            }
        }
    }

    public int type() {
        return this.type;
    }

    public int columnIndex() {
        return this.colIdx;
    }

    public int sortType() {
        return this.sortType;
    }

    public static List<InlineIndexHelper> getCurrentInlineIndexes() {
        return currentIndex.get();
    }

    public static void setCurrentInlineIndexes(List<InlineIndexHelper> inlineIdxs) {
        currentIndex.set(inlineIdxs);
    }

    public static void clearCurrentInlineIndexes() {
        currentIndex.remove();
    }

    public short size() {
        return this.size;
    }

    public int fullSize(long pageAddr, int off) {
        byte type = PageUtils.getByte((long)pageAddr, (int)off);
        if (type == 0) {
            return 1;
        }
        if (this.size > 0) {
            return this.size + 1;
        }
        return PageUtils.getShort((long)pageAddr, (int)(off + 1)) + 3;
    }

    public Value get(long pageAddr, int off, int maxSize) {
        if (this.size > 0 && this.size + 1 > maxSize) {
            return null;
        }
        if (maxSize < 1) {
            return null;
        }
        byte type = PageUtils.getByte((long)pageAddr, (int)off);
        if (type == -1) {
            return null;
        }
        if (type == 0) {
            return ValueNull.INSTANCE;
        }
        if (this.type != type) {
            throw new UnsupportedOperationException("invalid fast index type " + type);
        }
        switch (this.type) {
            case 1: {
                return ValueBoolean.get((PageUtils.getByte((long)pageAddr, (int)(off + 1)) != 0 ? 1 : 0) != 0);
            }
            case 2: {
                return ValueByte.get((byte)PageUtils.getByte((long)pageAddr, (int)(off + 1)));
            }
            case 3: {
                return ValueShort.get((short)PageUtils.getShort((long)pageAddr, (int)(off + 1)));
            }
            case 4: {
                return ValueInt.get((int)PageUtils.getInt((long)pageAddr, (int)(off + 1)));
            }
            case 5: {
                return ValueLong.get((long)PageUtils.getLong((long)pageAddr, (int)(off + 1)));
            }
            case 8: {
                return ValueFloat.get((float)Float.intBitsToFloat(PageUtils.getInt((long)pageAddr, (int)(off + 1))));
            }
            case 7: {
                return ValueDouble.get((double)Double.longBitsToDouble(PageUtils.getLong((long)pageAddr, (int)(off + 1))));
            }
            case 9: {
                return ValueTime.fromNanos((long)PageUtils.getLong((long)pageAddr, (int)(off + 1)));
            }
            case 10: {
                return ValueDate.fromDateValue((long)PageUtils.getLong((long)pageAddr, (int)(off + 1)));
            }
            case 11: {
                return ValueTimestamp.fromDateValueAndNanos((long)PageUtils.getLong((long)pageAddr, (int)(off + 1)), (long)PageUtils.getLong((long)pageAddr, (int)(off + 9)));
            }
            case 20: {
                return ValueUuid.get((long)PageUtils.getLong((long)pageAddr, (int)(off + 1)), (long)PageUtils.getLong((long)pageAddr, (int)(off + 9)));
            }
            case 13: {
                return ValueString.get((String)new String(InlineIndexHelper.readBytes(pageAddr, off), CHARSET));
            }
            case 21: {
                return ValueStringFixed.get((String)new String(InlineIndexHelper.readBytes(pageAddr, off), CHARSET));
            }
            case 14: {
                return ValueStringIgnoreCase.get((String)new String(InlineIndexHelper.readBytes(pageAddr, off), CHARSET));
            }
            case 12: {
                return ValueBytes.get((byte[])InlineIndexHelper.readBytes(pageAddr, off));
            }
        }
        throw new UnsupportedOperationException("no get operation for fast index type " + type);
    }

    private static byte[] readBytes(long pageAddr, int off) {
        int size = PageUtils.getShort((long)pageAddr, (int)(off + 1)) & Short.MAX_VALUE;
        return PageUtils.getBytes((long)pageAddr, (int)(off + 3), (int)size);
    }

    protected boolean isValueFull(long pageAddr, int off) {
        switch (this.type) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                return true;
            }
            case 12: 
            case 13: 
            case 14: 
            case 21: {
                return (PageUtils.getShort((long)pageAddr, (int)(off + 1)) & 0x8000) == 0;
            }
        }
        throw new UnsupportedOperationException("no get operation for fast index type " + this.type);
    }

    public int compare(long pageAddr, int off, int maxSize, Value v, Comparator<Value> comp) {
        Value v1 = this.get(pageAddr, off, maxSize);
        if (v1 == null) {
            return -2;
        }
        int c = comp.compare(v1, v);
        int n = c != 0 ? (c > 0 ? 1 : -1) : (c = 0);
        if (this.size > 0) {
            return InlineIndexHelper.fixSort(c, this.sortType());
        }
        if (this.isValueFull(pageAddr, off) || this.canRelyOnCompare(c, v1, v)) {
            return InlineIndexHelper.fixSort(c, this.sortType());
        }
        return -2;
    }

    public int put(long pageAddr, int off, Value val, int maxSize) {
        if (this.size > 0 && this.size + 1 > maxSize) {
            return 0;
        }
        if (this.size < 0 && maxSize < 4) {
            PageUtils.putByte((long)pageAddr, (int)off, (byte)-1);
            return 0;
        }
        if (val.getType() == 0) {
            PageUtils.putByte((long)pageAddr, (int)off, (byte)0);
            return 1;
        }
        if (val.getType() != this.type) {
            throw new UnsupportedOperationException("value type doesn't match");
        }
        switch (this.type) {
            case 1: {
                PageUtils.putByte((long)pageAddr, (int)off, (byte)((byte)val.getType()));
                PageUtils.putByte((long)pageAddr, (int)(off + 1), (byte)((byte)(val.getBoolean() != false ? 1 : 0)));
                return this.size + 1;
            }
            case 2: {
                PageUtils.putByte((long)pageAddr, (int)off, (byte)((byte)val.getType()));
                PageUtils.putByte((long)pageAddr, (int)(off + 1), (byte)val.getByte());
                return this.size + 1;
            }
            case 3: {
                PageUtils.putByte((long)pageAddr, (int)off, (byte)((byte)val.getType()));
                PageUtils.putShort((long)pageAddr, (int)(off + 1), (short)val.getShort());
                return this.size + 1;
            }
            case 4: {
                PageUtils.putByte((long)pageAddr, (int)off, (byte)((byte)val.getType()));
                PageUtils.putInt((long)pageAddr, (int)(off + 1), (int)val.getInt());
                return this.size + 1;
            }
            case 5: {
                PageUtils.putByte((long)pageAddr, (int)off, (byte)((byte)val.getType()));
                PageUtils.putLong((long)pageAddr, (int)(off + 1), (long)val.getLong());
                return this.size + 1;
            }
            case 8: {
                PageUtils.putByte((long)pageAddr, (int)off, (byte)((byte)val.getType()));
                PageUtils.putInt((long)pageAddr, (int)(off + 1), (int)Float.floatToIntBits(val.getFloat()));
                return this.size + 1;
            }
            case 7: {
                PageUtils.putByte((long)pageAddr, (int)off, (byte)((byte)val.getType()));
                PageUtils.putLong((long)pageAddr, (int)(off + 1), (long)Double.doubleToLongBits(val.getDouble()));
                return this.size + 1;
            }
            case 9: {
                PageUtils.putByte((long)pageAddr, (int)off, (byte)((byte)val.getType()));
                PageUtils.putLong((long)pageAddr, (int)(off + 1), (long)((ValueTime)val).getNanos());
                return this.size + 1;
            }
            case 10: {
                PageUtils.putByte((long)pageAddr, (int)off, (byte)((byte)val.getType()));
                PageUtils.putLong((long)pageAddr, (int)(off + 1), (long)((ValueDate)val).getDateValue());
                return this.size + 1;
            }
            case 11: {
                PageUtils.putByte((long)pageAddr, (int)off, (byte)((byte)val.getType()));
                PageUtils.putLong((long)pageAddr, (int)(off + 1), (long)((ValueTimestamp)val).getDateValue());
                PageUtils.putLong((long)pageAddr, (int)(off + 9), (long)((ValueTimestamp)val).getTimeNanos());
                return this.size + 1;
            }
            case 20: {
                PageUtils.putByte((long)pageAddr, (int)off, (byte)((byte)val.getType()));
                PageUtils.putLong((long)pageAddr, (int)(off + 1), (long)((ValueUuid)val).getHigh());
                PageUtils.putLong((long)pageAddr, (int)(off + 9), (long)((ValueUuid)val).getLow());
                return this.size + 1;
            }
            case 13: 
            case 14: 
            case 21: {
                byte[] s = val.getString().getBytes(CHARSET);
                short size = s.length + 3 <= maxSize ? (short)s.length : (short)((s = InlineIndexHelper.trimUTF8(s, maxSize - 3)) == null ? 0 : s.length | 0x8000);
                if (s == null) {
                    PageUtils.putByte((long)pageAddr, (int)off, (byte)-1);
                    return 0;
                }
                PageUtils.putByte((long)pageAddr, (int)off, (byte)((byte)val.getType()));
                PageUtils.putShort((long)pageAddr, (int)(off + 1), (short)size);
                PageUtils.putBytes((long)pageAddr, (int)(off + 3), (byte[])s);
                return s.length + 3;
            }
            case 12: {
                short size;
                PageUtils.putByte((long)pageAddr, (int)off, (byte)((byte)val.getType()));
                if (val.getBytes().length + 3 <= maxSize) {
                    size = (short)val.getBytes().length;
                    PageUtils.putShort((long)pageAddr, (int)(off + 1), (short)size);
                    PageUtils.putBytes((long)pageAddr, (int)(off + 3), (byte[])val.getBytes());
                } else {
                    size = (short)(maxSize - 3 | 0x8000);
                    PageUtils.putShort((long)pageAddr, (int)(off + 1), (short)size);
                    PageUtils.putBytes((long)pageAddr, (int)(off + 3), (byte[])Arrays.copyOfRange(val.getBytes(), 0, maxSize - 3));
                }
                return size + 3;
            }
        }
        throw new UnsupportedOperationException("no get operation for fast index type " + this.type);
    }

    public static byte[] trimUTF8(byte[] bytes, int limit) {
        if (bytes.length <= limit) {
            return bytes;
        }
        for (int i = limit; i > 0; --i) {
            if ((bytes[i] & 0xC0) == 128) continue;
            byte[] res = new byte[i];
            System.arraycopy(bytes, 0, res, 0, i);
            return res;
        }
        return null;
    }

    protected boolean canRelyOnCompare(int c, Value shortVal, Value v2) {
        switch (this.type) {
            case 12: 
            case 13: 
            case 14: 
            case 21: {
                int l2;
                int l1;
                if (shortVal.getType() == 0 || v2.getType() == 0) {
                    return true;
                }
                if (c == 0 && shortVal.getType() != 0 && v2.getType() != 0) {
                    return false;
                }
                if (this.type == 12) {
                    l1 = shortVal.getBytes().length;
                    l2 = v2.getBytes().length;
                } else {
                    l1 = shortVal.getString().length();
                    l2 = v2.getString().length();
                }
                return c >= 0 || l1 > l2;
            }
        }
        return true;
    }

    public static int fixSort(int c, int sortType) {
        return sortType == 0 ? c : -c;
    }
}

