/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.h2;

import java.sql.PreparedStatement;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.ignite.internal.util.typedef.internal.U;

public class H2StatementCache
extends LinkedHashMap<String, PreparedStatement> {
    private int size;
    private volatile long lastUsage;

    H2StatementCache(int size) {
        super(size, 0.75f, true);
        this.size = size;
    }

    @Override
    protected boolean removeEldestEntry(Map.Entry<String, PreparedStatement> eldest) {
        boolean rmv;
        boolean bl = rmv = this.size() > this.size;
        if (rmv) {
            PreparedStatement stmt = eldest.getValue();
            U.closeQuiet((AutoCloseable)stmt);
        }
        return rmv;
    }

    public long lastUsage() {
        return this.lastUsage;
    }

    public void updateLastUsage() {
        this.lastUsage = U.currentTimeMillis();
    }
}

